﻿using iTextSharp.text;
using iTextSharp.text.pdf;
using NVCC.Models;
using System.Collections.Generic;
using System.IO;
using System.Linq;

namespace NVCC.WebUI.Infrastructure
{
    public class CombinePdfService : ICombinePdfService
    {
        public string CombinePdfs(string refDocPdfPath, IEnumerable<UploadedFile> attachedPdfs)
        {
            if (attachedPdfs == null || !attachedPdfs.Any())
            {
                return refDocPdfPath;
            }
            var combinedPdfPath = Path.GetTempFileName();

            //CreateMergedPDF(combinedPdfPath, refDocPdfPath, attachedPdfs.Select(p => p.FullPath));

            var fileNameList = new List<string>();
            fileNameList.Add(refDocPdfPath);
            fileNameList.AddRange(attachedPdfs.Select(p => p.FullPath));

            MergePdfFiles(combinedPdfPath, fileNameList.ToArray());


            return combinedPdfPath;
        }
       

        ///Credit for this method goes to Md Kamruzzaman Sarker for his answer at https://stackoverflow.com/a/11044823
        private void MergePdfFiles(string outputPdf, string[] sourcePdfs)
        {
            PdfReader reader = null;
            Document document = new Document();
            PdfImportedPage page = null;
            PdfCopy pdfCpy = null;
            int n = 0;
            int totalPages = 0;
            int page_offset = 0;
            List<Dictionary<string, object>> bookmarks = new List<Dictionary<string, object>>();
            IList<Dictionary<string, object>> tempBookmarks;
            for (int i = 0; i <= sourcePdfs.GetUpperBound(0); i++)
            {
                reader = new PdfReader(sourcePdfs[i]);
                reader.ConsolidateNamedDestinations();
                n = reader.NumberOfPages;
                tempBookmarks = SimpleBookmark.GetBookmark(reader);

                if (i == 0)
                {
                    document = new iTextSharp.text.Document(reader.GetPageSizeWithRotation(1));
                    pdfCpy = new PdfCopy(document, new FileStream(outputPdf, FileMode.Create));
                    document.Open();
                    SimpleBookmark.ShiftPageNumbers(tempBookmarks, page_offset, null);
                    page_offset += n;
                    if (tempBookmarks != null)
                        bookmarks.AddRange(tempBookmarks);
                    //  MessageBox.Show(n.ToString());
                    totalPages = n;
                }
                else
                {
                    SimpleBookmark.ShiftPageNumbers(tempBookmarks, page_offset, null);
                    if (tempBookmarks != null)
                        bookmarks.AddRange(tempBookmarks);

                    page_offset += n;
                    totalPages += n;
                }

                for (int j = 1; j <= n; j++)
                {
                    page = pdfCpy.GetImportedPage(reader, j);
                    pdfCpy.AddPage(page);

                }
                reader.Close();

            }
            pdfCpy.Outlines = bookmarks;
            document.Close();
        }

        //This method does not preserve bookmarks:
        //private void CreateMergedPDF(string targetPDF, string refDocPath, IEnumerable<string> pdfFilePaths)
        //{
        //    using (FileStream stream = new FileStream(targetPDF, FileMode.Create))
        //    {
        //        Document pdfDoc = new Document(PageSize.LETTER);
        //        PdfSmartCopy pdf = new PdfSmartCopy(pdfDoc, stream);
        //        pdfDoc.Open();

        //        pdf.AddDocument(new PdfReader(refDocPath));

        //        foreach (var pdfFilePath in pdfFilePaths)
        //        {
        //            pdf.AddDocument(new PdfReader(pdfFilePath));
        //        }

        //        if (pdfDoc != null)
        //            pdfDoc.Close();
        //    }
        //}

    }
}