﻿using Moq;
using NUnit.Framework;
using NVCC.Models;
using NVCC.WebUI.Controllers;
using NVCC.WebUI.Infrastructure;
using System.Web;
using System.Web.Mvc;

namespace NVCC.WebUI.Tests.Controllers
{
    [TestFixture]
    public class PatientProfileControllerTests
    {
        private Mock<IPatientProfileService> _patientProfileServiceMock;
        private Mock<IUserService> _userServiceMock;
        private Mock<ICombinePdfService> _combinePdfServiceMock;
        private Mock<IAodService> _aodServiceMock;
        private HttpContextBase _context;
        private PatientProfileController _controller;

        [SetUp]
        public void TestSetUp()
        {
            _userServiceMock = new Mock<IUserService>();
            _patientProfileServiceMock = new Mock<IPatientProfileService>();
            _aodServiceMock = new Mock<IAodService>();
            _combinePdfServiceMock = new Mock<ICombinePdfService>();

            _patientProfileServiceMock.Setup(m => m.GetPatientProfile(It.IsAny<Patient>(), It.IsAny<ViaUser>())).Returns(FakeDataManager.GetPatientProfile());

            _controller = new PatientProfileController(_patientProfileServiceMock.Object,
                                                       _userServiceMock.Object, _aodServiceMock.Object, _combinePdfServiceMock.Object);
            _context = FakeHttpContext.GetMockedHttpContext();
            HttpContextManager.SetCurrentContext(_context);
        }

        [Test]
        public void PatientProfile_IndexHttpGetNullPatientSid_RedirectToHome()
        {
            // Arrange
            // Act
            var result = _controller.Index(null);
            // Assert
            Assert.IsNotNull(result);
            Assert.IsInstanceOf(typeof(RedirectToRouteResult), result);
            Assert.AreEqual("Index", ((RedirectToRouteResult)result).RouteValues["action"].ToString());
            Assert.AreEqual("Home", ((RedirectToRouteResult)result).RouteValues["controller"].ToString());
        }

        [Test]
        public void PatientProfile_IndexHttpGetInvalidPatientSid_RedirectsToIndex()
        {
            // Arrange

            // Act
            var result = _controller.Index(1234);
            // Assert
            Assert.IsNotNull(result);
            Assert.IsInstanceOf(typeof(RedirectToRouteResult), result);
            Assert.AreEqual("Index", ((RedirectToRouteResult)result).RouteValues["action"].ToString());
            Assert.AreEqual("Home", ((RedirectToRouteResult)result).RouteValues["controller"].ToString());
        }

        [Test]
        public void PatientProfile_IndexHttpGetValidPatientSid_RedirectsToSelect()
        {
            // Arrange
            _userServiceMock.Setup(m => m.GetUser()).Returns(FakeDataManager.GetUser());
            _userServiceMock.Setup(m => m.GetViaUser(It.IsAny<short>())).Returns(FakeDataManager.GetViaUser(true));
            // Act
            var result = _controller.Index(99);
            // Assert
            Assert.IsNotNull(result);
            Assert.IsInstanceOf(typeof(RedirectToRouteResult), result);
            Assert.AreEqual("Select", ((RedirectToRouteResult)result).RouteValues["action"].ToString());
        }

    }
}
