using System;
using NVCC.Models;
using System.Data.Entity;
using System.Data.Entity.Infrastructure;

namespace NVCC.Repos.PatientRepository
{
    public partial class NwicPanelMgmtModel : DbContext
    {
        public NwicPanelMgmtModel()
            : base("name=NwicPanelMgmtModel")
        {
            ((IObjectContextAdapter)this).ObjectContext.CommandTimeout = 90; //default=30

        }
        public virtual DbSet<Patient> Patients { get; set; }
        public virtual DbSet<SsnToSid> SsnToSids { get; set; }
        public virtual DbSet<UspMedication> UspMedications { get; set; }
        public virtual DbSet<UspProblemDiagnosis> UspProblemDiagnoses { get; set; }
        public virtual DbSet<UspAppointment> UspAppointments { get; set; }
        public virtual DbSet<UspNonVaMedication> UspNonVaMedications { get; set; }
        public virtual DbSet<UspAllergy> UspAllergies { get; set; }
        public virtual DbSet<UspLab> UspLabs { get; set; }
        public virtual DbSet<UspConsult> UspConsults { get; set; }
        public virtual DbSet<LogItem> LogItems { get; set; }
        public virtual DbSet<UsageReportParametersSta3n> GetUsageParametersSta3n { get; set; }
        public virtual DbSet<UsageReportParametersUser> GetUsageParametersUser { get; set; }
        public virtual DbSet<UspCurrentUsage> GetCurrentUsage { get; set; }
        public virtual DbSet<UspAnnouncement> GetAnnouncement { get; set; }
        public virtual DbSet<AnnouncementItem> AnnouncementItems { get; set; }
        public virtual DbSet<ActiveUserCount> ActiveUserCount { get; set; }
        public virtual DbSet<UserCounts> GetUserCounts { get; set; }
        public virtual DbSet<UspUniqueVeteran> UspUniqueVeterans { get; set; }

        protected override void OnModelCreating(DbModelBuilder modelBuilder)
        {
            modelBuilder.Entity<Patient>().ToTable("NVCC_usp_GetPatientBySid", "App");
            modelBuilder.Entity<SsnToSid>().ToTable("AllCDWPatients", "App");    
            modelBuilder.Entity<NonVaMedication>().ToTable("NVCC_vGetNVAMeds", "App");
            modelBuilder.Entity<UspMedication>().ToTable("NVCC_usp_GetVAMeds", "App");
            modelBuilder.Entity<UspProblemDiagnosis>().ToTable("NVCC_usp_GetProbs", "App");
            modelBuilder.Entity<UspAppointment>().ToTable("NVCC_usp_GetAppts", "App");
            modelBuilder.Entity<UspNonVaMedication>().ToTable("NVCC_usp_GetNVAMeds", "App");
            modelBuilder.Entity<UspAllergy>().ToTable("NVCC_usp_GetAllergies", "App");
            modelBuilder.Entity<UspLab>().ToTable("NVCC_usp_GetLabs", "App");
            modelBuilder.Entity<UspConsult>().ToTable("NVCC_usp_GetConsults", "App");
            modelBuilder.Entity<LogItem>().ToTable("NVCC_AccessLog", "App");
            modelBuilder.Entity<UsageReportParametersSta3n>().ToTable("NVCC_usp_ProductionAccessLogUniqueSta3n", "App");
            modelBuilder.Entity<UsageReportParametersUser>().ToTable("NVCC_usp_ProductionAccessLogUniqueUsers", "App");
            modelBuilder.Entity<UspCurrentUsage>().ToTable("NVCC_usp_CurrentUsage", "App");
            modelBuilder.Entity<UspAnnouncement>().ToTable("NVCC_usp_GetAnnouncement", "App");
            modelBuilder.Entity<AnnouncementItem>().ToTable("NVCC_Announcement", "App");
            modelBuilder.Entity<ActiveUserCount>().ToTable("NVCC_udf_ActiveUserCount", "App");
            modelBuilder.Entity<UserCounts>().ToTable("NVCC_usp_UserCounts", "App");
            modelBuilder.Entity<UspUniqueVeteran>().ToTable("NVCC_usp_UniqueVeterans", "App");
            modelBuilder.Entity<Patient>().HasKey(f => f.PatientSid);
            modelBuilder.Entity<SsnToSid>().HasKey(f => f.PatientSid);
            modelBuilder.Entity<UspMedication>().HasKey(f => f.rxoutpatsid);
            modelBuilder.Entity<UspProblemDiagnosis>().HasKey(f => f.ProblemListSID);
            modelBuilder.Entity<UspAppointment>().HasKey(f => f.AppointmentSID);
            modelBuilder.Entity<UspNonVaMedication>().HasKey(f => f.NonVaMedSID);
            modelBuilder.Entity<UspAllergy>().HasKey(f => f.AllergySID);
            modelBuilder.Entity<UspLab>().HasKey(f => f.LabChemSID);
            modelBuilder.Entity<UspConsult>().HasKey(f => f.Consultsid);
            modelBuilder.Entity<UspConsult>().Ignore(f => f.ConsultText);
            modelBuilder.Entity<LogItem>().HasKey(f => f.AccessLogID);
            modelBuilder.Entity<UsageReportParametersSta3n>().HasKey(f => f.Sta3n);
            modelBuilder.Entity<UsageReportParametersUser>().HasKey(f => f.userID);
            modelBuilder.Entity<UspCurrentUsage>().HasKey(f => new
            {
                f.HostName,
                f.UserID
            });
            modelBuilder.Entity<UspAnnouncement>().HasKey(f => f.AnnouncementID);
            modelBuilder.Entity<AnnouncementItem>().HasKey(f => f.AnnouncementID);
            modelBuilder.Entity<ActiveUserCount>().HasKey(f => f.Station);
            modelBuilder.Entity<UserCounts>().HasKey(f => f.ActiveSites);
            modelBuilder.Entity<UspUniqueVeteran>().HasKey(f => f.ID);
        }
    }
}
