﻿using System;
using System.Globalization;

namespace NVCC.Repos.MdwsRepository.Utilities
{
    public class MdwsDataUtilities
    {
        public static string DatetoCprsFormat(DateTime aDate)
        {
            return aDate.ToString("yyyyMMdd.HHmmss");
        }

        public static DateTime? CprsFormattoDate(string aDate)
        {
            try
            {
                if (aDate.Substring(9, 2).Equals("24"))
                {
                    aDate = aDate.Replace(".240000", ".235959");
                }
                return DateTime.ParseExact(aDate, "yyyyMMdd.HHmmss", CultureInfo.InvariantCulture);
            }
            catch (Exception)
            {
                return null;
            }
        }
    }
}
