﻿using NVCC.Models;
using System.Collections.Generic;
using System.Data.Entity;
using System.Data.Entity.Infrastructure;
using System.Data.SqlClient;
using System.Linq;

namespace NVCC.Repos.AodRepository
{
    public partial class AodContext : DbContext
    {
        public AodContext()
            : base("name=NwicPanelMgmtModel")
        {
            ((IObjectContextAdapter)this).ObjectContext.CommandTimeout = 90; //default=30

        }
        public virtual DbSet<Disclosure> Disclosures { get; set; }
        public virtual DbSet<Nature> Natures { get; set; }
        public virtual DbSet<AdditionalObject> AdditionalObjects { get; set; }
        public virtual DbSet<DisclosedAppointment> DisclosedAppointments { get; set; }
        public virtual DbSet<DisclosedAuthorization> DisclosedAuthorizations { get; set; }
        public virtual DbSet<DisclosedProblemDiagnosis> DisclosedProblemDiagnoses { get; set; }
        public virtual DbSet<DisclosedProgressNote> DisclosedProgressNotes { get; set; }
        public virtual DbSet<DisclosedRadiologyReport> DisclosedRadiologyReports { get; set; }
        public virtual DbSet<DisclosedConsult> DisclosedConsults { get; set; }


        public List<UserByFacility> GetUsersByFacilityId(int sta6a)
        {
            List<UserByFacility> resultList = new List<UserByFacility>();
            var resultSet = Database.SqlQuery<UserByFacility>("EXEC App.NVCC_usp_Get_UsersByFacility @sta6a", new SqlParameter("sta6a", sta6a));
            foreach (var user in resultSet)
            {
                resultList.Add(user);
            }
            return resultList.OrderBy(r => r.GivenName).ToList();
        }

        protected override void OnModelCreating(DbModelBuilder modelBuilder)
        {
            modelBuilder.Entity<Disclosure>()
                .ToTable("NVCC_Disclosure", "App")
                .HasKey(f => f.DisclosureId)
                .Ignore(f => f.StatementOfPurpose);

            modelBuilder.Entity<Nature>()
                .ToTable("NVCC_Nature", "App")
                .HasKey(f => f.NatureId);

            modelBuilder.Entity<AdditionalObject>()
                .ToTable("NVCC_AdditionalObject", "App")
                .HasKey(f => f.AdditionalObjectId);

            modelBuilder.Entity<DisclosedAppointment>()
                .ToTable("NVCC_DisclosedAppointment", "App")
                .HasKey(f => f.DisclosedAppointmentId);

            modelBuilder.Entity<DisclosedAuthorization>()
                .ToTable("NVCC_DisclosedAuthorization", "App")
                .HasKey(f => f.DisclosedAuthorizationId);

            modelBuilder.Entity<DisclosedProblemDiagnosis>()
                .ToTable("NVCC_DisclosedProblemDiagnosis", "App")
                .HasKey(f => f.DisclosedProblemDiagnosisId);

            modelBuilder.Entity<DisclosedProgressNote>()
                .ToTable("NVCC_DisclosedProgressNote", "App")
                .HasKey(f => f.DisclosedProgressNoteId);

            modelBuilder.Entity<DisclosedRadiologyReport>()
                .ToTable("NVCC_DisclosedRadiologyReport", "App")
                .HasKey(f => f.DisclosedRadiologyReportId);

            modelBuilder.Entity<DisclosedConsult>()
                .ToTable("NVCC_DisclosedConsult", "App")
                .HasKey(f => f.DisclosedConsultId);

            modelBuilder.Entity<Disclosure>()
                .HasMany(x => x.AdditionalObjects)
                .WithRequired()
                .HasForeignKey(x => x.DisclosureId)
                .WillCascadeOnDelete();

            modelBuilder.Entity<Disclosure>()
                .HasMany(x => x.DisclosedAppointments)
                .WithRequired()
                .HasForeignKey(x => x.DisclosureId)
                .WillCascadeOnDelete();

            modelBuilder.Entity<Disclosure>()
                .HasMany(x => x.DisclosedAuthorizations)
                .WithRequired()
                .HasForeignKey(x => x.DisclosureId)
                .WillCascadeOnDelete();

            modelBuilder.Entity<Disclosure>()
                .HasMany(x => x.DisclosedProblemDiagnoses)
                .WithRequired()
                .HasForeignKey(x => x.DisclosureId)
                .WillCascadeOnDelete();

            modelBuilder.Entity<Disclosure>()
                .HasMany(x => x.DisclosedProgressNotes)
                .WithRequired()
                .HasForeignKey(x => x.DisclosureId)
                .WillCascadeOnDelete();

            modelBuilder.Entity<Disclosure>()
                .HasMany(x => x.DisclosedRadiologyReports)
                .WithRequired()
                .HasForeignKey(x => x.DisclosureId)
                .WillCascadeOnDelete();

            modelBuilder.Entity<Disclosure>()
                .HasMany(x => x.DisclosedConsults)
                .WithRequired()
                .HasForeignKey(x => x.DisclosureId)
                .WillCascadeOnDelete();

            modelBuilder.Entity<Disclosure>()
                .HasMany(x => x.Natures)
                .WithMany()
                .Map(m =>
                {
                    m.ToTable("NVCC_DisclosureNature", "App");
                    m.MapLeftKey("DisclosureId");
                    m.MapRightKey("NatureId");
                });
        }
    }
}