﻿using System;
using System.Text;

namespace NVCC.Models
{
    [Serializable]
    public class UspConsult
    {
        public short Sta3n { get; set; }
        public string StationName { get; set; }
        public string ToRequestServiceName { get; set; }
        public Nullable<System.DateTime> RequestDate { get; set; }
        public string CPRSStatus { get; set; }
        public Nullable<long> CPRSOrderSID { get; set; }
        public long Consultsid { get; set; }
        public string ConsultIEN { get; set; }
        public Nullable<int> PatientSID { get; set; }
        public Nullable<int> ToRequestServiceSID { get; set; }
        public string RequestType { get; set; }
        public Nullable<int> OrderStatusSID { get; set; }
        public Nullable<int> RecentActivityTypeSID { get; set; }
        public string RecentActivityType { get; set; }
        public Nullable<int> SendingStaffSID { get; set; }
        public string Urgency { get; set; }
        public string InpatOutpat { get; set; }
        private string InpatOutpatFullWord { get { if (InpatOutpat == "O") return "OUTPATIENT"; else if(InpatOutpat=="I") return "INPATIENT"; else return "UNKNOWN";} }
        public string ProvDx { get; set; }
        public string ProvDxCode { get; set; }
        public Nullable<long> TIUDocumentSID { get; set; }
        public Nullable<System.DateTime> EarliestDate { get; set; }
        public string ConsultReason { get; set; }
        public string FromService { get; set; }
        public string RequestingProvider { get; set; }
        public string PrimaryProvider { get; set; }
        public string Team { get; set; }
        public string PrimaryEligibility { get; set; }

        public string ConsultText
        {
            get
            {
                StringBuilder consultText = new StringBuilder();
                consultText.Append("\n");
                consultText.Append("Current PC Provider:   " + PrimaryProvider + "\n");
                consultText.Append("Current PC Team:   " + Team + "\n");
                consultText.Append("Primary Eligibility:   " + PrimaryEligibility + "\n");
                consultText.Append("\nOrder Information \n");
                consultText.Append("To Service:   " + ToRequestServiceName + "\n");
                consultText.Append("From Service:   " + FromService + "\n");
                consultText.Append("Requesting Provider:   " + RequestingProvider + "\n");
                consultText.Append("Service is to be rendered on an " + InpatOutpatFullWord + " basis\n");
                consultText.Append("Urgency:   " + Urgency + "\n");
                consultText.Append("Earliest Appr. Date:   " + EarliestDate + "\n");
                if (!string.IsNullOrWhiteSpace(ProvDxCode))
                    consultText.Append("Provisional Diagnosis:   " + ProvDx + " (ICD-10-CM " + ProvDxCode + ") \n");
                else
                    consultText.Append("Provisional Diagnosis:   " + ProvDx + "\n");

                consultText.Append("Reason For Request:\n");
                consultText.Append(ConsultReason);
                return consultText.ToString();
            } 
        }
    }
}
