﻿using System.Collections.Generic;

namespace NVCC.Models
{
    public interface IPatientRepository
    {
        Patient GetPatient(int? patientSid);
        Patient GetPatient(string patientSsn, short sta3n);
        IEnumerable<Patient> GetPatients(string patientSsn);
        IEnumerable<BasicPatient> GetPatientsByNameAndSsn(string lastFourOfSsn, string lastNameStartsWith, string firstFiveOfSocial = null, string firstNameStartsWith = null);
        IList<ProblemDiagnosis> GetProblemList(int patientSid);
        IList<Appointment> GetAppointments(int patientSid);
        IList<Medication> GetMedications(int patientSid);
        IList<NonVaMedication> GetNonVaMedications(int patientSid);
        IList<Allergy> GetAllergies(int patientSid);
        IList<Lab> GetLabs(int patientSid);
        IList<UspConsult> GetConsults(int patientSid);
        void WriteLog(LogItem logItem);
        IList<UspUsageData> UsageData(string timeGroup, string statistic, string sta3n, string userID);
        IList<UsageReportParametersSta3n> GetUsageParametersSta3n();
        IList<UsageReportParametersUser> GetUsageParametersUser();
        IList<UspCurrentUsage> GetCurrentUsage(int timeframe);
        NextOfKin GetNextOfKin(int patientSid);
        IList<UspAnnouncement> GetAnnouncements(int active);
        void WriteAnnouncement(AnnouncementItem announcementItem);
        IList<ActiveUserCount> GetActiveUserCount();
        IList<UserCounts> GetUserCounts();
        IList<UspUniqueVeteran> GetUniqueVeterans();
    }
}
