﻿using System;
using System.Collections.Generic;

namespace NVCC.Models
{
    public interface IAodRepository
    {
        void SaveAodInfo(Disclosure disclosure);
        List<Nature> GetAllNatures();

        List<Disclosure> GetPatientDisclosures(string patientICN, DateTime? startDate = null, DateTime? endDate = null);

        Disclosure GetDisclosureById(int disclosureId);

        IEnumerable<ROIAdminSearch> GetRoiAdminSearchResults(short sta3n, short visn, DateTime? startDate, DateTime? endDate, string userName);

        List<UserByFacility> GetUsersByFacilityId(int sta6a);

        Disclosure EditDisclosureMadeTo(Disclosure editedDisclosure, bool isRoiAdmin, string userId);
    }
}
