﻿using System;

namespace NVCC.Models
{
    public class DisclosedConsult
    {
        public DisclosedConsult() { }

        public DisclosedConsult(UspConsult consult)
        {
            ConsultId = consult.Consultsid;
            RequestDate = consult.RequestDate;
            CPRSStatus = consult.CPRSStatus;
            EarliestDate = consult.EarliestDate;
            Urgency = consult.Urgency;
        }
        
        public long DisclosedConsultId { get; set; }
        public int DisclosureId { get; set; }

        /// <summary>
        /// Note: This is actually the Consult SID... UspConsult.Consultsid... it got named incorrectly and with
        /// all the different branches and our time constraints, I don't want to rename it now to avoid problems.
        /// </summary>
        public long ConsultId { get; set; }
        public DateTime? RequestDate { get; set; }
        public string CPRSStatus { get; set; }
        public DateTime? EarliestDate { get; set; }
        public string Urgency { get; set; }
    }
}
