﻿# Steps to deploy a new version from development

1. Make sure you are on the `develop` branch and are up to date with what is on the remote git/TFS server
    * `git checkout develop`
    * `git fetch`
    * `git status`

        You should see "Your branch is up-to-date with 'origin/develop'". Additionally, there should be no modified file or staged files. Untracked files are allowed so long as you are sure they are not needed to be recorded in the project repository.

        If you are not up to date, you may need to do a `git pull` and possibly resolve conflicts, pushing your result back to the remote git/TFS server.
2. Branch from `develop` into `release-X.Y.Z` where `X.Y.Z` is the to-be-released version number
    * `git checkout -b release-X.Y.Z`
3. Update version number and release date in code and verify version history
    * In NVCC.WebUI/Views/Help/About.cshtml, the version number and release date are hard-coded near the top
    * In NVCC.WebUI/Views/Help/News.cshtml, review the descriptions of the changes from the previous version. This description is intended for the end-user audience and should be written in language appropriate for that audience. Every version should have at least one entry describing what changed.
    * Commit these files to the release branch.
4. Merge the release branch back into `develop` and push `develop` to the remote origin
    * `git checkout develop`
    * `git merge --no-ff release-X.Y.Z`

        Resolve any conflicts.

    * `git push origin develop`

        Resolve any conflicts.
4. Back-up the existing version on the production server. Open `\\SERVER` in Explorer. Right-click on the `NVCC` directory and select "Send to" -> "Compressed (zip) folder". After the "Compressing..." dialog finishes, change the resulting filename `NVCC.zip` to `NVCC_N.N.N_YYYYMMDD` where `N.N.N` is the _previous_ version number and `YYYYMMDD` is the _current_ date in four-digit year, month, day format (without delimiters). (e.g. `NVCC_1.6.2_20160916.zip`)
5. Deployment. Change back to the release branch and publish to production.
    * `git checkout release-X.Y.Z`
    * From Visual Studio, Build -> Publish selecting Production
    * Any permissions needed to be checked?
6. If any changes were needed to be able to publish, commit these changes to the release branch and then merge these changes back into develop (see above step for details). Hopefully, this step should not be necessary.
7. Merge the release branch into `master`
    * `git checkout master`
    * `git merge --no-ff release-X.Y.Z`

        There should not be any conflicts with this.
8. Tag the master branch with a tag of the format `vX.Y.Z`. Give it the commit message "Version X.Y.Z"
    * `git tag -a -m "Version X.Y.Z" vX.Y.Z`
9. Push the master branch to the remote origin, including the new tag.
    * `git push --tags origin master`
10. Change back to develop branch to guard against inadvertent commits to the master branch.
    * `git checkout develop`
11. Delete the release branch since it has been completely merged into both develop and master
    * `git branch -d release-X.Y.Z`
12. Notify users of updated version. Include the most recent changes that are listed in News.cshtml. (what protocol?)

# Steps to re-deploy the current release

1. Checkout the `master` branch of the repository
    * `git checkout master`
2. Verify the checkout is clean and up-to-date
    * `git fetch --tags`
    * `git status`

        You should see "Your branch is up-to-date with 'origin/master'". Additionally, there should be no modified file or staged files. Untracked files are allowed so long as you are sure they are not needed to be recorded in the project repository.
3. Deployment
    * From Visual Studio, Build -> Publish selecting Production

# Steps to rollback to a previous release

1. Make sure you have the most recent updates from the central repository
    * `git fetch --tags`
2. Determine the tag corresponding to the version you want to rollback to. A list of all the tagged versions can be gotten with
    * `git tag --list -n`

    or more detail (including tag date and message) with
    * `git for-each-ref --format="%(refname:short) %(taggerdate) %(subject)" refs/tags`
3. Checkout the appropriate tag based on its short tag name
    * `git checkout vX.Y.Z`

    You will get a message like

        Note: checking out 'v1.6.0'.

        You are in 'detached HEAD' state. You can look around, make experimental
        changes and commit them, and you can discard any commits you make in this
        state without impacting any branches by performing another checkout.

        If you want to create a new branch to retain commits you create, you may
        do so (now or later) by using -b with the checkout command again. Example:

          git checkout -b <new-branch-name>

        HEAD is now at 12ade2d... Merge branch 'release-1.6.0'

    with tags, SHA's and messages appropriate to your release
4. Deployment
    * From Visual Studio, Build -> Publish selecting Production
5. Return your working directory to a usable state (`develop` or whatever branch you were working on)
    * `git checkout develop`

# Steps to create a hotfix

A hotfix differs from a regular release in that it is an urgent, typically small change to the tool. It specifically is not to include any of the development that has been done (and merged into `develop`) since the last release. Typically, the decision that a hotfix is needed is made even before any code that will go into the hotfix is written. A hotfix starts from `master`, and its changes will go both into `master` for production and `develop` so that they are not lost in later version.

1. Make sure you have a clean repository; stash active changes on your active branch, if any
2. Checkout the `master` branch of the repository
    * `git checkout master`
3. Verify the checkout is clean and up-to-date
    * `git fetch  --tags`
    * `git status`

        You should see "Your branch is up-to-date with 'origin/master'". If you are behind `origin/master`, and can fast-forward, do so: `git pull`. Additionally, there should be no modified file or staged files. Untracked files are allowed so long as you are sure they are not needed to be recorded in the project repository.
4. Branch from `master` into `hotfix-X.Y.Z` where `X.Y.Z` is the to-be-released version number. Typically, this will just be an increment of `Z`
    * `git checkout -b hotfix-X.Y.Z` 
5. Make whatever changes are needed to fix the problem that this hotfix is meant to solve. Commit these changes to the hotfix branch.
6. Update version number and release date in code and verify version history
    * In NVCC.WebUI/Views/Help/About.cshtml, the version number and release date are hard-coded near the top
    * In NVCC.WebUI/Views/Help/News.cshtml, review the descriptions of the changes from the previous version. This description is intended for the end-user audience and should be written in language appropriate for that audience. Every version should have at least one entry describing what changed.
    * Commit these files to the hotfix branch.
7. Merge the hotfix branch back into `develop` and push `develop` to the remote origin
    * `git checkout develop`
    * `git merge --no-ff hotfix-X.Y.Z`

        Resolve any conflicts.

    * `git push origin develop`

        Resolve any conflicts.
8. Deployment. Change back to the hotfix branch and publish to production.
    * `git checkout hotfix-X.Y.Z`
    * From Visual Studio, Build -> Publish selecting Production
9. If any changes were needed to be able to publish, commit these changes to the hotfix branch and then merge these changes back into develop (see above step for details). Hopefully, this step should not be necessary.
10. Merge the hotfix branch into `master`
    * `git checkout master`
    * `git merge --no-ff hotfix-X.Y.Z`

        There should not be any conflicts with this.
11. Tag the master branch with a tag of the format `vX.Y.Z`. Give it the commit message "Version X.Y.Z"
    * `git tag -a -m "Version X.Y.Z" vX.Y.Z`
12. Push the master branch to the remote origin, including the new tag.
    * `git push --tags origin master`
13. Change back to develop branch to guard against inadvertent commits to the master branch.
    * `git checkout develop`
14. Delete the hotfix branch since it has been completely merged into both develop and master
    * `git branch -d hotfix-X.Y.Z`
15. Notify users of updated version. Include the most recent changes that are listed in News.cshtml. (what protocol?)
