Running Fortify for V&V submission

Assuming the working checkout is in `~/Source/Repos` and that there is `~/Source/NVCC-Fortify` with directories `INPUT` and `OUTPUT`.


1. Using the `git` command line shell, go to `~/Source/NVCC-Fortify/INPUT`

1. Clone the working copy into this directory: `git clone ../../Repos/NVCC`

1. Go into the NVCC directory and make sure you are on the right branch (presumably the release branch)

1. In this (`~/Source/NVCC-Fortify/INPUT/NVCC`) directory delete the following

    * Directories
        * `.git`
        * `.vs` (if present)
        * `Documentation`
        * `Documents`
        * `NVCC.Models.Tests`
        * `NVCC.Repos.UserRepository.Tests`
        * `NVCC.WebUI.Tests`
        * `Original SQL Scripts`
        * `Fortify Outputs` (if present)
        * `SQL`
        * `Test Results` (if present)
    * Files
        * `.gitattributes`
        * `.gitignore`
        * `NVCC.sln.vspell`
        * `OriginalSQLScripts.ssmssln`
        * `OriginalSQLScripts.ssms_suo` (if present)
        * `ETL\CC_REFDOC Post CDW Job.sql`
        * `ETL\CC_REFDOC UpdateProduction Log Job.sql`

1. Open the solution file (`NVCC.sln`) in Visual Studio

1. Dismiss the warning about missing files (if any)

1. In the Solution Explorer, drop the `Documentation`, `NVCC.Models.Tests`, `NVCC.Repos.UserRepository.Tests`, and `NVCC.WebUI.Tests` projects (Select and "Remove" from the context menu)

1. Save all

1. Encrypt the relevant portions of the config files. Cross reference: https://msdn.microsoft.com/en-us/library/zhhddkxy.aspx  
    1. Open a (Windows) command line shell (All Programs -> Visual Studio 2015 -> Visual Studio Tools -> Developer Command Prompt for VS2015)
    2. Change directory to source location `cd "c:\Users\vhapordiggsb\Source\NVCC-Foritfy\INPUT\NVCC"`
    3. Run `aspnet_regiis -pef "connectionStrings" NVCC.WebUI`
    4. Run `aspnet_regiis -pef "system.web/machineKey" NVCC.WebUI`
    5. Open `web.config` and `web.release.config` in Visual Studio
    6. Copy the `<identity>` section from `web.release.config` to `web.config` (overwriting the `<identity>` section there), taking out the `xdt:Transform="Replace"` part
    7. Save `web.config`
    8. Back at the command line, run `aspnet_regiis -pef "system.web/identity" NVCC.WebUI`
    9. Go back to Visual Studio, have it reload the modified `web.config`
    10. Copy the whole `<identity>` section from `web.config` back to `web.release.config`, replacing what was there
    11. Add `xdt:Transform="Replace"` after `configProtectionProvider...` 
    12. Save `web.release.config`
    13. Go back to `web.config`
    14. Undo (Ctrl-Z) until you get back to `<identity impersonate="false">`
    15. Save `web.config`

1. Copy the most recent `NVCC.fpr` (if it is not already there) to `~/Source/NVCC-Fortify/INPUT/NVCC`

1. Load the audit project (`Foritfy` -> `Open Audit Project`, selecting `NVCC.fpr`)

1. Verify that the latest rules are loaded (`Foritfy` -> `Options...` -> `Security Content Management` -> `Update`

1. Run the Foritfy scan (`Fortify` -> `Analyze Solution`)

1. Make sure all the Critical and High findings are audited (Security Auditor View)

1. Save the audit (`Fortify` -> `Save Audit Project`)

1. Clean the solution (`Build` -> `Clean Solution`)

1. Open the audit project in Foritfy Audit Workbench (double clicking on the NVCC.frp file from the Explorer window should do that)

1. Save the code that was scanned (`Tools` -> `Extract Source Code...`). Save it in `~/Source/NVCC-Fortify/OUTPUT`

1. In `Project Summary` tab, `Build Information` tab, scan through the files looking for files that have a blank under LOC (lines of code). Open `Documentation/EmptyFortifyFiles.md` **IN THE ORIGINAL WORKING DIRECTORIES (`~/Source/Repos/NVCC/`)**. Make sure there is an entry for each file with a blank LOC that looks like a "real" source file. (That is, not necessarily files like `*.config`). Mostly, the files listed will be interface declaration files.

1. Even though nothing has really changed, save the audit and close Audit Workbench

1. Back at the `git` command shell, go to the `INPUT` directory and execute `ls -1R --ignore=bin --ignore=obj --ignore=packages > ../INPUT.ls.txt`

1. Go to the corresponding directory in `OUTPUT`: `cd ../OUTPUT/Source/NVCC-Fortify/INPUT`

1. Execute `ls -1R --ignore=bin --ignore=obj --ignore=packages > ../../../../OUTPUT.ls.txt`

1. Go up to the top of `NVCC-Fortify`: `cd ../../../../`

1. Compare the two file listings. Make the shell window full screen and run `diff -y INPUT.ls.txt OUTPUT.ls.txt | less`. Look for any source (not configuration, *.cshtml, or library) files that appear on the left that don't appear on the right (there is only a `<`). Note them in `EmptyFortifyFiles.md`

1. From the file exporer, go to `~/Source/NVCC-Fortify/INPUT`. Right click the `NVCC` directory and `Send to` -> `Compressed (zipped) folder`

1. Begin the code review request: https://wiki.mobilehealth.DNS   /pages/viewpage.action?pageId=26774489

1. Fill out form. Application ID 
`3E90DC9E-A303-4ee5-8382-D5742B8AB44D`. 
    1. For lines of code: ``wc -l `find Database/ ETL/ GenerateMachineKey/ NVCC.Models/ NVCC.Repos.*/ NVCC.WebUI/ UserRepository/ -print\` `` (in NVCC directory of INPUT; edit listed directories as necessary)
    2. For number of source code and configuration files: ``find Database/ ETL/ GenerateMachineKey/ NVCC.Models/ NVCC.Repos.*/ NVCC.WebUI/ UserRepository/ -name '*.cs' -print -or -name '*.config' -print | wc -l `` (in NVCC directory of INPUT; edit listed directories as necessary)
    3. For number of classes: ``find Database/ ETL/ GenerateMachineKey/ NVCC.Models/ NVCC.Repos.*/ NVCC.WebUI/ UserRepository/ -name '*.cs' -print | wc -l `` (in NVCC directory of INPUT; edit listed directories as necessary)

1. Upload files. Upload directory 
`\\SERVER\OISSWA\REDACTED`. Include:
    * Source archive (zip file created earlier)
    * .frp file
    * `EmptyFortifyFiles.md`
    * `FortifyParseBug.md`
    * `DatbaseJustification.md`

1. Submit form (link on web page that form came from) to scan request.

