﻿# Parse Errors Which Are Bugs

The scan has the following parse errors

    [10002] Unable to parse T-SQL at C:\Users\vhapordiggsb\Source\NVCC-Fortify\INPUT\NVCC\Database\App\Tables\NVCC_UsersV2.sql:7:1.
    [10002] Unable to parse T-SQL at C:\Users\vhapordiggsb\Source\NVCC-Fortify\INPUT\NVCC\Database\App\Stored Procedures\NVCC_Rebuild_SensitiveDxCodesTable.sql:46:9.
    [10002] Unable to parse T-SQL at C:\Users\vhapordiggsb\Source\NVCC-Fortify\INPUT\NVCC\Database\App\Stored Procedures\NVCC_Rebuild_SensitiveDxCodesTable.sql:70:14.
    [10002] Unable to parse T-SQL at C:\Users\vhapordiggsb\Source\NVCC-Fortify\INPUT\NVCC\Database\App\Tables\NVCC_UserFacilities.sql:10:1.
    [10002] Unable to parse T-SQL at C:\Users\vhapordiggsb\Source\NVCC-Fortify\INPUT\NVCC\Database\App\Tables\NVCC_SensitiveDxBaseCodes.sql:8:1.
    [10002] Unable to parse T-SQL at C:\Users\vhapordiggsb\Source\NVCC-Fortify\INPUT\NVCC\Database\Security\Permissions.sql:0.
    [10002] Unable to parse T-SQL at C:\Users\vhapordiggsb\Source\NVCC-Fortify\INPUT\NVCC\Database\Security\App.sql:8:7.

## `WITH` Clause in Table Creation

The parser does not recognize the `WITH` clause in a `CREATE TABLE` statement. This is a valid construct for the `CREATE TABLE` statement. See [Microsoft's documentation of the CREATE TABLE statement](https://docs.microsoft.com/en-us/sql/t-sql/statements/create-table-transact-sql#n-creating-a-table-that-uses-row-compression), especially [Example N](https://docs.microsoft.com/en-us/sql/t-sql/statements/create-table-transact-sql#n-creating-a-table-that-uses-row-compression) (reproduced below) which has a similar `DATA_COMPRESSION` option.

```sql
CREATE TABLE dbo.T1   
(c1 int, c2 nvarchar(200) )  
WITH (DATA_COMPRESSION = ROW);  
```

### From `Database\App\Tables\NVCC_UsersV2.sql`

```sql
CREATE TABLE [App].[NVCC_UsersV2]
(
	[UserId] INT IDENTITY (1, 1) NOT NULL PRIMARY KEY, 
    [UserName] VARCHAR(50) NOT NULL,
    [CanAnnounce] BIT NOT NULL DEFAULT 0,
    [CanReport] BIT NOT NULL DEFAULT 0
) WITH (DATA_COMPRESSION = PAGE);
```

### From `Database\App\Stored Procedures\NVCC_Rebuild_SensitiveDxCodesTable.sql`

```sql
CREATE TABLE [App].[NVCC_SensitiveDxCodes](
   	[CodingSystem]  [varchar](12) NOT NULL,
   	[Sta3n]         [smallint] NULL,
   	[ICDSID]        [int] NULL,
   	[Code]          [varchar](12) NOT NULL,
   	[DiagnosisText] [varchar](255) NOT NULL,
   	[AbuseDx]       [int] NULL,
   	[SickleDx]      [int] NULL,
   	[HIVDx]         [int] NULL
) ON [DefFG] WITH (DATA_COMPRESSION = PAGE)
```

### From `Database\App\Tables\NVCC_UserFacilities.sql`

```sql
CREATE TABLE [App].[NVCC_UserFacilities]
(
	[UserFacilityId] INT IDENTITY (1, 1) NOT NULL PRIMARY KEY NONCLUSTERED, 
    [UserID] INT NOT NULL, 
    [Sta3n] SMALLINT NOT NULL, 
    [Sta6a] VARCHAR(50) NULL,
    [LastAuthDateTime] DATETIME2(0) NULL, 
    [ViaB] BIT NULL, 
    [admin] BIT NOT NULL DEFAULT 0
) WITH (DATA_COMPRESSION = PAGE);
```


### From `Database\App\Tables\NVCC_SensitiveDxBaseCodes.sql`

```sql
CREATE TABLE [App].[NVCC_SensitiveDxBaseCodes] (
    [CodingSystem]  VARCHAR (12)  NOT NULL,
    [Code]          VARCHAR (12)  NOT NULL,
    [DiagnosisText] VARCHAR (250) NOT NULL,
    [AbuseDx]       INT           NULL,
    [SickleDx]      INT           NULL,
    [HIVDx]         INT           NULL
)
WITH (DATA_COMPRESSION = PAGE);
```

## Miscellaneous Parse Errors

### From `Database\App\Stored Procedures\NVCC_Rebuild_SensitiveDxCodesTable.sql`

The stated parse error is:

    Parse error at line 75, column 1.  Encountered: END

However, this is just the close to the `BEGIN` at the start of the stored procedure declaration. Code parses without error is SSMS and runs without error on database.


### From `Database\Security\Permissions.sql`

The stated parse error is:

    Parse error at line 1, column 1.  Encountered: DENY

and the entirety of that file is

```sql
DENY ALTER
    ON SCHEMA::[dbo] TO [uCC_REFDOC];
```

This is valid T-SQL
* [Microsoft documentation of Deny](https://docs.microsoft.com/en-us/sql/t-sql/statements/deny-transact-sql)
* [Microsoft documentation of Deny Schema Permissions which specifically talks about `DENY ALTER`](https://docs.microsoft.com/en-us/sql/t-sql/statements/deny-schema-permissions-transact-sql)

### From `Database\Security\App.sql`

The stated parse error is:

    Parse error at line 9, column 5.  Encountered: ON

and the relevant code is

```sql
GRANT UPDATE
    ON SCHEMA::[App] TO [uCC_REFDOC_App];
```

This is valid T-SQL
* [Microsoft documentation of Grant](https://docs.microsoft.com/en-us/sql/t-sql/statements/grant-transact-sql)
* [Microsoft documentation of Grant Object Permissions which specifically talks about `GRANT UPDATE`](https://docs.microsoft.com/en-us/sql/t-sql/statements/grant-object-permissions-transact-sql)

