﻿/*
Deployment script for Database

This code was generated by a tool.
Changes to this file may cause incorrect behavior and will be lost if
the code is regenerated.
*/

GO
SET ANSI_NULLS, ANSI_PADDING, ANSI_WARNINGS, ARITHABORT, CONCAT_NULL_YIELDS_NULL, QUOTED_IDENTIFIER ON;

SET NUMERIC_ROUNDABORT OFF;


GO
:setvar DatabaseName "Database"
:setvar DefaultFilePrefix "Database"
:setvar DefaultDataPath "C:\Users\USER\AppData\Local\Microsoft\VisualStudio\SSDT\NVCC"
:setvar DefaultLogPath "C:\Users\USER\AppData\Local\Microsoft\VisualStudio\SSDT\NVCC"

GO
:on error exit
GO
/*
Detect SQLCMD mode and disable script execution if SQLCMD mode is not supported.
To re-enable the script after enabling SQLCMD mode, execute the following:
SET NOEXEC OFF; 
*/
:setvar __IsSqlCmdEnabled "True"
GO
IF N'$(__IsSqlCmdEnabled)' NOT LIKE N'True'
    BEGIN
        PRINT N'SQLCMD mode must be enabled to successfully execute this script.';
        SET NOEXEC ON;
    END


GO
USE [$(DatabaseName)];


GO
PRINT N'Creating [App].[NVCC_AccessLog]...';


GO
CREATE TABLE [App].[NVCC_AccessLog] (
    [AccessLogID]        INT           IDENTITY (1, 1) NOT NULL,
    [HostName]           VARCHAR (80)  NULL,
    [UserID]             VARCHAR (50)  NULL,
    [AccessDateTime]     DATETIME      NULL,
    [Action]             VARCHAR (255) NULL,
    [PatientSID]         INT           NULL,
    [ElapsedTime]        FLOAT (53)    NULL,
    [DatabaseServerName] VARCHAR (50)  NULL,
    CONSTRAINT [PK_App_NVCCAccessLog] PRIMARY KEY NONCLUSTERED ([AccessLogID] ASC) WITH (DATA_COMPRESSION = PAGE)
);


GO
PRINT N'Creating [App].[NVCC_AccessLog].[NVCC_AccessLog_HostName_UserID_AccessDateTime]...';


GO
CREATE CLUSTERED INDEX [NVCC_AccessLog_HostName_UserID_AccessDateTime]
    ON [App].[NVCC_AccessLog]([UserID] ASC, [HostName] ASC, [AccessDateTime] ASC) WITH (DATA_COMPRESSION = PAGE);


GO
PRINT N'Creating [App].[NVCC_Announcement]...';


GO
CREATE TABLE [App].[NVCC_Announcement] (
    [AnnouncementID]     INT             IDENTITY (1, 1) NOT NULL,
    [AnnouncementTypeID] INT             NOT NULL,
    [Creator]            VARCHAR (50)    NOT NULL,
    [CreationDT]         DATETIME2 (7)   NOT NULL,
    [ExpirationDT]       DATETIME2 (7)   NULL,
    [Text]               NVARCHAR (4000) NULL,
    CONSTRAINT [PK_App_NVCC_Announcement] PRIMARY KEY CLUSTERED ([AnnouncementID] ASC) WITH (DATA_COMPRESSION = PAGE)
);


GO
PRINT N'Creating [App].[NVCC_Announcement].[AnnouncementTypeID_Announcement]...';


GO
CREATE NONCLUSTERED INDEX [AnnouncementTypeID_Announcement]
    ON [App].[NVCC_Announcement]([AnnouncementTypeID] ASC) WITH (DATA_COMPRESSION = PAGE);


GO
PRINT N'Creating [App].[NVCC_Announcement].[ExiprationDT_Announcement]...';


GO
CREATE NONCLUSTERED INDEX [ExiprationDT_Announcement]
    ON [App].[NVCC_Announcement]([ExpirationDT] ASC) WITH (DATA_COMPRESSION = PAGE);


GO
PRINT N'Creating [App].[NVCC_DimAnnouncement]...';


GO
CREATE TABLE [App].[NVCC_DimAnnouncement] (
    [AnnouncementTypeID] INT           NOT NULL,
    [AnnouncementType]   NVARCHAR (20) NULL,
    CONSTRAINT [PK_App_NVCC_DimAnnouncement] PRIMARY KEY CLUSTERED ([AnnouncementTypeID] ASC) WITH (DATA_COMPRESSION = PAGE)
);


GO
PRINT N'Creating [App].[NVCC_HIPAATerms]...';


GO
CREATE TABLE [App].[NVCC_HIPAATerms] (
    [term] VARCHAR (35) NOT NULL,
    CONSTRAINT [PK_App_NVCC_HIPAATerms] PRIMARY KEY CLUSTERED ([term] ASC) WITH (DATA_COMPRESSION = PAGE)
);


GO
PRINT N'Creating [App].[NVCC_ProductionLog]...';


GO
CREATE TABLE [App].[NVCC_ProductionLog] (
    [AccessLogID]    INT          NOT NULL,
    [UserID]         VARCHAR (50) NOT NULL,
    [AccessDateTime] DATETIME     NOT NULL,
    [PatientSID]     INT          NOT NULL,
    [PatientICN]     VARCHAR (50) NULL,
    [Sta3n]          SMALLINT     NOT NULL
);


GO
PRINT N'Creating [App].[NVCC_ProductionLog].[NVCC_ProductionLog_AccessDateTime_UserID]...';


GO
CREATE CLUSTERED INDEX [NVCC_ProductionLog_AccessDateTime_UserID]
    ON [App].[NVCC_ProductionLog]([AccessDateTime] ASC, [UserID] ASC) WITH (DATA_COMPRESSION = PAGE);


GO
PRINT N'Creating [App].[NVCC_ProductionLog].[NVCC_ProductionLog_Sta3n]...';


GO
CREATE NONCLUSTERED INDEX [NVCC_ProductionLog_Sta3n]
    ON [App].[NVCC_ProductionLog]([Sta3n] ASC)
    INCLUDE([PatientICN]) WITH (DATA_COMPRESSION = PAGE);


GO
PRINT N'Creating [App].[NVCC_SensitiveDxBaseCodes]...';


GO
CREATE TABLE [App].[NVCC_SensitiveDxBaseCodes] (
    [CodingSystem]  VARCHAR (12)  NOT NULL,
    [Code]          VARCHAR (12)  NOT NULL,
    [DiagnosisText] VARCHAR (250) NOT NULL,
    [AbuseDx]       INT           NULL,
    [SickleDx]      INT           NULL,
    [HIVDx]         INT           NULL
)
WITH (DATA_COMPRESSION = PAGE);


GO
PRINT N'Creating [App].[NVCC_SensitiveDxCodes]...';


GO
CREATE TABLE [App].[NVCC_SensitiveDxCodes] (
    [CodingSystem]  VARCHAR (12)  NOT NULL,
    [Sta3n]         SMALLINT      NULL,
    [ICDSID]        INT           NULL,
    [Code]          VARCHAR (12)  NOT NULL,
    [DiagnosisText] VARCHAR (255) NOT NULL,
    [AbuseDx]       INT           NULL,
    [SickleDx]      INT           NULL,
    [HIVDx]         INT           NULL
);


GO
PRINT N'Creating [App].[NVCC_SensitiveDxCodes].[NVCC_SensitiveDxCodes_ICDSID]...';


GO
CREATE UNIQUE CLUSTERED INDEX [NVCC_SensitiveDxCodes_ICDSID]
    ON [App].[NVCC_SensitiveDxCodes]([ICDSID] ASC) WITH (FILLFACTOR = 95, DATA_COMPRESSION = PAGE);


GO
PRINT N'Creating [App].[NVCC_SensitiveDxCodes].[NVCC_SensitiveDxCodes_Sta3n_ICDCode]...';


GO
CREATE UNIQUE NONCLUSTERED INDEX [NVCC_SensitiveDxCodes_Sta3n_ICDCode]
    ON [App].[NVCC_SensitiveDxCodes]([Sta3n] ASC, [Code] ASC)
    INCLUDE([DiagnosisText], [AbuseDx], [SickleDx], [HIVDx]) WITH (FILLFACTOR = 95, DATA_COMPRESSION = PAGE);


GO
PRINT N'Creating [App].[NVCC_Stations]...';


GO
CREATE TABLE [App].[NVCC_Stations] (
    [Sta3n]               SMALLINT      NOT NULL,
    [MedCtr]              VARCHAR (60)  NOT NULL,
    [FullAddress]         VARCHAR (130) NULL,
    [StreetAddress1]      VARCHAR (130) NULL,
    [StreetAddress2]      VARCHAR (130) NULL,
    [City]                VARCHAR (50)  NULL,
    [State]               VARCHAR (30)  NULL,
    [Zip]                 VARCHAR (50)  NULL,
    [FacilityPhoneNumber] VARCHAR (50)  NULL,
    [FacilityFaxNumber]   VARCHAR (50)  NULL,
    [TPAOK]               VARCHAR (3)   NOT NULL,
    [TPAName]             VARCHAR (30)  NULL,
    [TPAPhone]            VARCHAR (20)  NULL,
    [TPAFax]              VARCHAR (20)  NULL,
    CONSTRAINT [PK_NVCC_Stations_Sta3n] PRIMARY KEY CLUSTERED ([Sta3n] ASC) WITH (DATA_COMPRESSION = PAGE)
);


GO
PRINT N'Creating [App].[NVCC_UserFacilities]...';


GO
CREATE TABLE [App].[NVCC_UserFacilities] (
    [UserFacilityId]   INT           IDENTITY (1, 1) NOT NULL,
    [UserID]           INT           NOT NULL,
    [Sta3n]            SMALLINT      NOT NULL,
    [Sta6a]            VARCHAR (50)  NULL,
    [LastAuthDateTime] DATETIME2 (0) NULL,
    [ViaB]             BIT           NULL,
    [admin]            BIT           NOT NULL,
    PRIMARY KEY NONCLUSTERED ([UserFacilityId] ASC)
)
WITH (DATA_COMPRESSION = PAGE);


GO
PRINT N'Creating [App].[NVCC_UserFacilities].[NVCC_UserFacilities_UserIDSta3n]...';


GO
CREATE UNIQUE CLUSTERED INDEX [NVCC_UserFacilities_UserIDSta3n]
    ON [App].[NVCC_UserFacilities]([UserID] ASC, [Sta3n] ASC) WITH (DATA_COMPRESSION = PAGE);


GO
PRINT N'Creating [App].[NVCC_UserFacilities].[NVCC_UserFacilities_UserFacilityId]...';


GO
CREATE UNIQUE NONCLUSTERED INDEX [NVCC_UserFacilities_UserFacilityId]
    ON [App].[NVCC_UserFacilities]([UserFacilityId] ASC) WITH (DATA_COMPRESSION = PAGE);


GO
PRINT N'Creating [App].[NVCC_Users]...';


GO
CREATE TABLE [App].[NVCC_Users] (
    [ID]                        INT           IDENTITY (1, 1) NOT NULL,
    [DomainPlusNetworkUserName] VARCHAR (50)  NOT NULL,
    [SaveDate]                  DATETIME      NULL,
    [Sta3n]                     INT           NOT NULL,
    [UserIEN]                   VARCHAR (50)  NULL,
    [IsCosignerRequired]        VARCHAR (5)   NULL,
    [Admin]                     BIT           NULL,
    [AccessCode]                VARCHAR (100) NULL,
    [VerifyCode]                VARCHAR (100) NULL,
    [ViaBApproved]              BIT           NULL,
    [Sta6a]                     VARCHAR (10)  NULL,
    [UserSessionId]             VARCHAR (100) NULL,
    [UserSessionSavedDateTime]  DATETIME      NULL,
    CONSTRAINT [PK_dbo.Users1] PRIMARY KEY CLUSTERED ([ID] ASC) WITH (DATA_COMPRESSION = PAGE)
);


GO
PRINT N'Creating [App].[NVCC_Users].[NVCC_Users_DomainPlusNetworkUserName]...';


GO
CREATE UNIQUE NONCLUSTERED INDEX [NVCC_Users_DomainPlusNetworkUserName]
    ON [App].[NVCC_Users]([DomainPlusNetworkUserName] ASC) WITH (DATA_COMPRESSION = PAGE);


GO
PRINT N'Creating [App].[NVCC_UsersV2]...';


GO
CREATE TABLE [App].[NVCC_UsersV2] (
    [UserId]      INT          IDENTITY (1, 1) NOT NULL,
    [UserName]    VARCHAR (50) NOT NULL,
    [CanAnnounce] BIT          NOT NULL,
    [CanReport]   BIT          NOT NULL,
    PRIMARY KEY CLUSTERED ([UserId] ASC)
)
WITH (DATA_COMPRESSION = PAGE);


GO
PRINT N'Creating [App].[NVCC_UsersV2].[NVCC_UsersV2_UserName]...';


GO
CREATE UNIQUE NONCLUSTERED INDEX [NVCC_UsersV2_UserName]
    ON [App].[NVCC_UsersV2]([UserName] ASC) WITH (DATA_COMPRESSION = PAGE);


GO
PRINT N'Creating [Dflt].[ExtractBatchLog]...';


GO
CREATE TABLE [Dflt].[ExtractBatchLog] (
    [DWViewSchema]        VARCHAR (50) NULL,
    [DWViewName]          VARCHAR (50) NULL,
    [LastExtractBatchID]  BIGINT       NULL,
    [LastExtractDateTime] DATETIME     NULL
);


GO
PRINT N'Creating [ETL].[ProdLabChem]...';


GO
CREATE TABLE [ETL].[ProdLabChem] (
    [Sta3n]                   SMALLINT      NOT NULL,
    [LabChemTestSID]          INT           NULL,
    [LOINCSID]                INT           NULL,
    [LabChemSpecimenDateTime] DATETIME2 (0) NULL,
    [LabChemCompleteDateTime] DATETIME2 (0) NULL,
    [ETLBatchID]              INT           NULL,
    [OpCode]                  CHAR (1)      NOT NULL,
    [VistaCreateDate]         DATETIME      NULL,
    [VistaEditDate]           DATETIME      NULL
);


GO
PRINT N'Creating [PanelMgmt].[PMMasterCohortLabTestGroups]...';


GO
CREATE TABLE [PanelMgmt].[PMMasterCohortLabTestGroups] (
    [RowID]                INT           IDENTITY (1, 1) NOT NULL,
    [TestGroup]            VARCHAR (30)  NULL,
    [ResultForTestNumeric] INT           NULL,
    [LabProcedure]         VARCHAR (100) NULL,
    [WorkloadCode]         VARCHAR (50)  NULL,
    [TestSearchCriteria]   VARCHAR (200) NULL,
    CONSTRAINT [PK_PMMasterCohortLabTestGroups] PRIMARY KEY CLUSTERED ([RowID] ASC) WITH (DATA_COMPRESSION = PAGE)
);


GO
PRINT N'Creating [PanelMgmt].[PMMasterCohortLabTestGroupsLOINCCodes]...';


GO
CREATE TABLE [PanelMgmt].[PMMasterCohortLabTestGroupsLOINCCodes] (
    [RowID]                INT           IDENTITY (1, 1) NOT NULL,
    [TestGroup]            VARCHAR (30)  NOT NULL,
    [ResultForTestNumeric] INT           NULL,
    [LongName]             VARCHAR (100) NULL,
    [LOINC]                VARCHAR (50)  NOT NULL,
    [System]               VARCHAR (30)  NULL,
    [YearSearchCriteria]   INT           NULL,
    [LastUpdate]           DATE          NULL,
    CONSTRAINT [PK_PMMasterCohortLabTestGroupsLOINCCodes] PRIMARY KEY CLUSTERED ([RowID] ASC)
);


GO
PRINT N'Creating [PanelMgmt].[PMMasterCohortSite]...';


GO
CREATE TABLE [PanelMgmt].[PMMasterCohortSite] (
    [Sta3n]     SMALLINT     NOT NULL,
    [Facility]  VARCHAR (50) NOT NULL,
    [VISN]      SMALLINT     NOT NULL,
    [Active]    CHAR (1)     NULL,
    [NextSta3n] INT          NULL,
    [Region]    SMALLINT     NOT NULL,
    [SiteName]  VARCHAR (50) NOT NULL
);


GO
PRINT N'Creating [PanelMgmt].[PMMasterLabIndex]...';


GO
CREATE TABLE [PanelMgmt].[PMMasterLabIndex] (
    [LabChemTestSID]       INT           NOT NULL,
    [Sta3n]                SMALLINT      NOT NULL,
    [LabChemTestName]      VARCHAR (50)  NULL,
    [ResultForTestNumeric] INT           NOT NULL,
    [DateExtracted]        DATETIME      NOT NULL,
    [TestGroup]            VARCHAR (100) NULL,
    [LOINC]                VARCHAR (50)  NULL,
    [WorkLoadCode]         VARCHAR (50)  NULL
);


GO
PRINT N'Creating [PanelMgmt].[PMMasterLabIndex].[CL_PMMasterLabIndex_LabChemTestSID_TestGroup]...';


GO
CREATE CLUSTERED INDEX [CL_PMMasterLabIndex_LabChemTestSID_TestGroup]
    ON [PanelMgmt].[PMMasterLabIndex]([LabChemTestSID] ASC, [TestGroup] ASC) WITH (FILLFACTOR = 95, DATA_COMPRESSION = PAGE);


GO
PRINT N'Creating [PanelMgmt].[PMMasterLabIndex].[PMMasterLabIndex_TestGroup_LabChemTestName_Sta3n]...';


GO
CREATE NONCLUSTERED INDEX [PMMasterLabIndex_TestGroup_LabChemTestName_Sta3n]
    ON [PanelMgmt].[PMMasterLabIndex]([TestGroup] ASC, [LabChemTestName] ASC, [Sta3n] ASC) WITH (FILLFACTOR = 95, DATA_COMPRESSION = PAGE);


GO
PRINT N'Creating [PanelMgmt].[PMMasterLabTestGroupsCohort]...';


GO
CREATE TABLE [PanelMgmt].[PMMasterLabTestGroupsCohort] (
    [RowID]     INT          IDENTITY (1, 1) NOT NULL,
    [CohortIEN] INT          NOT NULL,
    [Cohort]    VARCHAR (30) NULL,
    [TestGroup] VARCHAR (30) NULL,
    CONSTRAINT [PK_PMMasterLabTestGroupsCohort] PRIMARY KEY CLUSTERED ([RowID] ASC)
);


GO
PRINT N'Creating [App].[AllCDWPatients].[AllCDWPatients_Sta3n_PatientSSN]...';


GO
CREATE CLUSTERED INDEX [AllCDWPatients_Sta3n_PatientSSN]
    ON [App].[AllCDWPatients]([Sta3n] ASC, [PatientSSN] ASC) WITH (DATA_COMPRESSION = PAGE);


GO
PRINT N'Creating [App].[AllCDWPatients].[AllCDWPatients_PatientICN]...';


GO
CREATE NONCLUSTERED INDEX [AllCDWPatients_PatientICN]
    ON [App].[AllCDWPatients]([PatientICN] ASC)
    INCLUDE([PatientSID], [PatientSSN], [Sta3n]) WITH (DATA_COMPRESSION = PAGE);


GO
PRINT N'Creating [App].[AllCDWPatients].[AllCDWPatients_PatientSID]...';


GO
CREATE NONCLUSTERED INDEX [AllCDWPatients_PatientSID]
    ON [App].[AllCDWPatients]([PatientSID] ASC)
    INCLUDE([PatientICN]) WITH (DATA_COMPRESSION = PAGE);


GO
PRINT N'Creating [App].[PCMMCurrentPatientProviderRelationship].[PCMMCurrentPatientProviderRelationship_PatientSID]...';


GO
CREATE CLUSTERED INDEX [PCMMCurrentPatientProviderRelationship_PatientSID]
    ON [App].[PCMMCurrentPatientProviderRelationship]([PatientSID] ASC) WITH (DATA_COMPRESSION = PAGE);


GO
PRINT N'Creating [App].[PCMMCurrentPatientProviderRelationship].[PCMMCurrentPatientProviderRelationship_PrimaryProviderSID]...';


GO
CREATE NONCLUSTERED INDEX [PCMMCurrentPatientProviderRelationship_PrimaryProviderSID]
    ON [App].[PCMMCurrentPatientProviderRelationship]([PrimaryProviderSID] ASC)
    INCLUDE([AssociateProviderSID], [PatientSID]) WITH (DATA_COMPRESSION = PAGE);


GO
PRINT N'Creating [App].[DF_Announcement_CreationDT]...';


GO
ALTER TABLE [App].[NVCC_Announcement]
    ADD CONSTRAINT [DF_Announcement_CreationDT] DEFAULT (sysutcdatetime()) FOR [CreationDT];


GO
PRINT N'Creating unnamed constraint on [App].[NVCC_UserFacilities]...';


GO
ALTER TABLE [App].[NVCC_UserFacilities]
    ADD DEFAULT 0 FOR [admin];


GO
PRINT N'Creating unnamed constraint on [App].[NVCC_UsersV2]...';


GO
ALTER TABLE [App].[NVCC_UsersV2]
    ADD DEFAULT 0 FOR [CanAnnounce];


GO
PRINT N'Creating unnamed constraint on [App].[NVCC_UsersV2]...';


GO
ALTER TABLE [App].[NVCC_UsersV2]
    ADD DEFAULT 0 FOR [CanReport];


GO
PRINT N'Creating [Dflt].[DF__ExtractBa__LastE__151B244E]...';


GO
ALTER TABLE [Dflt].[ExtractBatchLog]
    ADD CONSTRAINT [DF__ExtractBa__LastE__151B244E] DEFAULT (getdate()) FOR [LastExtractDateTime];


GO
PRINT N'Creating [App].[udf_StationName]...';


GO

CREATE FUNCTION [App].[udf_StationName] (@Sta3n VARCHAR(MAX))
RETURNS VARCHAR(50)
AS
--=================================================================================
--Requestor				: Non Va Coordinated Care Project
--Author                : Jerry Kohler - Northwest Innovation Center (NWIC)
--Object/SP Name		: udf_StationName
--SERVER				: 
--Data Base				: CC_REFDOC
--Schema				: app
--Report				: N/A
--Folder				: N/A
--Report Loc            : N/A
--Job                   : None
--Job Loc               : None
--Note                  : 
--Date Created          : 02-18-2016
--Last Changed          : 
--Last Changed By		: 
--Reason For Change		: 
--
--Purpose               : Returns a "nicer" station name than what is stored in
--                        xDWWork.dim.institution
--=================================================================================
BEGIN

   RETURN
   (
      SELECT
      CASE
         WHEN charindex('(',substring(Sta3nName,7,50)) <=0 THEN substring(Sta3nName,7,50)
         ELSE substring(Sta3nName, 7, (charindex('(', substring(Sta3nName,7,50))-1))
      END

      FROM CDWWork.Dim.Sta3n

      WHERE Sta3n = @Sta3n
        AND Active = 'Y'
   )

END
GO
PRINT N'Creating [App].[NVCC_udf_ActiveUserCount]...';


GO

CREATE FUNCTION [App].[NVCC_udf_ActiveUserCount] ()
RETURNS @ActiveUserCount TABLE
(
	Station varchar(56) NOT NULL,
	ActiveUsers int NOT NULL
)

-- NOTICE:
-- Do not edit the function live on the server. Code to generate
-- the function is stored in the project repository. Any changes made
-- that are not recorded in the repository will be overwritten.

AS
--==================================================================================
--Requestor             : Non Va Coordinated Care Project
--Author                : Brian Diggs
--Object/SP Name        : NVCC_udf_ActiveUserCount
--Server                : 
--Data Base             : CC_REFDOC
--Schema                : App
--Report                : N/A
--Folder                : N/A
--Report Loc            : N/A
--Job                   : None
--Job Loc               : None
--Note                  : 
--Date Created          : 08-02-2016
--
--
--Last Changed          : 2017-07-24
--Last Changed By		: Brian Diggs
--Reason For Change		: Convert from using vNVCC_ProductionAccessLog and
--                        Patient.Patient to using NVCC_ProductionLog.
--                        Also embed sta3n in station name.
--
--Purpose               : To count the number of "active" users.
--==================================================================================
--Uses: App.udf_StationName
--Uses: App.NVCC_ProductionLog

BEGIN
	INSERT @ActiveUserCount
	SELECT
		'[' + convert(varchar(3), sta3n) + '] ' + App.udf_StationName(Sta3n) AS Station,
		COUNT(*) AS ActiveUsers
	FROM (
		SELECT UserID, Sta3n
		FROM
			App.NVCC_ProductionLog
		WHERE AccessDateTime > dateadd(day, -30, convert(date, getutcdate()))
		GROUP BY UserID, Sta3n
		HAVING COUNT(*) >= 10
	) AS U
	GROUP BY U.Sta3n
--	ORDER BY ActiveUsers DESC
	RETURN
END;
GO
PRINT N'Creating [App].[udf_AllPatientsSIDs]...';


GO

CREATE FUNCTION [App].[udf_AllPatientsSIDs] (@pid INT)
RETURNS @AllPtSIDS TABLE
   (
       PtICN VARCHAR(50),
       PtSID INT PRIMARY KEY NOT NULL,
       Sta3n SMALLINT,
       PatientIEN VARCHAR(50)
       --PtIEN VARCHAR(50)
   )
AS
--=================================================================================
--Requestor				: Non Va Coordinated Care Project
--Author                : Jerry Kohler - Northwest Innovation Center (NWIC)
--Object/SP Name		: udf_AllPatientsSIDs
--SERVER				: 
--Data Base				: CC_REFDOC
--Schema				: app
--Report				: N/A
--Folder				: N/A
--Report Loc            : N/A
--Job                   : None
--Job Loc               : None
--Note                  : 
--Date Created          : 01-14-2016
--Last Changed          : 
--Last Changed By		: 
--Reason For Change		: 
--
--Purpose               : Returns a table containing ALL patient SIDS plus other
--                        database key data for a single patient.  This facilitates
--                        retrieving all data for a patient, regardless of what
--                        station the patient received care at.  This facilitates
--                        showing a continuum of care.
--
--Last Changed          : 03-23-2017
--Last Changed By		: Jerry Kohler - NWIC
--Reason For Change		: Change function to look at App.AllCDWPatients instead of
--                      : RDWWork.SPatient.SPatient because AllCDWPatients is much
--                      : smaller and significantly improves performance.
--=================================================================================
BEGIN
   INSERT @AllPtSIDS
      Select x.PatientICN
            ,x.PatientSID
            ,x.Sta3n
            ,x.PatientIEN
        From App.AllCDWPatients AS x
       Where x.PatientICN = (Select y.PatientICN
                               From App.AllCDWPatients y
                              Where y.PatientSID = @pid);
   RETURN

END
GO
PRINT N'Creating [App].[udf_SplitString]...';


GO
CREATE FUNCTION [App].[udf_SplitString]

(@List NVARCHAR (MAX), @SplitOn VARCHAR (MAX))
RETURNS 
    @RtnValue TABLE (
        [Id]    INT            IDENTITY (1, 1) NOT NULL,
        [Value] VARCHAR (MAX) NULL)
AS
BEGIN
      While (Charindex(@SplitOn,@List)>0)
      BEGIN
            INSERT INTO @RtnValue (Value)
            SELECT ltrim(rtrim(Substring(@List,1,Charindex(@SplitOn,@List)-1))) 
            
            SET @List = Substring(@List,Charindex(@SplitOn,@List)+len(@SplitOn),len(@List))
      END 

      INSERT INTO @RtnValue (Value)
      SELECT ltrim(rtrim(@List))

    Return
END
GO
PRINT N'Creating [App].[NVCC_vGetNVAMeds]...';


GO





CREATE VIEW [App].[NVCC_vGetNVAMeds]

AS
--=================================================================================
--Requestor				: Non Va Coordinated Care Project
--Author                : Jerry Kohler (Original script by Dr. Charles Demosthenes)
--Object/SP Name		: NVCC_vGetNVAMeds
--SERVER				: 
--Data Base				: CC_REFDOC
--Schema				: app
--Report				: N/A
--Folder				: N/A
--Report Loc            : N/A
--Job                   : None
--Job Loc               : None
--Note                  : 
--Date Created          : 02-05-2016
--Last Changed          : 
--Last Changed By		: 
--Reason For Change		: 
--
--Purpose               : Retrieve a patient's medications not issued by VA for
--                        inclusion into NVCC documentation
--=================================================================================

SELECT n.NonVAMedSID, 
		d.LocalDrugNameWithDose
      ,n.MedicationRoute
      ,n.Schedule
	  , n.PatientSID
FROM CDWWork.NonVAMed.NonVAMed n
INNER JOIN CDWWork.Dim.LocalDrug d ON n.LocalDrugSID = d.LocalDrugSID
where NonVAMedSID not in (0, -1);
GO
PRINT N'Creating [App].[vNVCC_Division]...';


GO
CREATE VIEW App.vNVCC_Division

-- NOTICE:
-- Do not edit the view live on the server. Code to generate
-- the view is stored in the project repository. Any changes made
-- that are not recorded in the repository will be overwritten.

AS
--=================================================================================
--Requestor				: Non Va Coordinated Care Project
--Author                : Brian Diggs
--Object/SP Name		: vNVCC_Division
--SERVER				: 
--Data Base				: CC_REFDOC
--Schema				: App
--Report				: N/A
--Folder				: N/A
--Report Loc            : N/A
--Job                   : None
--Job Loc               : None
--Note                  : 
--Date Created          : 05-25-2017
--Last Changed          : 
--Last Changed By		: 
--Reason For Change		: 
--
--Purpose               : Create a restricted view of CDWWork.dim.Division for
--                        each Sta6a appears only once.
--=================================================================================
--
-- Goal: to get a list of valid sta6a's and their associated names, sta3n.
-- One entry per Sta6a
-- Only Sta6a's that are "real" and affiliated with a reasonable sta3n.
--
-- Primary source of data is CDWWork.Dim.Division
-- Secondary source is CDWWork.Dim.Institution
--
-- Don't want Sta6a's that are NULL, '*Missing*', '*Unknown at this time*', or 
-- any where the first three characters of the sta6a is not the corresponding sta3n.
-- This last criteria will cover all the previous ones as well.
--
-- This still leaves multiple entries for some sta6a.
-- Which entries are chosen is based on a scoring algorithm that was created by listing 
-- all the sta6a's that were multiples and, by hand, selecting the "best" one based on
-- the information in the record and the corresponding (LEFT JOINed) Institution record.
-- The score criteria that could be used to recreate the selection was:
-- If the name (CDWWork.Dim.Division.DivisionName) starts with 'ZZ', -100 points
-- If the CDWWork.Dim.Institution.StaPa is NULL, -50 points
-- If the CDWWork.Dim.Institution.InactiveFlag is anything but NULL, -20 points
--
-- The reason that these criteria are expressed as a score is so that for any sta6a,
-- there will always be some entry which is the "best", even if it is the only one. That
-- is, even if there is only one entry, it would be selected even if it met one of these
-- "bad" criteria.

SELECT
	OrderedSta6a.DivisionSID,
	OrderedSta6a.Sta3n,
	OrderedSta6a.DivisionName,
	OrderedSta6a.Sta6a
FROM (
	SELECT 
		ScoredSta6a.DivisionSID,
		ScoredSta6a.Sta3n,
		ScoredSta6a.DivisionName, 
		ScoredSta6a.Sta6a,
		-- including tie breakers for score to guarantee same order every time
		ROW_NUMBER() OVER (PARTITION BY Sta6a ORDER BY Score DESC, DivisionName, DivisionSID) as N 
	FROM (
		SELECT
			Division.DivisionSID,
			Division.Sta3n,
			Division.DivisionName, 
			Division.Sta6a,
			(
				CASE
					WHEN SUBSTRING(Division.DivisionName, 1, 2) = 'ZZ' THEN -100
					ELSE 0
				END +
				CASE
					WHEN Institution.StaPa IS NULL THEN -50
					ELSE 0
				END +
				CASE
					WHEN Institution.InactiveFlag IS NOT NULL THEN -20
					ELSE 0
				END
			) AS Score
		FROM 
			CDWWork.Dim.Division
			LEFT JOIN CDWWork.Dim.Institution 
				ON Division.InstitutionSID = Institution.InstitutionSID
		WHERE
			-- The first three digits of Sta6a match Sta3n 
			Division.Sta3n = CASE
				WHEN ISNUMERIC(SUBSTRING(Sta6a, 1, 3)) = 1 THEN
					CONVERT(SMALLINT, SUBSTRING(Sta6a, 1, 3))
				ELSE NULL
			END
		) AS ScoredSta6a 
	) AS OrderedSta6a
WHERE
	N=1
--ORDER BY Sta6a
GO
PRINT N'Creating [PanelMgmt].[vICD10]...';


GO




CREATE VIEW [PanelMgmt].[vICD10] AS
--=============================================================================================================
--Region                : R01
--Visn					: V20
--Requestor				: NWIC
--Author                : Jerry Kohler
--Object/SP Name		: vICD10
--Server				: 
--Data Base				: CC_REFDOC
--Schema				: PanelMgmt
--Report				: Any Panel Management registry or report.
--Folder				:
--Report Loc            : 
--Job Loc               : None
--Note                  : THIS VIEW RETURNS THE CURRENT DESCRIPTION AND DIAGNOSTIC TEXT, NOT HISTORIC ONES
--                      : BASED ON A DATE.  This view is not supported by CDW, BISL or any OI&T group.
--                      : The ICD-10 codes do not become effective until 10/01/2015.
--                      :
--                      : These views only exist at district 5.  Any code using them cannot be shared beyond
--                        district 5.
--                      :
--Date Created          : 09-10-2015
--                      :
--Last Changed          : 09-11-2015
--Last Changed By		: Jerry Kohler
--Reason For Change		: Added ICD10 Diagnosis
--
--Purpose               : To minimize the impact of future CDW changes to ICD-9/10
--=============================================================================================================
Select a.Sta3n,
       a.ICDIEN,
       a.ICD10SID,
       a.ICD10Code, 
       b.ICD10Description,
       c.ICD10Diagnosis AS ICD10DiagnosisText,
       CAST(10 AS SMALLINT) AS ICDVersion
from CDWWork.Dim.ICD10 a
join CDWWork.Dim.ICD10DescriptionVersion b on b.ICD10SID = a.ICD10SID
and b.CurrentVersionFlag = 'Y'
join CDWWork.Dim.ICD10DiagnosisVersion c on c.ICD10SID = a.ICD10SID
and c.CurrentVersionFlag = 'Y'
;
GO
PRINT N'Creating [PanelMgmt].[vICD9]...';


GO





CREATE View [PanelMgmt].[vICD9] AS
--=============================================================================================================
--Region                : R01
--Visn					: V20
--Requestor				: NWIC
--Author                : Jerry Kohler
--Object/SP Name		: vICD9
--Server				: 
--Data Base				: CC_REFDOC
--Schema				: PanelMgmt
--Report				: Any Panel Management registry or report.
--Folder				:
--Report Loc            : 
--Job Loc               : None
--Note                  : THIS VIEW RETURNS THE CURRENT DESCRIPTION AND DIAGNOSTIC TEXT, NOT HISTORIC ONES
--                      : BASED ON A DATE.  This view is not supported by CDW, BISL or any OI&T group.
--                      :
--                      : These views only exist at District 5.  Any code using them cannot be shared beyond
--                        district 5.
--                      :
--Date Created          : 09-10-2015
--
--Last Changed          : 09-11-2015
--Last Changed By		: Jerry Kohler
--Reason For Change		: Added ICD9 Diagnosis
--
--Purpose               : To minimize the impact of future CDW changes to ICD-9/10
--=============================================================================================================
Select a.Sta3n,
       a.ICDIEN,
       a.ICD9SID,
       a.ICD9Code, 
       b.ICD9Description,
       c.ICD9Diagnosis AS ICD9DiagnosisText,
       CAST(9 AS SMALLINT) AS ICDVersion
from CDWWork.Dim.ICD9 a
join CDWWork.Dim.ICD9DescriptionVersion b on b.ICD9SID = a.ICD9SID
 and b.CurrentVersionFlag = 'Y'
join CDWWork.Dim.ICD9DiagnosisVersion c on c.ICD9SID = a.ICD9SID
 and c.CurrentVersionFlag = 'Y'
;
GO
PRINT N'Creating [PanelMgmt].[vICD]...';


GO




CREATE View [PanelMgmt].[vICD] AS
--=============================================================================================================
--Region                : R01
--Visn					: V20
--Requestor				: NWIC
--Author                : Jerry Kohler
--Object/SP Name		: vICD
--Server				: 
--Data Base				: CC_REFDOC
--Schema				: PanelMgmt
--Report				: Any Panel Management registry or report.
--Folder				:
--Report Loc            : 
--Job Loc               : None
--Note                  : THIS VIEW RETURNS THE CURRENT DESCRIPTION AND DIAGNOSTIC TEXT, NOT HISTORIC ONES
--                      : BASED ON A DATE.  This view is not supported by CDW, BISL or any OI&T group.
--                      :
--                      : These views only exist at district 5.  Any code using them cannot be shared beyond
--                        district 5.
--                      :
--Date Created          : 09-21-2015
--
--Last Changed          : 
--Last Changed By		: 
--Reason For Change		: 
--
--Purpose               : To minimize the impact of future CDW changes of ICD-9/10 on our code.
--=============================================================================================================
Select Sta3n,
       ICDIEN            AS ICDIEN,
       ICD9SID           AS ICDSID,
       ICD9Code          AS ICDCode, 
       ICD9Description   AS ICDDescription,
       ICD9DiagnosisText AS ICDDiagnosisText,
       ICDVersion
From PanelMgmt.vICD9

UNION ALL

Select Sta3n,
       ICDIEN             AS ICDIEN,
       ICD10SID           AS ICDSID,
       ICD10Code          AS ICDCode, 
       ICD10Description   AS ICDDescription,
       ICD10DiagnosisText AS ICDDiagnosisText,
       ICDVersion
From PanelMgmt.vICD10

;
GO
PRINT N'Creating [App].[NVCC_Rebuild_SensitiveDxCodesTable]...';


GO

CREATE PROCEDURE [App].[NVCC_Rebuild_SensitiveDxCodesTable]

AS
--=================================================================================
--Requestor             : Non Va Coordinated Care Project
--Author                : Jerry Kohler
--Object/SP Name        : Rebuild_SensitiveDxCodesTable
--Server                : 
--Data Base             : CC_REFDOC
--Schema                : app
--Report                : N/A
--Folder                : N/A
--Report Loc            : N/A
--Job                   : None
--Job Loc               : None
--Note                  : 
--Date Created          : 01-21-2016
--
--Changed               : 
--Changed By            : 
--Reason For Change     : 
--
--
--Purpose               : Rebuild table App.NVCC_SensitiveDxCodes, an intermediary
--                        cache of sensitive diagnostic codes to improve NVCC
--                        application performance by eliminating the need for a
--                        separate step to obtain the ICD code SIDS.
--=================================================================================
BEGIN

   SET NOCOUNT ON;

   IF (SELECT OBJECT_ID('app.NVCC_SensitiveDxCodes', 'U')) IS NOT NULL
      DROP TABLE App.NVCC_SensitiveDxCodes

   CREATE TABLE [App].[NVCC_SensitiveDxCodes](
   	   [CodingSystem]  [varchar](12) NOT NULL,
   	   [Sta3n]         [smallint] NULL,
   	   [ICDSID]        [int] NULL,
   	   [Code]          [varchar](12) NOT NULL,
   	   [DiagnosisText] [varchar](255) NOT NULL,
   	   [AbuseDx]       [int] NULL,
   	   [SickleDx]      [int] NULL,
   	   [HIVDx]         [int] NULL
   ) ON [DefFG] WITH (DATA_COMPRESSION = PAGE)

   CREATE UNIQUE CLUSTERED INDEX [NVCC_SensitiveDxCodes_ICDSID]
   ON [App].[NVCC_SensitiveDxCodes] (ICDSID ASC)
   WITH (SORT_IN_TEMPDB = ON, ONLINE = OFF, FILLFACTOR = 95, DATA_COMPRESSION = PAGE)
   ON [DefFG]

   INSERT INTO App.NVCC_SensitiveDxCodes (CodingSystem, Sta3n, ICDSID, Code, DiagnosisText, AbuseDx, SickleDx, HIVDx)
   SELECT c.CodingSystem
   	     ,i.Sta3n
   	     ,i.ICDSID
   	     ,c.Code
   	     ,i.ICDDiagnosisText
   	     ,c.AbuseDx
   	     ,c.SickleDx
   	     ,c.HIVDx
   FROM [App].[NVCC_SensitiveDxBaseCodes] c
   INNER JOIN PanelMgmt.vICD AS i ON c.Code = i.ICDCode


   CREATE UNIQUE NONCLUSTERED INDEX [NVCC_SensitiveDxCodes_Sta3n_ICDCode]
   ON [App].[NVCC_SensitiveDxCodes] (Sta3n, Code)
   INCLUDE (DiagnosisText, AbuseDx, SickleDx, HIVDx)
   WITH (SORT_IN_TEMPDB = ON, ONLINE = OFF, FILLFACTOR = 95, DATA_COMPRESSION = PAGE)
   ON [DefFG]

--select distinct Sta3n from App.NVCC_SensitiveDxCodes order by Sta3n
--select code,count(*) from App.NVCC_SensitiveDxCodes group by code order by code

END
GO
PRINT N'Creating [App].[NVCC_usp_CurrentUsage]...';


GO
CREATE PROCEDURE [App].[NVCC_usp_CurrentUsage]
	-- @timeframe is the number of minutes (positive) to look backwards for usage
	@timeframe numeric
AS
--==================================================================================
--Requestor             : Non Va Coordinated Care Project
--Author                : Brian Diggs
--Object/SP Name        : NVCC_usp_CurrentUsage
--Server                : 
--Data Base             : CC_REFDOC
--Schema                : App
--Report                : N/A
--Folder                : N/A
--Report Loc            : N/A
--Job                   : None
--Job Loc               : None
--Note                  : 
--Date Created          : 06-01-2016
--
--Last Changed          : 2017-03-29
--Last Changed By		: Brian Diggs (Northwest Innovation Center)
--Reason For Change		: Temporary workaround for different servers recording timestamp
--                        in local time
--
--Purpose               : To get most recent users/usage
--==================================================================================
--Uses: App.NVCC_AccessLog
BEGIN
	WITH
		-- 2 hour shift due to differences in timezones of SQL server and application server
		LastTime AS (SELECT DATEADD(hour, -2, getdate()) AS LastTimestamp),
		-- Pull the log entries for this time frame to use as a source for the other queries
		RecentLogs AS (
			SELECT 
				HostName,
				UserID,
				AccessDateTime,
				[Action],
				ElapsedTime
			FROM App.NVCC_AccessLog
			CROSS JOIN LastTime
			WHERE ((HostName = 'SERVER.URL       ' AND AccessDateTime > dateadd(minute, -(@timeframe), LastTime.LastTimestamp))
				OR (HostName = 'vaww.refdoc.DNS   ' AND AccessDateTime > dateadd(hour, 3, dateadd(minute, -(@timeframe), LastTime.LastTimestamp))))
				AND HostName IS NOT NULL
				AND AccessDateTime IS NOT NULL
		)
		SELECT
			Users.HostName,
			Users.UserID,
			Users.LastLoggedEvent,
			Time.MeanLookupTime,
			Users.NumberLookups,
			Users.NumberPackages
		FROM (
			-- For each combination of host/user, compute some statistics
			SELECT
				HostName, 
				UserID,
				MAX(AccessDateTime) AS LastLoggedEvent,
				SUM(CASE WHEN Action = 'PatientProfile' THEN 1 ELSE 0 END) AS NumberLookups, 
				SUM(CASE WHEN Action = 'PDF' THEN 1 ELSE 0 END) AS NumberPackages
			FROM RecentLogs
			GROUP BY HostName, UserID
		) AS Users
		LEFT JOIN (
			-- MeanLookupTime is more easily computed separately because it
			-- needs just a subset of the data
			SELECT
				HostName, UserID, AVG(ElapsedTime) AS MeanLookupTime
			FROM RecentLogs
			WHERE Action IS NOT NULL AND Action = 'PatientProfile' 
			GROUP BY HostName, UserID
		) AS Time
			ON Users.Hostname = Time.HostName and Users.UserID = Time.UserID
		ORDER BY
			HostName,
			LastLoggedEvent DESC
END
GO
PRINT N'Creating [App].[NVCC_usp_GetAllergies]...';


GO

CREATE PROCEDURE [App].[NVCC_usp_GetAllergies]
       @pid bigint -- this is the patient's database sid

AS
--=================================================================================
--Requestor				: Non Va Coordinated Care Project
--Author                : Jerry Kohler (Original script by Dr. Charles Demosthenes)
--Object/SP Name		: NVCC_usp_GetAllergies
--SERVER				: 
--Data Base				: CC_REFDOC
--Schema				: nva
--Report				: N/A
--Folder				: N/A
--Report Loc            : N/A
--Job                   : None
--Job Loc               : None
--Note                  : 
--Date Created          : 01-12-2016
--
--Changed               : 03-03-2016  
--Changed By		    : Jerry Kohler - Northwest Innovation Center (NWIC)
--Reason For Change		: Eliminate multiple records with same allergen,
--                        only return the one with the latest verified date.
--
--Changed               : 02-18-2016  
--Changed By		    : Jerry Kohler - Northwest Innovation Center (NWIC)
--Reason For Change		: Request to also provide the name of the station.
--
--Changed               : 01-12-2016  
--Changed By		    : Jerry Kohler - Northwest Innovation Center (NWIC)
--Reason For Change		: Removed station parameter in order to expand the search
--                        for a patient's allergies from a single station to any
--                        station a patient is associated with.
--
--Purpose               : Retrieve a patient's allergies for inclusion into NVCC
--                        documentation
--=================================================================================
BEGIN

   -- SET NOCOUNT ON added to prevent extra result sets from
   -- interfering with SELECT statements.
   SET NOCOUNT ON;


   WITH Allergies AS
       (
        SELECT a.Sta3n
              ,App.udf_StationName (a.Sta3n) AS StationName
              ,a.AllergySID
              ,a.PatientSID
              ,a.OriginationDateTime
              ,a.VerificationDateTime
              ,a.AllergicReactant as Allergy
              ,ROW_NUMBER() OVER (PARTITION BY a.AllergicReactant ORDER BY a.VerificationDateTime DESC) AS RN
        FROM CDWWork.Allergy.Allergy a
        JOIN CDWWork.Dim.Sta3n b ON b.Sta3n = a.Sta3n
        WHERE a.PatientSID in (select PtSID from [App].[udf_AllPatientsSIDs](@pid))
          AND a.EnteredInErrorFlag IS NULL
       )

   SELECT Sta3n
         ,StationName
         ,AllergySID
         ,PatientSID
         ,OriginationDateTime
         ,VerificationDateTime
         ,Allergy
   FROM Allergies
   WHERE RN = 1
   ORDER BY Allergy
   --exec [app].[NVCC_usp_GetAllergies] @pid=1717444
END;
GO
PRINT N'Creating [App].[NVCC_usp_GetAnnouncement]...';


GO

CREATE PROCEDURE [App].[NVCC_usp_GetAnnouncement]
	-- @active is a numeric parameter. If 1, only return the active announcements;
	-- if 0, return all announcements.
	@active int
AS
--==================================================================================
--Requestor             : Non Va Coordinated Care Project
--Author                : Brian Diggs
--Object/SP Name        : NVCC_usp_GetLogs
--Server                : 
--Data Base             : CC_REFDOC
--Schema                : app
--Report                : N/A
--Folder                : N/A
--Report Loc            : N/A
--Job                   : None
--Job Loc               : None
--Note                  : 
--Date Created          : 06-06-2016
--
--
--Last Changed          : 
--Last Changed By		: 
--Reason For Change		: 
--
--Purpose               : To get selected announcements
--==================================================================================
--Uses: App.NVCC_Announcement
--Uses: App.NVCC_DimAnnouncement

BEGIN
	IF (@active = 0) 
		BEGIN
			SELECT
				A.AnnouncementID,
				DA.AnnouncementType,
				lc.LastName + ', ' + lc.FirstName AS Creator,
				A.CreationDT,
				A.ExpirationDT,
				A.Text
			FROM App.NVCC_Announcement AS A
				INNER JOIN App.NVCC_DimAnnouncement AS DA
					ON A.AnnouncementTypeID = DA.AnnouncementTypeID
				LEFT JOIN CDWWork.LCustomer.LCustomer lc
					ON A.Creator = lc.ADDomain + '\' + lc.ADLogin
		END
	ELSE IF (@active = 1)
		BEGIN
			SELECT
				A.AnnouncementID,
				DA.AnnouncementType,
				lc.LastName + ', ' + lc.FirstName AS Creator,
				A.CreationDT,
				A.ExpirationDT,
				A.Text
			FROM App.NVCC_Announcement AS A
				INNER JOIN App.NVCC_DimAnnouncement AS DA
					ON A.AnnouncementTypeID = DA.AnnouncementTypeID
				LEFT JOIN CDWWork.LCustomer.LCustomer lc
					ON A.Creator = lc.ADDomain + '\' + lc.ADLogin
			WHERE
				A.ExpirationDT >= GETUTCDATE() AND A.CreationDT <= GETUTCDATE()
		END
END
GO
PRINT N'Creating [App].[NVCC_usp_GetAppts]...';


GO

CREATE PROCEDURE [App].[NVCC_usp_GetAppts]
	-- Add the parameters for the stored procedure here
	@pid bigint -- this is the patientsid

-- NOTICE:
-- Do not edit the stored procedure live on the server. Code to generate
-- the procedures is stored in the project repository. Any changes made
-- that are not recorded in the repository will be overwritten.

AS
--=================================================================================
--Requestor				: Non Va Coordinated Care Project
--Author                : Jerry Kohler (Original script by Dr. Charles Demosthenes)
--Object/SP Name		: NVCC_usp_GetAppts
--SERVER				: 
--Data Base				: CC_REFDOC
--Schema				: nva
--Report				: N/A
--Folder				: N/A
--Report Loc            : N/A
--Job                   : None
--Job Loc               : None
--Note                  : 
--Date Created          : 01-12-2016
--
--Last Changed          : 03-15-2017  
--Last Changed By		: Brian Diggs - Northwest Innovation Center (NWIC)
--Reason For Change		: Change AppointmentMadeDateTime to AppointmendMadeDate
--                        due to schema changes.
--
--Last Changed          : 02-18-2016  
--Last Changed By		: Jerry Kohler - Northwest Innovation Center (NWIC)
--Reason For Change		: Request to also provide the name of the station.
--
--Last Changed          : 01-12-2016  
--Last Changed By		: Jerry Kohler - Northwest Innovation Center (NWIC)
--Reason For Change		: Removed station parameter in order to expand the search
--                        for a patient's appointments from a single station to any
--                        station a patient is associated with.
--
--Purpose               : Retrieve a patient's appointments for inclusion into NVCC
--                        documentation
--=================================================================================
--Uses: App.udf_StationName
--Uses: CDWWork.Appt.Appointment
--Uses: CDWWork.Dim.Location
--Uses: App.udf_AllPatientsSIDs
BEGIN
   -- SET NOCOUNT ON added to prevent extra result sets from
   -- interfering with SELECT statements.
   SET NOCOUNT ON;

   SELECT --TOP (100)
      ap.Sta3n
     ,App.udf_StationName (ap.Sta3n) AS StationName
     ,loc.LocationName
     ,convert(varchar, AppointmentDateTime, 101) + ' ' + convert(varchar, AppointmentDateTime, 8) AS AppointmentDateTime
     ,ap.AppointmentSID
     ,ap.PatientSID
     ,ap.AppointmentTypeSID
     ,desireddate =
      CASE
         When DesiredAppointmentDate is null
         Then convert(varchar(12), cast(dateadd(day, 1, AppointmentDateTime) as date), 101)
         Else convert(varchar(12), cast(AppointmentDateTime as date), 101)
      END
     ,ap.CancelNoShowCode
     ,ap.LocationSID, ap.PurposeOfVisit
     ,ap.SchedulingRequestType
     ,ap.CancelDateTime
     ,ap.AppointmentCancelledFlag

   FROM CDWWork.Appt.Appointment AS ap
   JOIN CDWWork.Dim.Location AS loc ON ap.LocationSID = loc.LocationSID
   WHERE ap.AppointmentDateTime >= getdate() and ap.AppointmentDateTime < convert(DATE, dateadd(mm, 6, getdate()))
     AND ap.PatientSID  in (select PtSID from [App].[udf_AllPatientsSIDs](@pid));

END;
GO
PRINT N'Creating [App].[NVCC_usp_GetConsults]...';


GO

CREATE PROCEDURE [App].[NVCC_usp_GetConsults]
	-- Add the parameters for the stored procedure here
	@pid bigint -- this is the patientsid

-- NOTICE:
-- Do not edit the stored procedure live on the server. Code to generate
-- the procedures is stored in the project repository. Any changes made
-- that are not recorded in the repository will be overwritten.

AS
--=================================================================================
--Requestor				: Non Va Coordinated Care Project
--Author                : Jerry Kohler (Original script by Dr. Charles Demosthenes)
--Object/SP Name		: NVCC_usp_GetConsults
--SERVER				: 
--Data Base				: CC_REFDOC
--Schema				: app
--Report				: N/A
--Folder				: N/A
--Report Loc            : N/A
--Job                   : None
--Job Loc               : None
--Note                  : 
--Date Created          : 01-12-2016
--Last Changed          : 12-01-2016
--Last Changed By		: Brian Diggs - Northwest Innovation Center (NWIC)
--Reason For Change		: Convert from using [App].[vPCMMPatientProviders] to
--						: [App].[PCMMCurrentPatientProviderRelationship]
--
--Last Changed          : 06-22-2016
--Last Changed By		: Brian Diggs - Northwest Innovation Center (NWIC)
--Reason For Change		: Bringing in primary provider and other fields to
--						  be able to recreate bottom block of consult.
--                        Change likely done by Jonathan Duckart but was
--                        never synced with the source repository.
--
--Last Changed          : 01-12-2016  
--Last Changed By		: Jerry Kohler - Northwest Innovation Center (NWIC)
--Reason For Change		: Removed station parameter in order to expand the search
--                        for a patient's consults from a single station to any
--                        station a patient is associated with.
--
--Purpose               : Retrieve a patient's consults from within the last 180
--                        days for inclusion into NVCC documentation.
--=================================================================================

BEGIN
   -- SET NOCOUNT ON added to prevent extra result sets from
   -- interfering with SELECT statements.
   SET NOCOUNT ON;

	WITH
		PTSID AS (
			SELECT PtSID 
			FROM [App].[udf_AllPatientsSIDs](@pid)
		)
   SELECT
      c.Sta3n
     ,App.udf_StationName (c.Sta3n) AS StationName
     ,c.ToRequestServiceName
     ,cast(c.RequestDateTime as date) AS RequestDate
     ,c.CPRSStatus
     ,c.CPRSOrderSID
     ,c.ConsultSID
   	 ,c.ConsultIEN
     ,c.PatientSID
     ,c.ToRequestServiceSID
     ,c.RequestType
   	 ,c.OrderStatusSID
     ,c.RecentActivityTypeSID
     ,c.RecentActivityType
   	 ,c.SendingStaffSID
     ,c.Urgency
     ,c.InpatOutpat
   	 ,ISNULL(c.ProvisionalDiagnosis, ' ') AS ProvDx
   	 ,ISNULL(c.ProvisionalDiagnosisCode, ' ') AS ProvDxCode
   	 ,c.TIUDocumentSID
     ,c.EarliestDate
     ,r.ConsultReason
	 ,l.LocationName as FromService
	 , st.StaffName as RequestingProvider
	 , pcmm.PrimaryProvider
	 , pcmm.Team
	 , sp.Eligibility + ' ' + sp.EligibilityStatus as PrimaryEligibility
   FROM CDWWork.Con.Consult c
   JOIN CDWWork.SPatient.SConsultReason r
		ON r.ConsultSID = c.ConsultSID
	JOIN CDWWork.Dim.Location l
		ON l.LocationSID=c.FromLocationSID
	JOIN CDWWork.SStaff.SStaff st
		ON st.StaffSID=c.SendingStaffSID
	LEFT JOIN (
		SELECT TOP 1 PatientSID, PrimaryProvider, Team 
		FROM 
			App.PCMMCurrentPatientProviderRelationship pp
			INNER JOIN PTSID
				ON pp.PatientSID = PTSID.PtSID
		ORDER BY RelationshipStartDate DESC) pcmm
		ON pcmm.PatientSID=c.PatientSID
	JOIN CDWWork.SPatient.SPatient sp
		ON sp.PatientSID=c.PatientSID
	INNER JOIN PTSid ptsid
		ON ptsid.PtSID = c.PatientSID
   WHERE c.ToRequestServiceName not like 'NON-FORM%' 
   	 AND c.CPRSStatus not in ('DISCONTINUED','CANCELLED','COMPLETE') 
     AND c.RequestDateTime >= CAST(dateadd(dd, -365, getdate()) AS DATE)
   ORDER BY c.RequestDateTime;
END
GO
PRINT N'Creating [App].[NVCC_usp_GetDivision]...';


GO

CREATE PROCEDURE [App].[NVCC_usp_GetDivision]
	@sta6a varchar(50)

-- NOTICE:
-- Do not edit the stored procedure live on the server. Code to generate
-- the procedures is stored in the project repository. Any changes made
-- that are not recorded in the repository will be overwritten.

AS
--=================================================================================
--Requestor				: REFDOC
--Author                : Jon Duckart 
--Object/SP Name		: NVCC_usp_GetDivision
--SERVER				: 
--Data Base				: CC_REFDOC
--Schema				: app
--Report				: N/A
--Folder				: N/A
--Report Loc            : N/A
--Job                   : None
--Job Loc               : None
--Note                  : 
--Date Created          : 08-25-2016
--Last Changed          : 05-25-2017
--Last Changed By		: Brian Diggs - Northwest Innovation Center (NWIC)
--Reason For Change		: Changed to use view with only one entry per Sta6a.
--
--Last Changed          : 03-15-2017
--Last Changed By		: Brian Diggs - Northwest Innovation Center (NWIC)
--Reason For Change		: Changed parameter type to varchar(50) to match the
--                        type of sta6a in the view.
--
--Last Changed          : 08-25-2016
--Last Changed By		: Jon Duckart - Northwest Innovation Center (NWIC)
--Reason For Change		: 
--
--Purpose               : Retrieve a user's Sta6a for VIA calls
--=================================================================================
--Uses: CDWWork.Dim.Division

BEGIN
	-- SET NOCOUNT ON added to prevent extra result sets from
	-- interfering with SELECT statements.
	SET NOCOUNT ON;
	SELECT 
		[DivisionSID]
		,[Sta3n]
		,[DivisionName]  
		,[Sta6a]
	FROM App.vNVCC_Division
	WHERE Sta6a=@sta6a
      
END;
GO
PRINT N'Creating [App].[NVCC_usp_GetDivisions]...';


GO




CREATE PROCEDURE [App].[NVCC_usp_GetDivisions]
	@sta3n smallint -- this is the sta3n

-- NOTICE:
-- Do not edit the stored procedure live on the server. Code to generate
-- the procedures is stored in the project repository. Any changes made
-- that are not recorded in the repository will be overwritten.

AS
--=================================================================================
--Requestor				: Non Va Coordinated Care Project
--Author                : Jon Duckart 
--Object/SP Name		: NVCC_usp_GetVAMeds
--SERVER				: 
--Data Base				: CC_REFDOC
--Schema				: app
--Report				: N/A
--Folder				: N/A
--Report Loc            : N/A
--Job                   : None
--Job Loc               : None
--Note                  : 
--Date Created          : 08-23-2016
--Last Changed          : 05-25-2017
--Last Changed By		: Brian Diggs - Northwest Innovation Center (NWIC)
--Reason For Change		: Changed to use view with only one entry per Sta6a.
--
--Last Changed          : 08-23-2016
--Last Changed By		: Jon Duckart - Northwest Innovation Center (NWIC)
--Reason For Change		: 
--
--Purpose               : Retrieve a user's Sta6a for VIA calls
--=================================================================================
--Uses: CDWWork.Dim.Division

BEGIN
    -- SET NOCOUNT ON added to prevent extra result sets from
    -- interfering with SELECT statements.
    SET NOCOUNT ON;
	SELECT 
		[DivisionSID]
		,[Sta3n]
		,[DivisionName]  
		,[Sta6a]
	FROM App.vNVCC_Division
	WHERE Sta3n=@sta3n
	ORDER BY Sta6a
END;
GO
PRINT N'Creating [App].[NVCC_usp_GetLabs]...';


GO



CREATE PROCEDURE [App].[NVCC_usp_GetLabs]
	-- Add the parameters for the stored procedure here
	@pid bigint   --this is the patientSID
AS
--=================================================================================
--Requestor				: Non Va Coordinated Care Project
--Author                : Jerry Kohler (Original script by Dr. Charles Demosthenes)
--Object/SP Name		: NVCC_usp_GetLabs
--Server				: 
--Data Base				: CC_REFDOC
--Schema				: app
--Report				: N/A
--Folder				: N/A
--Report Loc            : N/A
--Job                   : None
--Job Loc               : None
--Note                  : 
--Date Created          : 01-06-2016
--
--Last Changed          : 02-18-2016  
--Last Changed By		: Jerry Kohler - Northwest Innovation Center (NWIC)
--Reason For Change		: Request to also provide the name of the station.
--
--Changed               : 02-16-2016  
--Changed By		    : Jerry Kohler - Northwest Innovation Center (NWIC)
--Reason For Change		: We only want the most recent value for any of the
--                        labs.
--
--Changed               : 01-12-2016  
--Changed By		    : Jerry Kohler - Northwest Innovation Center (NWIC)
--Reason For Change		: Removed station parameter in order to expand the search
--                        for a patient's labs from a single station to any
--                        station a patient is associated with by acquiring all
--                        PatientSIDs from the passed SIDs ICN.
--
--Changed               : 01-11-2016  
--Changed By		    : Jerry Kohler - Northwest Innovation Center (NWIC)
--Reason For Change		: Integrated into the NWIC lab process whereby lab test
--                        names are determined by combinations of LOINC or workload
--                        codes, and not relying on the facilities to normalize or
--                        standardize their lab test names.
--
--Purpose               : Retrieve results for certain lab tests within the last 15
--                        months and pass that data back to the NVCC application.
--=================================================================================
BEGIN
   -- SET NOCOUNT ON added to prevent extra result sets from
   -- interfering with SELECT statements.
   SET NOCOUNT ON;

   WITH LabsLast15Months AS
   (
   SELECT lab.Sta3n
         ,lab.LabChemSID
         ,tst.LabChemTestName
         ,tst.LabChemPrintTestName
         ,lab.LabChemSpecimenDateTime
         ,lab.LabChemResultValue
         ,ISNULL(lab.Units, ' ') as units
         ,ISNULL(lab.Abnormal, ' ') as abnormal
         ,ISNULL(lab.RefHigh, ' ') as RefHigh
         ,ISNULL(lab.RefLow, ' ') as RefLow
         ,lab.LabChemResultNumericValue
         ,lab.LabChemTestSID
         ,lab.PatientSID
         ,ROW_NUMBER() over (partition by tst.LabChemTestName order by lab.LabChemSpecimenDateTime DESC) AS RowNum
   FROM  CDWWork.Chem.LabChem AS lab
   INNER JOIN CDWWork.Dim.LabChemTest AS tst ON lab.LabChemTestSID = tst.LabChemTestSID
   --INNER JOIN CDWWork.SPatient.SPatient s on s.PatientSID=lab.PatientSID
   WHERE lab.PatientSID IN (Select PtSID from App.udf_AllPatientsSIDs(@pid)) AND
      lab.LabChemTestSID IN (Select r.LabChemTestSID
                                  From [PanelMgmt].[PMMasterLabIndex] r
                                 Where r.TestGroup IN (Select Distinct s.TestGroup
                                                         From [PanelMgmt].[PMMasterCohortLabTestGroups] s
                                                         Join [PanelMgmt].[PMMasterLabTestGroupsCohort] t
                                                           On t.TestGroup = s.TestGroup
                                                        Where t.Cohort = 'NVCC')
                               ) --Patient SID 2440025 is a good test case
     AND lab.LabChemCompleteDateTime >= DATEADD(month, -15, GETDATE())
	 --AND s.DateOfDeath is NULL
   )

   SELECT Sta3n
         ,App.udf_StationName (Sta3n) AS StationName
         ,LabChemSID
         ,LabChemTestName
         ,LabChemPrintTestName
         ,LabChemSpecimenDateTime
         ,LabChemResultValue
         ,units
         ,abnormal
         ,RefHigh
         ,RefLow
         ,LabChemResultNumericValue
         ,LabChemTestSID
         ,PatientSID
		-- into App.LabsLast15Months
   FROM  LabsLast15Months
   WHERE RowNum = 1

END
GO
PRINT N'Creating [App].[NVCC_usp_GetNextOfKin]...';


GO

CREATE PROCEDURE [App].[NVCC_usp_GetNextOfKin]
	@sid int   --PatientSid

-- NOTICE:
-- Do not edit the stored procedure live on the server. Code to generate
-- the procedures is stored in the project repository. Any changes made
-- that are not recorded in the repository will be overwritten.

AS
--==================================================================================
--Requestor             : Non Va Coordinated Care Project
--Author                : Jon Duckart
--Object/SP Name        : [NVCC_usp_GetNextOfKin]
--Server                : 
--Data Base             : CC_REFDOC
--Schema                : app
--Report                : N/A
--Folder                : N/A
--Report Loc            : N/A
--Job                   : None
--Job Loc               : None
--Note                  : 
--Date Created          : 06-07-2016
--
--Purpose               : To retrieve a single patient NOK record for the NVCC app by SID.
--==================================================================================
BEGIN
	-- SET NOCOUNT ON added to prevent extra result sets from
	-- interfering with SELECT statements.
   SET NOCOUNT ON;

   SELECT  SPatientAddressSID as NextOfKindId
   , PatientSID
   , Sta3n as Station
   , AddressType
   , NameOfContact
   , StreetAddress1
   , StreetAddress2
   , City
   , State
   , Zip
   , Phone
   , PhoneWork
   FROM  CDWWork.SPatient.SPatientAddress
   WHERE PatientSID= @sid and OrdinalNumber=2;  --OrdinalNumber=2, Next Of Kin
END;
GO
PRINT N'Creating [App].[NVCC_usp_GetNVAMeds]...';


GO


CREATE PROCEDURE [App].[NVCC_usp_GetNVAMeds]
	-- Add the parameters for the stored procedure here
	@pid bigint -- this is the patientsid
AS
--=================================================================================
--Requestor				: Non Va Coordinated Care Project
--Author                : Jerry Kohler (Original script by Dr. Charles Demosthenes)
--Object/SP Name		: NVCC_usp_GetNVAMeds
--SERVER				: 
--Data Base				: CC_REFDOC
--Schema				: App
--Report				: N/A
--Folder				: N/A
--Report Loc            : N/A
--Job                   : None
--Job Loc               : None
--Note                  : 
--Date Created          : 02-05-2016
--
--Changed               : 03-03-2016  
--Changed By		    : Jerry Kohler - Northwest Innovation Center (NWIC)
--Reason For Change		: Added NonVAMedComments per TFS NVCC project task 1329.
--                        Also added NonVAMedDisclamer, and a condition that
--                        the DiscontinuedDateTime is NULL.
--
--Changed               : 02-05-2016  
--Changed By            : Jerry Kohler - Northwest Innovation Center (NWIC)
--Reason For Change		: Removed station parameter in order to expand the search
--                        for a patient's VA meds from a single station to any
--                        station a patient is associated with.
--
--Purpose               : Retrieve a patient's medications not issued by VA for
--                        inclusion into NVCC documentation
--=================================================================================
BEGIN

	-- SET NOCOUNT ON added to prevent extra result sets from
	-- interfering with SELECT statements.
	SET NOCOUNT ON;

  	SELECT DISTINCT n.Sta3n
          ,App.udf_StationName (n.Sta3n) AS StationName
          ,n.NonVAMedSID
		  ,d.LocalDrugNameWithDose
          ,n.Dosage
          ,n.MedicationRoute
	      ,n.Schedule
          ,n.NonVAMedComments
          ,n.NonVAMedDisclaimer
	FROM CDWWork.NonVAMed.NonVAMed n
    INNER JOIN CDWWork.Dim.LocalDrug d ON n.LocalDrugSID = d.LocalDrugSID
	WHERE n.PatientSID in (select PtSID from [App].[udf_AllPatientsSIDs](@pid))
      AND n.DiscontinuedDateTime is NULL;
        
END;
GO
PRINT N'Creating [App].[NVCC_usp_GetOrCreateUser]...';


GO
CREATE PROCEDURE App.NVCC_usp_GetOrCreateUser
	@UserName varchar(50)

-- NOTICE:
-- Do not edit the stored procedure live on the server. Code to generate
-- the procedures is stored in the project repository. Any changes made
-- that are not recorded in the repository will be overwritten.

AS

--==================================================================================
--Requestor             : Non Va Coordinated Care Project
--Author                : Brian Diggs
--Object/SP Name        : NVCC_usp_GetOrCreateUser
--Server                : 
--Data Base             : CC_REFDOC
--Schema                : App
--Report                : N/A
--Folder                : N/A
--Report Loc            : N/A
--Job                   : None
--Job Loc               : None
--Note                  : 
--Date Created          : 06-29-2017
--
--Last Changed          : 
--Last Changed By		: 
--Reason For Change		: 
--
--Purpose               : To retrieve a corresponding record from App.NVCC_UsersV2
--                        or to create and return one if none exists. For this to
--                        work, all columns other that UserName must have default
--                        values.
--==================================================================================

BEGIN
	-- Derived from https://stackoverflow.com/a/1488387/892313
	SET TRANSACTION ISOLATION LEVEL SERIALIZABLE
	BEGIN TRANSACTION
		DECLARE @UserID int
		SELECT @UserID = UserId FROM App.NVCC_UsersV2 WHERE UserName = @UserName
		IF @UserID IS NULL
		BEGIN
			INSERT INTO App.NVCC_UsersV2 (UserName) VALUES (@UserName)
			SELECT @UserID = SCOPE_IDENTITY()
		END
		SELECT * FROM App.NVCC_UsersV2 WHERE UserId = @UserID
	COMMIT TRANSACTION
END
GO
PRINT N'Creating [App].[NVCC_usp_GetPatient]...';


GO


CREATE PROCEDURE [App].[NVCC_usp_GetPatient]
	@station int,   --station for pt, restricts queries local VA station
	@ssn varchar(9) -- this is the patient's SSN

AS
--==================================================================================
--Requestor             : Non Va Coordinated Care Project
--Author                : Jerry Kohler (Original script by Dr. Charles Demosthenes)
--Object/SP Name        : NVCC_usp_GetPatient
--Server                : 
--Data Base             : CC_REFDOC
--Schema                : app
--Report                : N/A
--Folder                : N/A
--Report Loc            : N/A
--Job                   : None
--Job Loc               : None
--Note                  : 
--Date Created          : 01-20-2016
--
--
--Last Changed          : 02-18-2016  
--Last Changed By		: Jerry Kohler - Northwest Innovation Center (NWIC)
--Reason For Change		: Request to also provide the name of the station.
--
--Purpose               : To retrieve a single patient record for the NVCC app.
--==================================================================================
BEGIN
	-- SET NOCOUNT ON added to prevent extra result sets from
	-- interfering with SELECT statements.
   SET NOCOUNT ON;

   SELECT Cast(PatientSID as varchar) as strPatientSID
         ,Sta3n
         ,App.udf_StationName (Sta3n) AS StationName
         ,PatientName
         ,PatientLastName
         ,PatientFirstName
         ,PatientSSN
         ,StreetAddress1
         ,StreetAddress2
         ,StreetAddress3
         ,City
         ,Zip
         ,Zip4
         ,PostalCode
         ,Province
         ,Country
         ,PhoneResidence
         ,PhoneWork
         ,PhoneCellular
         ,DateOfDeath
         ,BadAddressIndicator
         ,TemporaryAddressActiveFlag
         ,Gender
         ,Age
         ,[State]
         ,Deceased
         ,Eligibility
         ,DateOfBirth
         ,IneligibleDate
         ,EligibilityStatus
         ,EligibilityVerificationSource
   FROM  CDWWork.SPatient.SPatient
   WHERE PatientSSN like @ssn and sta3n=@station;
END;
GO
PRINT N'Creating [App].[NVCC_usp_GetPatientBySid]...';


GO

CREATE PROCEDURE [App].[NVCC_usp_GetPatientBySid]
	@pid int   --PatientSID

-- NOTICE:
-- Do not edit the stored procedure live on the server. Code to generate
-- the procedures is stored in the project repository. Any changes made
-- that are not recorded in the repository will be overwritten.

AS
--==================================================================================
--Requestor             : Non Va Coordinated Care Project
--Author                : Jon Duckart (Original script by Dr. Charles Demosthenes)
--Object/SP Name        : NVCC_usp_GetPatientBySid
--Server                : 
--Data Base             : CC_REFDOC
--Schema                : app
--Report                : N/A
--Folder                : N/A
--Report Loc            : N/A
--Job                   : None
--Job Loc               : None
--Note                  : 
--Date Created          : 04-14-2016
--
--Last Changed          : 06-22-2016
--Last Changed By		: Brian Diggs - Northwest Innovation Center (NWIC)
--Reason For Change		: Formatting and idempotence and signing
--
--Purpose               : To retrieve a single patient record for the NVCC app by SID.
--==================================================================================
BEGIN
	-- SET NOCOUNT ON added to prevent extra result sets from
	-- interfering with SELECT statements.
   SET NOCOUNT ON;

   SELECT  [PatientSID]
      ,[PatientIEN]
      ,[Sta3n] as Station
      ,[PatientName]
      ,[PatientLastName]
      ,[PatientFirstName]
      ,[PatientSSN]
      ,[ScrSSN]
      ,[StreetAddress1]
      ,[StreetAddress2]
      ,[StreetAddress3]
      ,[City]
      ,[Zip]
      ,[Zip4]
      ,[PostalCode]
      ,[Province]
      ,[CountrySID]
      ,[Country]
      ,[PhoneResidence]
      ,[PhoneWork]
      ,[PhoneCellular]
      ,[MothersMaidenName]
      ,[DateOfDeath]
      ,[DateOfDeathText]
      ,[EmailAddress]
      ,[BadAddressIndicator]
      ,[ExcludeFromFacilityDirectoryFlag]
      ,[AddressChangeInstitutionSID]
      ,[AddressChangeStaffSID]
      ,[NOKPrimaryChangeDateTime]
      ,[NOKPrimaryChangeVistaErrorDate]
      ,[NOKPrimaryChangeDateTimeTransformSID]
      ,[NOKSecondaryChangeDateTime]
      ,[NOKSecondaryChangeVistaErrorDate]
      ,[NOKSecondaryChangeDateTimeTransformSID]
      ,[NOKRelationshipToPatient]
      ,[NOKDesigneeSameAsFlag]
      ,[NOKEmergencyContactSameAsFlag]
      ,[TemporaryAddressActiveFlag]
      ,[TemporaryAddressLastEditedDateTime]
      ,[TemporaryAddressLastEditedVistaErrorDate]
      ,[TemporaryAddressLastEditedDateTimeTransformSID]
      ,[TemporaryAddressChangeInstitutionSID]
      ,[TemporaryAddressStartDate]
      ,[TemporaryAddressStartVistaErrorDate]
      ,[TemporaryAddressStartDateTransformSID]
      ,[TemporaryAddressEndDate]
      ,[TemporaryAddressEndVistaErrorDate]
      ,[TemporaryAddressEndDateTransformSID]
      ,[ConfidentialAddressActiveFlag]
      ,[CDFlag]
      ,[CDDecidedByName]
      ,[CDDecisionDate]
      ,[CDDecisionVistaErrorDate]
      ,[CDDecisionDateTransformSID]
      ,[CDReviewedDate]
      ,[CDReviewedVistaErrorDate]
      ,[CDReviewedDateTransformSID]
      ,[CDDeterminingInstitutionSID]
      ,[CDDeterminationType]
      ,[CurrentPurpleHeartDecisionType]
      ,[CurrentPurpleHeartStatus]
      ,[PurpleHeartInstitutionSID]
      ,[MedicaidNumber]
      ,[RaceSID]
      ,[Gender]
      ,[Age]
      ,[StateSID]
      ,[State]
      ,[County]
      ,[Deceased]
      ,[PatientICN]
      ,[PatientICNChecksum]
      ,[PseudoSSNFlag]
      ,[PeriodOfServiceSID]
      ,[PeriodOfService]
      ,[CurrentMeansTestStatusSID]
      ,[MaritalStatusSID]
      ,[MaritalStatus]
      ,[PercentServiceConnect]
      ,[InsuranceCoverageFlag]
      ,[ReligionSID]
      ,[Religion]
      ,[AgentOrangeExposureFlag]
      ,[AgentOrangeLocationCode]
      ,[RadiationExposureCode]
      ,[IonizingRadiationExposureFlag]
      ,[SHADFlag]
      ,[VeteranFlag]
      ,[CombatFlag]
      ,[CombatEligibilityEndDate]
      ,[CombatEligibilityEndVistaErrorDate]
      ,[CombatEligibilityEndDateTransformSID]
      ,[TestPatientFlag]
      ,[CDWPossibleTestPatientFlag]
      ,[SpinalCordInjuryType]
      ,[EnteredIntoFileDate]
      ,[EnteredIntoFileVistaErrorDate]
      ,[EnteredIntoFileDateTransformSID]
      ,[EmergencyResponseIndicator]
      ,[EligibilitySID]
      ,[Eligibility]
      ,[EligibilityVACode]
      ,[DateOfBirth]
      ,[DateOfBirthText]
      ,[SensitiveFlag]
      ,[LastServiceEntryDate]
      ,[LastServiceEntryVistaErrorDate]
      ,[LastServiceEntryDateTransformSID]
      ,[LastServiceSeparationDate]
      ,[LastServiceSeparationVistaErrorDate]
      ,[LastServiceSeparationDateTransformSID]
      ,[PreferredInstitutionSID]
      ,[POWFlag]
      ,[POWLocationSID]
      ,[POWFromVistaDate]
      ,[POWToVistaDate]
      ,[CombatFromVistaDate]
      ,[CombatToVistaDate]
      ,[ClaimNumber]
      ,[RoomBedSID]
      ,[IneligibleDate]
      ,[IneligibleVistaErrorDate]
      ,[IneligibleDateTransformSID]
      ,[IneligibleReason]
      ,[EligibilityStatus]
      ,[EligibilityVerificationSource]
      ,[GISLocatorName]
      ,[GISMatchStatusCode]
      ,[GISMatchScore]
      ,[GISMatchMethodCode]
      ,[GISMatchedAddress]
      ,[GISAddressType]
      ,[GISStreetSide]
      ,[GISPatientAddressLongitude]
      ,[GISPatientAddressLatitude]
      ,[GISAddressUpdatedDate]
      ,[GISFIPSCode]
      ,[GISMarket]
      ,[GISSubmarket]
      ,[GISSector]
      ,[GISURH]
      ,[GISCongressDistrict]
   FROM  CDWWork.SPatient.SPatient
	WHERE
		PatientSid= @pid
		AND patientname <>'*Unknown at this time*'
		AND patientname is not null;
END;
GO
PRINT N'Creating [App].[NVCC_usp_GetPatientBySSN]...';


GO

CREATE PROCEDURE App.NVCC_usp_GetPatientBySSN
	@SSN varchar(50),
	@sta3n smallint
AS
--=================================================================================
--Requestor				: Non Va Coordinated Care Project
--Author                : Brian Diggs
--Object/SP Name		: usp_GetPatientBySSN
--SERVER				: 
--Data Base				: CC_REFDOC
--Schema				: PanelMgmt
--Report				: N/A
--Folder				: N/A
--Report Loc            : N/A
--Job                   : None
--Job Loc               : None
--Note                  : 
--Date Created          : 07-14-2017
--
--Changed               : 2017-07-31
--Changed By		    : Brian Diggs
--Reason For Change		: Added (NOLOCK) query hint so that searcing for a patient
--                        will not block during the daily update.
--
--Purpose               : Retrieve a patient's SID from the SSN and sta3n
--                      : using the heavily indexed App.AllCDWPatients
--=================================================================================
BEGIN
	SELECT
		PatientSID,
		PatientSSN,
		Sta3n
	FROM App.AllCDWPatients WITH (NOLOCK)
	WHERE
		PatientSSN = @SSN AND sta3n = @sta3n
END
GO
PRINT N'Creating [App].[NVCC_usp_GetProbs]...';


GO

CREATE PROCEDURE [App].[NVCC_usp_GetProbs]
	-- Add the parameters for the stored procedure here
	@pid bigint -- this is the patientsid
AS
--=================================================================================
--Requestor				: Non Va Coordinated Care Project
--Author                : Jerry Kohler - Northwest Innovation Center (NWIC)
--Object/SP Name		: NVCC_usp_GetProbs
--SERVER				: 
--Data Base				: CC_REFDOC
--Schema				: app
--Report				: N/A
--Folder				: N/A
--Report Loc            : N/A
--Job                   : None
--Job Loc               : None
--Note                  : 
--Date Created          : 01-14-2016
--
--Last Changed          : 03-16-2016  
--Last Changed By		: Jerry Kohler - Northwest Innovation Center (NWIC)
--Reason For Change		: TFS Project NVCC, item number 1368 - Eliminate 
--                        duplicate problem codes (Brian Diggs).
--
--Last Changed          : 02-18-2016  
--Last Changed By		: Jerry Kohler - Northwest Innovation Center (NWIC)
--Reason For Change		: Request to also provide the station and station
--                        name.
--
--Last Changed          : 01-19-2016  
--Last Changed By		: Jerry Kohler - Northwest Innovation Center (NWIC)
--Reason For Change		: Restructured the procedure into a CTE and single
--                        SELECT statement.  Added DISTINCT to eliminate
--                        duplicate returned rows, and tuned for performance.
--
--Changed               : 01-14-2016  
--Changed By		    : Jerry Kohler - Northwest Innovation Center (NWIC)
--Reason For Change		: Removed station parameter in order to expand the search
--                        for a patient's consults from a single station to any
--                        station a patient is associated with.
--
--Purpose               : Retrieve a patient's active problem lists for provider
--                        review while compiling NVCC documentation.
--=================================================================================
BEGIN
--declare @station int; set @station=508; declare @pid bigint; set @pid=1717444; declare @sflag int; set @sflag=1;
	-- SET NOCOUNT ON added to prevent extra result sets from
	-- interfering with SELECT statements.
   SET NOCOUNT ON;

--DECLARE @PID INT = 24257470  --zztelehealth patient with tons of data

   ;
   WITH PTProbs0 (Sta3n, StationName, ProblemListSID, PatientSID, ICD9SID, ICD10SID, RN, LastModifiedDate) AS
     (
      SELECT p.Sta3n
            ,App.udf_StationName (p.Sta3n) AS StationName
            ,p.ProblemListSID
            ,p.PatientSID
            ,p.ICD9SID
            ,p.ICD10SID
            ,RN = CASE
                When ICD9SID <> 0
                   Then ROW_NUMBER() OVER (PARTITION BY p.ICD9SID  ORDER BY p.LastModifiedDate DESC)
                When ICD10SID <> 0
                   Then ROW_NUMBER() OVER (PARTITION BY p.ICD10SID ORDER BY p.LastModifiedDate DESC)
                Else -999
                End
            ,p.LastModifiedDate
      FROM CDWWork.Outpat.ProblemList p 
      WHERE p.PatientSID IN (Select PtSID From App.udf_AllPatientsSIDs (@pid))
        AND p.ActiveFlag = 'A'
        AND ProblemListCondition <> 'H'
     ),

     PTProbs1 (Sta3n, StationName, ICDCode, ICDVersion, ProblemListSID, Problem, LastModifiedDate ,RN, SensitiveDx, AbuseDx, SickleDx, HIVDx) AS
     (
      SELECT p.Sta3n
            ,p.StationName
            ,i.ICD9Code AS ICDCode
            ,'ICD9' AS ICDVersion
            ,p.ProblemListSID
            ,left(i.ICD9DiagnosisText,50) AS Problem
            ,p.LastModifiedDate
            ,ROW_NUMBER() OVER (PARTITION BY left(i.ICD9DiagnosisText,50) ORDER BY p.LastModifiedDate DESC) AS RN
			, CASE WHEN dx.ICDSID is NOT NULL THEN 1 ELSE 0 END AS SensitiveDx
			, dx.AbuseDx
			, dx.SickleDx
			, dx.HIVDx
      FROM PTProbs0 p
      left outer join PanelMgmt.vICD9 i on p.ICD9SID = i.ICD9SID
	  LEFT OUTER JOIN [App].[NVCC_SensitiveDxCodes] dx
	  on dx.ICDSID = p.ICD9SID
      WHERE p.ICD9SID <> 0
        AND p.RN = 1

      UNION ALL
   
      SELECT p.Sta3n
            ,p.StationName
            ,k.ICD10Code AS ICDCode
            ,'ICD10'     AS ICDVersion
            ,p.ProblemListSID
            ,left(k.ICD10DiagnosisText,50) AS Problem
            ,p.LastModifiedDate
            ,ROW_NUMBER() OVER (PARTITION BY left(k.ICD10DiagnosisText,50) ORDER BY p.LastModifiedDate DESC) AS RN
			, CASE WHEN dx.ICDSID is NOT NULL THEN 1 ELSE 0 END AS SensitiveDx
			, dx.AbuseDx
			, dx.SickleDx
			, dx.HIVDx
      FROM PTProbs0 p
      left outer join PanelMgmt.vICD10 k on p.ICD10SID = k.ICD10SID
	    LEFT OUTER JOIN [App].[NVCC_SensitiveDxCodes] dx
	  on dx.ICDSID = p.ICD10SID
      WHERE p.ICD10SID <> 0
        AND p.RN = 1
    )

   SELECT Sta3n
         ,StationName
         ,ICDCode
         ,ICDVersion
         ,ProblemListSID
         ,Problem
         ,LastModifiedDate
		 ,SensitiveDx, AbuseDx, SickleDx, HIVDx
   FROM PTProbs1
   WHERE RN = 1
   ORDER BY LastModifiedDate DESC;

END;

--exec nva.getProbs @station=508, @pid=1717444;
--exec nva.getSensDxCodes;
GO
PRINT N'Creating [App].[NVCC_usp_GetSensDx]...';


GO


CREATE PROCEDURE [App].[NVCC_usp_GetSensDx]
	-- Add the parameters for the stored procedure here
	@pid bigint -- this is the patientsid
--==================================================================================
--Requestor             : Non Va Coordinated Care Project
--Author                : Jerry Kohler (Original script by Dr. Charles Demosthenes)
--Object/SP Name        : NVCC_usp_GetSensDx
--Server                : 
--Data Base             : CC_REFDOC
--Schema                : App
--Report                : N/A
--Folder                : N/A
--Report Loc            : N/A
--Job                   : None
--Job Loc               : None
--Note                  : 
--Date Created          : 01-20-2016
--
--Changed               : 01-20-2016
--Changed By            : Jerry Kohler
--Reason For Change     : Removed station parameter; we want the data for the
--                        patient no matter where that patient was treated.
--
--Changed               : 01-29-2016
--Changed By            : Jerry Kohler
--Reason For Change     : Consolidated some queries the script was doing into fewer,
--                        smaller ones since we now have a table containing all of
--                        the sensitive diagnoses & ICD SIDS (9 & 10)
--
--Purpose               : Retrieve any sensitive diagnoses that may exist for a
--                        patient.  If there are any, they require special handling
--                        to determine which outsource partners can know about them.
--==================================================================================
AS

BEGIN
    -- declare @pid bigint; set @pid=1717444;
	-- SET NOCOUNT ON added to prevent extra result sets from
	-- interfering with SELECT statements.
	SET NOCOUNT ON;

    DECLARE @flag int;
    SET @flag=0;

    -- Check all of a patient's recorded diagnoses against our table of sensitive
    -- diagnoses, and record the various diagnosis flags.
    SELECT --TOP 3000 
		CASE
			WHEN p.ICD10SID > 0 THEN p.ICD10SID
			ELSE p.ICD9SID
		END as Code
		,CASE
			WHEN p.ICD10SID > 0 THEN 'ICD10'
			ELSE 'ICD9'
		END as  CodingSystem
		,CASE
			WHEN p.ICD10SID > 0 THEN 
				(select top 1 s.AbuseDx from App.NVCC_SensitiveDxCodes s where p.ICD10SID = s.ICDSID)
			ELSE
				(select top 1 t.AbuseDx from App.NVCC_SensitiveDxCodes t where p.ICD9SID = t.ICDSID)
		END as AbuseDx
		,CASE
			WHEN p.ICD10SID > 0 THEN 
				(select top 1 s.SickleDx from App.NVCC_SensitiveDxCodes s where p.ICD10SID = s.ICDSID)
			ELSE
				(select top 1 t.SickleDx from App.NVCC_SensitiveDxCodes t where p.ICD9SID = t.ICDSID)
		END as SickleDx
		,CASE
			WHEN p.ICD10SID > 0 THEN 
				(select top 1 s.HIVDx from App.NVCC_SensitiveDxCodes s where p.ICD10SID = s.ICDSID)
			ELSE
				(select top 1 t.HIVDx from App.NVCC_SensitiveDxCodes t where p.ICD9SID = t.ICDSID)
		END as HIVDx
     INTO #ptsdx
     FROM CDWWork.Outpat.VDiagnosis p
     JOIN App.NVCC_SensitiveDxCodes x on (p.ICD9SID = x.ICDSID OR p.ICD10SID = x.ICDSID)
     WHERE PatientSID in (select PtSID from [App].[udf_AllPatientsSIDs](@pid));


          
     IF ((select sum(AbuseDx) from #ptsdx) > 0)  set @flag=@flag+1;
     IF ((select sum(HIVDx) from #ptsdx) > 0)    set @flag=@flag+4;
     IF ((select sum(SickleDx) from #ptsdx) > 0) set @flag=@flag+16;


     -- Check all of a patient's recorded ICD codes recorded on his problem list
     -- against our table of sensitive diagnoses, and record the various
     -- diagnosis flags.
     SELECT prb.ICD9SID
           ,prb.ICD10SID
           ,prb.PatientSID
           ,x.AbuseDx
           ,x.SickleDx
           ,x.HIVDx 
     INTO #ptsprb
     FROM CDWWork.Outpat.ProblemList AS prb 
     INNER JOIN App.NVCC_SensitiveDxCodes x on (prb.ICD9SID = x.ICDSID OR prb.ICD10SID = x.ICDSID)
     WHERE PatientSID in (select PtSID from [App].[udf_AllPatientsSIDs](@pid))
       AND prb.ActiveFlag = 'A'
       AND prb.ProblemListCondition <> 'H';

     if ((select sum(AbuseDx) from #ptsprb) > 0) set @flag=@flag+2;
     if ((select sum(HIVDx) from #ptsprb)   > 0) set @flag=@flag+8;
     if ((select sum(SickleDx) from #ptsprb)> 0) set @flag=@flag+32;


     drop table #ptsdx;
     drop table #ptsprb;

     select @flag as sensdxflag;
     --exec [App].[NVCC_usp_GetSensDx] @pid=1717444;
     end;
GO
PRINT N'Creating [App].[NVCC_usp_GetVAMeds]...';


GO

CREATE PROCEDURE [App].[NVCC_usp_GetVAMeds]
	@pid bigint -- this is the patientsid

-- NOTICE:
-- Do not edit the stored procedure live on the server. Code to generate
-- the procedures is stored in the project repository. Any changes made
-- that are not recorded in the repository will be overwritten.

AS
--=================================================================================
--Requestor				: Non Va Coordinated Care Project
--Author                : Jerry Kohler (Original script by Dr. Charles Demosthenes)
--Object/SP Name		: NVCC_usp_GetVAMeds
--SERVER				: 
--Data Base				: CC_REFDOC
--Schema				: App
--Report				: N/A
--Folder				: N/A
--Report Loc            : N/A
--Job                   : None
--Job Loc               : None
--Note                  : 
--Date Created          : 02-04-2016
--
--Last Changed          : 08-23-2016
--Last Changed By		: Jerry Kohler - Northwest Innovation Center (NWIC)
--Reason For Change		: Users registering complaints that REFDOC is not showing
--                        the same number of current prescriptions as CPRS.
--                        After a meeting with Judy & Dr. D they had us change
--                        the criteria to all prescriptions released over the last
--                        year regardless of status or currently taking (see
--                        comments embedded below)
--
--Last Changed          : 08-22-2016
--Last Changed By		: Brian Diggs - Northwest Innovation Center (NWIC)
--Reason For Change		: Reconciled with version on server.
--                        Updated documentation and creation/signing standards
--               		: Removed station parameter in order to expand the search
--                        for a patient's VA meds from a single station to any
--                        station a patient is associated with.
--
--Purpose               : Retrieve a patient's medications issued by VA for
--                        inclusion into NVCC documentation
--=================================================================================


BEGIN
    -- SET NOCOUNT ON added to prevent extra result sets from
    -- interfering with SELECT statements.
    SET NOCOUNT ON;

    WITH MyDrugs AS
       (
--      declare @PID int = 1000862763
--      select PTSid from [App].[udf_AllPatientsSIDs](@pid)
        SELECT ROF.Sta3n
              ,ROF.[RxOutpatSID]
              ,ROF.[FillNumber]
              ,RO.[RxStatus]
              ,ROF.[LocalDrugNameWithDose]
              ,ROF.[IssueDate]
              ,ROF.[FillDateTime]
			  ,RO.NextPossibleFillDate
              ,ROF.[Qty]
              ,ROF.[DaysSupply]
			  ,RO.[MaxRefills]
              ,Row_Number() OVER(partition by ROF.[LocalDrugNameWithDose] Order by ROF.[FillDateTime] desc) AS Rn
        FROM [CDWWork].[RxOut].[RxOutpatFill] ROF
			INNER JOIN CDWWork.RxOut.RxOutpat AS RO
				ON ROF.RxOutpatSID = RO.RxOutpatSID
        WHERE ROF.PatientSID in (select PtSID from [App].[udf_AllPatientsSIDs](@pid)) 
          AND (ReleaseDateTime > dateadd(year, -1, SYSDATETIME()))
		  AND ReleaseDateTime IS NOT NULL
       )
    
        SELECT dl.Sta3n
              ,dl.rxoutpatsid
              ,dl.localdrugnamewithdose
              ,cast(dl.filldatetime as date) as filldate
              ,dl.qty as qty
              ,dl.FillNumber
              ,sig.Sig
              ,dl.issuedate
			  ,ISNULL(cast(dl.NextPossibleFillDate as varchar), 'N/A') as nextpossiblefilldate
			  ,ISNULL(dl.maxrefills, '0') as maxrefills
			  ,dl.DaysSupply AS dayssupply
			  ,dl.RxStatus
        FROM MyDrugs dl
        INNER JOIN CDWWork.RxOut.RxOutpatSig sig on dl.Rxoutpatsid=sig.RxOutpatSID
        WHERE dl.Rn = 1
    ORDER BY dl.RxStatus, dl.FillDateTime desc;
    
END;
GO
PRINT N'Creating [App].[NVCC_usp_GetXdwFacility]...';


GO

CREATE PROCEDURE [App].[NVCC_usp_GetXdwFacility]
	-- @LCustomerID is from CDWWork.LCustomer.LCustomer
	@LCustomerID int
AS
--==================================================================================
--Requestor             : Non Va Coordinated Care Project
--Author                : Brian Diggs
--Object/SP Name        : NVCC_usp_GetXdwFacility
--Server                : 
--Data Base             : CC_REFDOC
--Schema                : app
--Report                : N/A
--Folder                : N/A
--Report Loc            : N/A
--Job                   : None
--Job Loc               : None
--Note                  : 
--Date Created          : 2017-02-14
--
--
--Last Changed          : 
--Last Changed By		: 
--Reason For Change		: 
--
--Purpose               : To get the sites for which a user has PHI/PII access
--==================================================================================
--Uses: App.udf_StationName
--Uses: CDWWork.LCustomer.AllPermissions
--Uses: CDWWork.Dim.Sta3n

BEGIN
	SELECT
		s.Sta3n AS FacilityID
		,App.udf_StationName(s.Sta3n) AS FacilityName
		,s.VISNFY17 AS VISN
		,s.DistrictNumberFY17 AS District
	FROM CDWWork.LCustomer.AllPermissions AS ap
		JOIN CDWWork.Dim.Sta3n AS s
			ON ap.Sta3n = s.Sta3n
	WHERE 
		ap.LCustomerID = @LCustomerID 
		AND ap.PHIPII = 1 
		AND ap.Sta3n > 0
		AND s.Active = 'Y'
END
GO
PRINT N'Creating [App].[NVCC_usp_GetXdwFacilityBySta3n]...';


GO

CREATE PROCEDURE [App].[NVCC_usp_GetXdwFacilityBySta3n]
	@Sta3n smallint

-- NOTICE:
-- Do not edit the stored procedure live on the server. Code to generate
-- the procedures is stored in the project repository. Any changes made
-- that are not recorded in the repository will be overwritten.

AS
--==================================================================================
--Requestor             : Non Va Coordinated Care Project
--Author                : Brian Diggs
--Object/SP Name        : NVCC_usp_GetXdwFacilityBySta3n
--Server                : 
--Data Base             : CC_REFDOC
--Schema                : app
--Report                : N/A
--Folder                : N/A
--Report Loc            : N/A
--Job                   : None
--Job Loc               : None
--Note                  : 
--Date Created          : 2017-02-14
--
--
--Last Changed          : 
--Last Changed By		: 
--Reason For Change		: 
--
--Purpose               : To get details about a given site from the Sta3n
--==================================================================================
--Uses: App.udf_StationName
--Uses: CDWWork.Dim.Sta3n

BEGIN
	SELECT
		s.Sta3n AS FacilityID
		,App.udf_StationName(s.Sta3n) AS FacilityName
		,s.VISNFY17 AS VISN
		,s.DistrictNumberFY17 AS District
	FROM CDWWork.Dim.Sta3n AS s
	WHERE 
		s.Sta3n = @Sta3n
END
GO
PRINT N'Creating [App].[NVCC_usp_GetXdwUser]...';


GO

CREATE PROCEDURE [App].[NVCC_usp_GetXdwUser]
	-- @username is the network (AD) username/login of the user
	@username varchar(50)
AS
--==================================================================================
--Requestor             : Non Va Coordinated Care Project
--Author                : Brian Diggs
--Object/SP Name        : NVCC_usp_GetXdwUser
--Server                : 
--Data Base             : CC_REFDOC
--Schema                : app
--Report                : N/A
--Folder                : N/A
--Report Loc            : N/A
--Job                   : None
--Job Loc               : None
--Note                  : 
--Date Created          : 2017-02-14
--
--
--Last Changed          : 
--Last Changed By		: 
--Reason For Change		: 
--
--Purpose               : To get LCustomer and AD information about a user
--==================================================================================
--Uses: CDWWork.NDim.ActiveDirectoryAccount
--Uses: CDWWork.LCustomer.LCustomer
--Uses: CDWWork.Dim.Sta3n

BEGIN
	SELECT TOP 1
		UPPER(ada.SamAccountName) AS NetWorkName
		,ada.Surname AS LastName
		,ada.GivenName AS FirstName
		,lc.LCustomerID
		,AccountEmailAddress as Email
		,lc.UpdatedDate as DateAdded
		,lc.InferredSta3n
		,s.Sta3n AS ADLoginInferredSta3n
	FROM
		CDWWork.NDim.ActiveDirectoryAccount AS ada
		LEFT JOIN CDWWork.LCustomer.LCustomer AS lc
			ON ada.SamAccountName = lc.ADLogin
		LEFT JOIN CDWWork.Dim.Sta3n s
			ON s.SiteCode = SUBSTRING(UPPER(@username), 4, 3)
	WHERE SamAccountName = @username
	ORDER BY lc.UpdatedDate DESC
END
GO
PRINT N'Creating [App].[NVCC_usp_ProductionAccessLogUniqueSta3n]...';


GO
--DROP PROCEDURE App.NVCC_usp_ProductionAccessLogUniqueSta3n

CREATE PROCEDURE [App].[NVCC_usp_ProductionAccessLogUniqueSta3n]

-- NOTICE:
-- Do not edit the stored procedure live on the server. Code to generate
-- the procedures is stored in the project repository. Any changes made
-- that are not recorded in the repository will be overwritten.

AS
--==================================================================================
--Requestor             : Non Va Coordinated Care Project
--Author                : Brian Diggs
--Object/SP Name        : NVCC_usp_ProductionAccessLogUniqueSta3n
--Server                : 
--Data Base             : CC_REFDOC
--Schema                : App
--Report                : N/A
--Folder                : N/A
--Report Loc            : N/A
--Job                   : None
--Job Loc               : None
--Note                  : 
--Date Created          : 05-27-2016
--
--Last Changed          : 2017-07-24
--Last Changed By		: Brian Diggs
--Reason For Change		: Convert to using NVCC_ProductionLog
--
--Purpose               : Get unique stations from the access log
--==================================================================================
--Uses: App.NVCC_ProductionLog
--Uses: App.udf_StationName
BEGIN
	SELECT
		Sta3n,
		App.udf_StationName(Sta3n) AS Station
	FROM (
		SELECT DISTINCT
			Sta3n
		FROM
			App.NVCC_ProductionLog
	) S
	ORDER BY Station
END
GO
PRINT N'Creating [App].[NVCC_usp_ProductionAccessLogUniqueUsers]...';


GO
--DROP PROCEDURE App.NVCC_usp_ProductionAccessLogUniqueUsers

CREATE PROCEDURE [App].[NVCC_usp_ProductionAccessLogUniqueUsers]

-- NOTICE:
-- Do not edit the stored procedure live on the server. Code to generate
-- the procedures is stored in the project repository. Any changes made
-- that are not recorded in the repository will be overwritten.

AS
--==================================================================================
--Requestor             : Non Va Coordinated Care Project
--Author                : Brian Diggs
--Object/SP Name        : NVCC_usp_ProductionAccessLogUniqueUsers
--Server                : 
--Data Base             : CC_REFDOC
--Schema                : App
--Report                : N/A
--Folder                : N/A
--Report Loc            : N/A
--Job                   : None
--Job Loc               : None
--Note                  : 
--Date Created          : 05-27-2016
--
--Last Changed          : 2017-07-24
--Last Changed By		: Brian Diggs
--Reason For Change		: Convert from vNVCC_ProducionAccessLog, SStaff, and NVCC_Users
--                      : to NVCC_ProductionLog and LCustomer
--
--Purpose               : Get unique users from the access log
--==================================================================================
--Uses: App.NVCC_ProductionLog
--Uses: CDWWork.LCustomer.LCustomer
BEGIN
	SELECT
		U.UserID,
		lc.LastName + ', ' + lc.FirstName AS StaffName,
		U.Sta3n
	FROM (
		SELECT DISTINCT
			pl.UserID,
			pl.Sta3n
		FROM
			App.NVCC_ProductionLog pl
	) AS U
		LEFT JOIN CDWWork.LCustomer.LCustomer lc
			ON U.UserID = lc.ADDomain + '\' + lc.ADLogin
	ORDER BY StaffName
END
GO
PRINT N'Creating [App].[NVCC_usp_UniqueVeterans]...';


GO

CREATE PROCEDURE [App].[NVCC_usp_UniqueVeterans]

-- NOTICE:
-- Do not edit the stored procedure live on the server. Code to generate
-- the procedures is stored in the project repository. Any changes made
-- that are not recorded in the repository will be overwritten.

AS
--==================================================================================
--Requestor             : Non Va Coordinated Care Project
--Author                : Brian Diggs
--Object/SP Name        : App.NVCC_usp_UniqueVeterans
--Server                : 
--Data Base             : CC_REFDOC
--Schema                : app
--Report                : N/A
--Folder                : N/A
--Report Loc            : N/A
--Job                   : None
--Job Loc               : None
--Note                  : 
--Date Created          : 11-02-2016
--
--Last Changed          : 
--Last Changed By		: 
--Reason For Change		: 
--
--Purpose               : To get aggregated counts of RDPs and unique veterans at
--                        station and VISN levels of aggregation
--==================================================================================

BEGIN
	SELECT 
		pl.PatientICN, pl.Sta3n, s.VISNFY17, s.DistrictNumberFY17 AS District
	INTO #TMP
	FROM 
		App.NVCC_ProductionLog pl
		INNER JOIN CDWWork.Dim.Sta3n s
			ON pl.Sta3n = s.Sta3n

	SELECT
		ROW_NUMBER() OVER (ORDER BY District, VISNFY17, Sta3n) AS ID,
		District,
		VISNFY17,
		Sta3n,
		App.udf_StationName(Sta3n) AS Station,
		RDP,
		UniqueVeterans
	FROM (
		SELECT
			District,
			VISNFY17,
			Sta3n,
			count(*) AS RDP,
			count(distinct PatientICN) AS UniqueVeterans
		FROM #TMP
		GROUP BY Sta3n, VISNFY17, District
		UNION
		SELECT
			District,
			VISNFY17,
			NULL AS Sta3n,
			count(*) AS RDP,
			count(distinct PatientICN) AS UniqueVeterans
		FROM #TMP
		GROUP BY VISNFY17, District
		UNION
		SELECT
			District,
			NULL AS VISNFY17,
			NULL AS Sta3n, 
			count(*) AS RDP,
			count(distinct PatientICN) AS UniqueVeterans
		FROM #TMP
		GROUP BY District
		UNION
		SELECT
			NULL AS District,
			NULL AS VISNFY17,
			NULL AS Sta3n, 
			count(*) AS RDP,
			count(distinct PatientICN) AS UniqueVeterans
		FROM #TMP

	) A
	ORDER BY District, VISNFY17, Sta3n

	DROP TABLE #TMP
END
GO
PRINT N'Creating [App].[NVCC_usp_UpdateProductionLog]...';


GO

CREATE PROCEDURE App.NVCC_usp_UpdateProductionLog

-- NOTICE:
-- Do not edit the stored procedure live on the server. Code to generate
-- the procedures is stored in the project repository. Any changes made
-- that are not recorded in the repository will be overwritten.

AS
--==================================================================================
--Requestor             : Non Va Coordinated Care Project
--Author                : Brian Diggs
--Object/SP Name        : App.NVCC_usp_UpdateProductionLog
--Server                : 
--Data Base             : CC_REFDOC
--Schema                : App
--Report                : N/A
--Folder                : N/A
--Report Loc            : N/A
--Job                   : None
--Job Loc               : None
--Note                  : 
--Date Created          : 2017-07-21
--
--Last Changed          : 2017-08-01
--Last Changed By		: Brian Diggs
--Reason For Change		: Explicit check that AccessDateTime is not null
--                        and UserID and HostName (to eliminate possible
--                        NULL predicates)
--
--Purpose               : Procedure to be run periodically to update the table
--                        NVCC_ProductionLog from the table NVCC_AccessLog
--                        based on the criteria of what is considered to be a
--                        package created in the production environment
--
--                        NVCC_ProductionLog is a non-normalized set of data
--                        (since it can be defined based on the contents of
--                        NVCC_AccessLog) that is indexed/optimized for reporting
--==================================================================================

BEGIN
	DECLARE @LastID int;
	SELECT @LastID = MAX(AccessLogID) FROM App.NVCC_ProductionLog

	INSERT INTO App.NVCC_ProductionLog
	SELECT
		al.AccessLogID,
		al.UserID,
		al.AccessDateTime,
		al.PatientSID,
		p.PatientICN,
		p.Sta3n
	FROM
		App.NVCC_AccessLog al
		INNER JOIN CDWWork.Patient.Patient p
			ON al.PatientSID = p.PatientSID
	WHERE
		al.UserID NOT IN ('VHA20\USER', 'VHA20\USER', 'VHA20\USER', 'VHA20\USER', 'VHA20\USER') 
		AND al.UserID IS NOT NULL
		AND (
			al.HostName = 'SERVER.URL       ' OR
			--dev.nwic was being used to host users who could not covert to the VIA version during these dates
 			(al.HostName = 'SERVER.portland.URL       ' AND AccessDateTime BETWEEN '2016-10-19' AND '2016-11-15')
			OR al.HostName = 'vaww.refdoc.DNS   ' --the EWIS hosted national production site
		)
		AND al.HostName IS NOT NULL
		AND AccessDateTime IS NOT NULL
		AND al.Action = 'PDF'
		AND ((AccessLogID > @LastID) OR (@LastID IS NULL))
END
GO
PRINT N'Creating [App].[NVCC_usp_UsageData2]...';


GO

CREATE PROCEDURE [App].[NVCC_usp_UsageData2]
	-- @timegroup is a character parameter which can take values NULL, 'day', 'week',
	-- 'month', 'quarter', 'year', or 'ever'. NULL is equivalent to 'ever'. Any other value
	-- will result in undefind behavior.
	@timegroup varchar(max) = NULL,
	-- @statistic is a character parameter which can take values 'count' or 'cumulative'.
	-- Any other value will result in undefined behavior.
	-- For 'count', the value N represents number within that timegroup and any
	-- other grouping categories
	-- For 'cumulative', the value N represents the cumulative number, over time,
	-- up to that timepoint, separated by any other grouping categories
	@statistic varchar(max) = NULL,
	-- @sta3n is a character parameter which can either NULL, a single station number,
	-- or a comma demlimited list of station numbers. NULL implies that the data for
	-- all stations should be returned/used and that no stratification by station should
	-- be done. A single station number (as a string) will return data for only that
	-- station. A comma delimited list of station numbers will restrict the returned data
	-- to those present in the list and any aggregation or ordination will be done
	-- separately for each station.
	@sta3n varchar(max) = NULL,
	-- @userid is a character parameter which can either NULL, a single user identifier,
	-- or a comma demlimited list of user identifiers. A user identifier is a login,
	-- including the domain. NULL implies that the data for all userss stations should
	-- be returned/used and that no stratification by user should be done. A userid
	-- will return data for only that user. A comma delimited list of users will
	-- restrict the returned data to those present in the list and any aggregation
	-- or ordination will be done separately for each user.
	@userid varchar(max) = NULL
AS
--==================================================================================
--Requestor             : Non Va Coordinated Care Project
--Author                : Brian Diggs
--Object/SP Name        : App.NVCC_usp_UsageData2
--Server                : 
--Data Base             : CC_REFDOC
--Schema                : app
--Report                : N/A
--Folder                : N/A
--Report Loc            : N/A
--Job                   : None
--Job Loc               : None
--Note                  : 
--Date Created          : 08-03-2016
--
--Last Changed          : 2017-07-24
--Last Changed By		: Brian Diggs
--Reason For Change		: Use NVCC_ProductionLog instead of vNVCC_ProductionAccessLog
--
--Purpose               : To get aggregated, subsetted production counts.
--==================================================================================
--Uses: App.udf_SplitString
--Uses: App.NVCC_ProductionLog
--Uses: App.udf_StationName
--Uses: CDWWork.LCustomer.LCustomer

BEGIN
	-- First, create a temporary table, #LogData, which pulls records from
	-- App.NVCC_ProductionAccessLog.
	--
	-- The AccessDateTime and UserID are kept from the log, and the
	-- PatientSID is used to determine the Sta3n for that patient.
	--
	-- This list is further restricted to those stations and users specified
	-- by the parameters. This is accomplished by converting the parameter
	-- string to a table using App.udf_SplitString. Only the value is kept
	-- and, for the station, converted to a smallint to match the datatype
	-- elsewhere. An input of NULL will give a single row table with value
	-- NULL. These conversions are done as common table expressions.
	-- These table are INNER JOIN-ed to the data, with the clause that
	-- everything is kept if the value is NULL.
	--
	-- UserID and Sta3n are converted to NULL if their respective parameters
	-- are NULL. This indicates that there is no stratification done (or
	-- possible) on those variables. The TimeGroup column contains a date
	-- which is the start of the interval corresponding to the requested
	-- aggregation level (day, start of week, start of month, start of
	-- quarter, start of year).
	WITH
		Sta3n AS (SELECT CONVERT(smallint, Value) AS Sta3n FROM App.udf_SplitString(@sta3n, ',')),
		UserID AS (SELECT Value AS UserID FROM App.udf_SplitString(@userid, ','))
		SELECT
			CASE
				WHEN @userid IS NULL THEN NULL
				ELSE pl.UserID
			END AS UserID,
			CASE
				WHEN @sta3n IS NULL THEN NULL
				ELSE pl.Sta3n
			END AS Sta3n,
			CASE @timegroup
				WHEN 'day' THEN
					CONVERT(DATE, pl.AccessDateTime)
				WHEN 'week' THEN
					CONVERT(DATE, DATEADD(DAY, 7 * (DATEDIFF(DAY, '1990-01-07', pl.AccessDateTime) / 7), '1990-01-07'))
				WHEN 'month' THEN
					DATEFROMPARTS(DATEPART(YEAR, pl.AccessDateTime), DATEPART(MONTH, pl.AccessDateTime), 1)
				WHEN 'quarter' THEN
					DATEFROMPARTS(DATEPART(YEAR, pl.AccessDateTime), (((DATEPART(MONTH, pl.AccessDateTime) - 1) / 3) * 3) + 1, 1)
				WHEN 'year' THEN
					DATEFROMPARTS(DATEPART(YEAR, pl.AccessDateTime), 1, 1)
				WHEN 'ever' THEN
					NULL
			END AS TimeGroup
		INTO #LogData
		FROM
			App.NVCC_ProductionLog pl
			INNER JOIN Sta3n st
				ON (pl.Sta3n = st.Sta3n OR st.Sta3n IS NULL)
			INNER JOIN UserID uid
				ON (pl.UserID = uid.UserID OR uid.UserID IS NULL)

	-- A temporary table, #LogAgg, is created based on the structure of #LogAgg plus one
	-- other, NULLable numeric column N. This must be done in a separate step
	-- step (rather than implicitly with a SELECT ... INTO) because the same named
	-- temporary table can not be used as a target for multiple SELECT ... INTO statements.
	-- The WHERE clause is designed to select no rows, so no data is initially seeded
	-- in the temporary table.
	SELECT
		ld.UserID,
		ld.Sta3n,
		ld.TimeGroup,
		CONVERT(integer, NULL) AS N
	INTO #LogAgg
	FROM #LogData AS ld
	WHERE 1=0;

	-- Choose the code path based on the value of @statistic.
	IF (@statistic = 'count')
		BEGIN
			INSERT INTO #LogAgg (Sta3n, UserID, TimeGroup, N)
			SELECT
				Sta3n,
				UserID,
				TimeGroup,
				COUNT(*) AS N
			FROM #LogData
			GROUP BY Sta3n, UserID, TimeGroup
		END

	IF (@statistic = 'cumulative')
		BEGIN
			INSERT INTO #LogAgg (Sta3n, UserID, TimeGroup, N)
			SELECT
				Sta3n,
				UserID,
				TimeGroup,
				SUM(N) OVER (PARTITION BY Sta3n, UserID ORDER BY TimeGroup) AS N
			FROM (
				SELECT
					Sta3n,
					UserID,
					TimeGroup,
					COUNT(*) AS N
				FROM #LogData
				GROUP BY Sta3n, UserID, TimeGroup
			) A
		END

	-- This temporary table is no longer needed.
	DROP TABLE #LogData;

	-- Further annotate the #LogAgg table by converting the UserID
	-- into the Staff Name and converting the station number into
	-- a more usable version of the station name based on the
	-- App.udf_StationName function.
	--
	-- An additional ID column is included so that Entity Framework
	-- has something to use as a primary key. Ironically, there is
	-- no column in the table which is guaranteed to be non-NULL
	-- for all values of the parameters. And apparently, having
	-- ID as the ORDER BY inside the OVER clause defining ID
	-- isn't invalid. I have no idea what it means, though.
	-- However, since the ID is not semantically meaningful (it
	-- just has to be unique), it doesn't matter.
	--
	-- Return this further annotated table.
	SELECT
		ROW_NUMBER() OVER (ORDER BY la.Sta3n) AS ID,
		la.UserID,
		la.Sta3n,
		la.TimeGroup,
		la.N,
		lc.LastName + ', ' + lc.FirstName AS StaffName,
		App.udf_StationName(la.Sta3n) AS Station
	FROM
		#LogAgg AS la
		LEFT JOIN CDWWork.LCustomer.LCustomer lc
			ON la.UserID = lc.ADDomain + '\' + lc.ADLogin
	ORDER BY Sta3n, UserID, TimeGroup
END
GO
PRINT N'Creating [App].[NVCC_usp_UserCounts]...';


GO

CREATE PROCEDURE [App].[NVCC_usp_UserCounts]

-- NOTICE:
-- Do not edit the stored procedure live on the server. Code to generate
-- the procedures is stored in the project repository. Any changes made
-- that are not recorded in the repository will be overwritten.

AS
--==================================================================================
--Requestor             : Non Va Coordinated Care Project
--Author                : Brian Diggs
--Object/SP Name        : NVCC_usp_UserCounts
--Server                : 
--Data Base             : CC_REFDOC
--Schema                : App
--Report                : N/A
--Folder                : N/A
--Report Loc            : N/A
--Job                   : None
--Job Loc               : None
--Note                  : 
--Date Created          : 08-02-2016
--
--Last Changed          : 2017-07-24
--Last Changed By		: Brian Diggs
--Reason For Change		: Convert to use NVCC_UsersV2 and NVCC_ProductionLog.
--                        Drop LoggedUsers.
--
--Purpose               : Various counts of users
--==================================================================================
--Uses: App.NVCC_UsersV2
--Uses: App.NVCC_ProductionLog
--Uses: App.NVCC_udf_ActiveUserCount()

SELECT
	T.LookedUsers,
	0 AS LoggedUsers, -- Used to be the number of users who had generated a logged entry, but expensive to calculate and not useful because poorly defined
	R.RDPUsers,
	A.ActiveUsers,
	A.ActiveSites
FROM
	(
		SELECT COUNT(*) AS LookedUsers
		FROM App.NVCC_UsersV2
	) AS T
	CROSS JOIN
	(
		SELECT COUNT(DISTINCT UserID) AS RDPUsers
		FROM App.NVCC_ProductionLog
	) AS R
	CROSS JOIN
	(
		SELECT
			SUM(ActiveUsers) AS ActiveUsers,
			COUNT(*) AS ActiveSites
		FROM App.NVCC_udf_ActiveUserCount()
	) AS A
GO
PRINT N'Creating [PanelMgmt].[usp_PMUpdateMasterLabIndexFromLOINC]...';


GO


CREATE PROCEDURE [PanelMgmt].[usp_PMUpdateMasterLabIndexFromLOINC] 
AS
--=================================================================================
--Requestor				: Jianji Yang
--Author                : Jerry Kohler (Original script by Steve Schreiner)
--Object/SP Name		: [PanelMgmt].[usp_PMUpdateMasterLabIndexfromLOINC]
--SERVER				: SERVER      
--Data Base				: NWIC_PanelMgmt
--Schema				: PanelMgmt
--Report				: None Yet
--Folder				:
--Report Loc            : 
--Job                   : None
--Job Loc               : None
--Note                  : 
--Date Created          : 12-28-2015
--Last Changed          :   
--Last Changed By		: 
--Reason For Change		:                              
--Purpose               : Update Panel Management Master Lab Index table 
--                        with lab test that have valid LOINC codes.  This is done
--                        through the BISL's incremental update method in the first
--                        section.  This is done to decrease the processing time
--                        and conserve server resources.
--=================================================================================
SET NOCOUNT on

BEGIN
    /* 
    Locate and load the outstanding Chem.LabChem batches since the
    last execution rather than processing the entire Chem.LabChem view.
    */

	--declare batch variables and cursor
	DECLARE @ETLBatchID   AS INT, @ExtractBatchID AS INT;
	DECLARE @DWViewSchema AS VARCHAR(50) = 'Chem';
	DECLARE @DWViewName   AS VARCHAR(50) = 'LabChem';


    DECLARE BatchCursor CURSOR STATIC FOR
	--get batch ids
	   SELECT EX.ETLBatchID, EX.ExtractBatchID
	   FROM SPV.EB.ExtractBatch AS EX
	   INNER JOIN Dflt.ExtractBatchLog AS EL
               ON EX.DWViewSchema = EL.DWViewSchema AND EX.DWViewName = EL.DWViewName
	   WHERE EX.DWViewSchema = @DWViewSchema
         AND EX.DWViewName   = @DWViewName
         AND EX.ExtractBatchID > EL.LastExtractBatchID
	   ORDER BY EX.ExtractBatchID;

	OPEN BatchCursor;
	FETCH NEXT FROM BatchCursor INTO @ETLBatchID, @ExtractBatchID;

	WHILE @@FETCH_STATUS = 0
	BEGIN

        IF (SELECT OBJECT_ID('tempdb..#LabChemPrep')) IS NOT NULL
        DROP TABLE #LabChemPrep

		-- the lab results load table has duplicate records, which the
        -- MERGE statement will not tolerate.  Try and get the latest
        -- record for each LabChemTestSID in the batch by sorting on
        -- specimen date time descending within that LabChemTestSID
		SELECT [Sta3n]
              ,[LabChemTestSID]
              ,[LOINCSID]
              ,[LabChemSpecimenDateTime]
              ,[LabChemCompleteDateTime]
              ,[ETLBatchID]
              ,[OpCode]
              ,[VistaCreateDate]
              ,[VistaEditDate]
              ,row_number() over (Partition by LabChemTestSID
                                      order by LabChemTestSID, LabChemSpecimenDateTime DESC) AS RN
        INTO #LabChemPrep
		FROM SPV.Chem.LabChem
		WHERE ETLBatchID = @ETLBatchID            

		-- merge data into production(destination) table
		MERGE 
			ETL.ProdLabChem AS D
		USING
			(
				SELECT [Sta3n]
                      ,[LabChemTestSID]
                      ,[LOINCSID]
                      ,[LabChemSpecimenDateTime]
                      ,[LabChemCompleteDateTime]
                      ,[ETLBatchID]
                      ,[OpCode]
                      ,[VistaCreateDate]
                      ,[VistaEditDate]
                      ,RN
				FROM #LabChemPrep
				WHERE ETLBatchID = @ETLBatchID
                  AND RN = 1 -- the latest record for a given LabChemTestSID
			) AS M
		ON
			D.LabChemTestSID = M.LabChemTestSID
		WHEN NOT MATCHED THEN
			INSERT
				(
					   [Sta3n]
                      ,[LabChemTestSID]
                      ,[LOINCSID]
                      ,[LabChemSpecimenDateTime]
                      ,[LabChemCompleteDateTime]
                      ,[ETLBatchID]
                      ,[OpCode]
                      ,[VistaCreateDate]
                      ,[VistaEditDate]
				)
			VALUES
				(
                     M.[Sta3n]
                    ,M.[LabChemTestSID]
                    ,M.[LOINCSID]
                    ,M.[LabChemSpecimenDateTime]
                    ,M.[LabChemCompleteDateTime]
                    ,M.[ETLBatchID]
                    ,M.[OpCode]
                    ,M.[VistaCreateDate]
                    ,M.[VistaEditDate]

				)
		WHEN MATCHED THEN
			UPDATE SET
                       [Sta3n]                   = M.[Sta3n]
					  ,[LabChemTestSID]          = M.[LabChemTestSID]
                      ,[LOINCSID]                = M.[LOINCSID]
                      ,[LabChemSpecimenDateTime] = M.[LabChemSpecimenDateTime]
                      ,[LabChemCompleteDateTime] = M.[LabChemCompleteDateTime]
                      ,[ETLBatchID]              = M.[ETLBatchID]
                      ,[OpCode]                  = M.[OpCode]
                      ,[VistaCreateDate]         = M.[VistaCreateDate]
                      ,[VistaEditDate]           = M.[VistaEditDate]
		;

		-- after merging batch then update the ExtractBatchLog table
		UPDATE Dflt.ExtractBatchLog
		   SET LastExtractBatchID = @ExtractBatchID, LastExtractDateTime = GETDATE()
         WHERE DWViewSchema = @DWViewSchema
           AND DWViewName   = @DWViewName;

		-- grab the next batch for processing
		FETCH NEXT FROM BatchCursor INTO @ETLBatchID, @ExtractBatchID;
	END

	-- close and deallocate the cursor once all batches for a given table have been processed
	CLOSE BatchCursor;
	DEALLOCATE BatchCursor;

--
--
--
--  Using the incrementally updated ETL.ProdLabChem rather than the full
--  CDWWork.Dim.Labchem view, insert new lab tests into [PanelMgmt].[PMMasterLabIndex] 
--
--
--
   -- all LOINC SIDS for all stations defined in PMMasterCohortSite
   IF (SELECT OBJECT_ID('tempdb..#TempLOINCSID')) IS NOT NULL
   DROP TABLE #TempLOINCSID

   select li.LOINCSID
          ,li.Sta3n
          ,lc.LOINC
          ,lc.TestGroup
          ,lc.ResultForTestNumeric
          ,dateadd(yy,lc.YearSearchCriteria,getdate()) as YearSearchDate
   into	#TempLOINCSID
   from	[PanelMgmt].[PMMasterCohortLabTestGroupsLOINCCodes] as lc
   inner join [CDWWork].[Dim].[LOINC] as li on lc.LOINC = li.LOINC
   inner join [PanelMgmt].[PMMasterCohortSite] as cs on li.Sta3n = cs.Sta3n;


   -- based on LOINC codes, are there any new lab tests we do NOT
   -- already have in PMMasterLabIndex?
   IF (SELECT OBJECT_ID('tempdb..#InsertTheseRecords')) IS NOT NULL
   DROP TABLE #InsertTheseRecords

   select distinct li.LabChemTestSID
   				  ,li.Sta3n
   				  ,li.LabChemTestName
   				  ,tl.ResultForTestNumeric
   				  ,getdate() as DateExtracted
   				  ,tl.TestGroup
   				  ,tl.LOINC
   				  ,NULL as WorkLoadCode
   into         #InsertTheseRecords
   from			[ETL].ProdLabChem lc
   inner join	[CDWWork].[Dim].[LabChemTest] as li on lc.LabChemTestSID = li.LabChemTestSID
   inner join   #TempLOINCSID tl on lc.Sta3n = li.Sta3n AND lc.LabChemCompleteDateTime > tl.YearSearchDate
   where        lc.LOINCSID = tl.LOINCSID
     and        not exists (select ni.LabChemTestSID
   				              from [PanelMgmt].[PMMasterLabIndex] as ni
   						     where li.LabChemTestSID = ni.LabChemTestSID
   							   and li.Sta3n = ni.Sta3n);

   Insert into [PanelMgmt].[PMMasterLabIndex]
   (
      LabChemTestSID,
      Sta3n,
      LabChemTestName,
      ResultForTestNumeric,
      DateExtracted,
      TestGroup,
      LOINC,
      WorkLoadCode
   )
   Select LabChemTestSID,
          Sta3n,
          LabChemTestName,
          ResultForTestNumeric,
          DateExtracted,
          TestGroup,
          LOINC,
          WorkLoadCode
    From #InsertTheseRecords
   
   Drop table #InsertTheseRecords
--select top 1000 * from #InsertTheseRecords
--select * from #InsertTheseRecords where LabChemTestSID in (select LabChemTestSID from [PanelMgmt].[PMMasterLabIndex])
--select distinct dateextracted from #InsertTheseRecords
--select count(*) from #InsertTheseRecords
--select a.*, b.* from #InsertTheseRecords a join cdwwork.dim.labchemtest b on b.LabChemTestSID = a.LabChemTestSID
--select a.* from #InsertTheseRecords a join cdwwork.dim.labchemtest b on b.LabChemTestSID = a.LabChemTestSID where b.Sta3n != a.Sta3n

   UPDATE [PanelMgmt].[PMMasterCohortLabTestGroupsLOINCCodes]
      set LastUpdate = cast(getdate() as date);

END
GO
PRINT N'Creating [PanelMgmt].[usp_PMUpdateMasterLabIndexFromWorkload]...';


GO
CREATE PROCEDURE [PanelMgmt].[usp_PMUpdateMasterLabIndexFromWorkload] 

-- NOTICE:
-- Do not edit the stored procedure live on the server. Code to generate
-- the procedures is stored in the project repository. Any changes made
-- that are not recorded in the repository will be overwritten.

AS
--=============================================================================================================
--Requestor				: Jianji Yang
--Author                : Steve Schreiner
--Object/SP Name		: [PanelMgmt].[usp_PMUpdateMasterLabIndexFromWorkload]
--SERVER				: 
--Data Base				: CC_REFDOC
--Schema				:    
--Report				: None Yet
--Folder				:
--Report Loc            : 
--Job                   : None
--Job Loc               : None
--Note                  : 
--Date Created          : 08-04-2014
--Last Changed          : 08-24-2017  
--Last Changed By		: Brian Diggs
--Reason For Change		: Rebuild as an inner join rather than an assembled string which is exec'd
--
--Last Changed          : 05-15-2015  
--Last Changed By		: Jianji Yang
--Reason For Change		: exclude NON-HDL from 668 which is assigned to LDL workload code                             
--Purpose               : Update Panel Management Master Lab Index table 
--                        with lab test with validate workload codes.
--===============================================================================================================
BEGIN

	insert			[PanelMgmt].[PMMasterLabIndex]
	select 
					li.LabChemTestSID,
					li.Sta3n,
					li.LabChemTestName,
					tg.ResultForTestNumeric,
					getdate() as DateExtracted,
					tg.TestGroup,
					null as LOINC,
					nc.WorkloadCode
	from			[CDWWork].[dim].[LabChemTest] as li
	left outer join [CDWWork].[dim].[NationalVALabCode] as nc on
					li.NationalVALabCodeSID = nc.NationalVALabCodeSID
	inner join		[PanelMgmt].[PMMasterCohortSite] as cs on
					li.Sta3n = cs.Sta3n
	inner join		(select distinct
						TestGroup,
						ResultForTestNumeric,
						TestSearchCriteria
					from [PanelMgmt].[PMMasterCohortLabTestGroups]) as tg on
					nc.WorkloadCode like tg.TestSearchCriteria
	where			not exists (select ni.LabChemTestSID
									from [PanelMgmt].[PMMasterLabIndex] as ni
									where li.LabChemTestSID = ni.LabChemTestSID
										  and li.Sta3n = ni.Sta3n)
	order by		li.Sta3n

	-- remove non HDL lab with LDL workload code assigned. working with local CAC to reassign appropiate code 
	-- LabChemTestSID	LabChemTestIEN	Sta3n	LabChemTestName	    LabChemPrintTestName	NLTNationalVALabCodeSID	NationalVALabCodeSID
	-- 800223162                  7054    668   NON-HDL CHOLESTEROL NHDL                    800522569               800398429

	delete FROM [PanelMgmt].[PMMasterLabIndex] where LabChemTestName like '%NON-HDL%'

END
GO
PRINT N'Creating [PanelMgmt].[usp_RebuildAllCDWPatients]...';


GO

CREATE PROCEDURE [PanelMgmt].[usp_RebuildAllCDWPatients] 
AS
--==================================================================================
--Requestor             : Non Va Coordinated Care Project, but produces a great
--                        general use all patient table for any application.
--Author                : Jerry Kohler, Jianji Yang - Northwest Innovation Center
--Object/SP Name        : usp_RebuildAllCDWPatients
--Server                : SERVER      
--Data Base             : CC_REFDOC
--Schema                : PanelMgmt
--Report                : N/A
--Folder                : N/A
--Report Loc            : N/A
--Job                   : None
--Job Loc               : None
--Note                  : This table contains ALL patients, including
--                        deceased and test.
--Date Created          : 03-10-2016
--
--
--Purpose               : Because SPatient does not have an index on PatientSSN,
--                        we create a table to translate between several types of
--                        patient identification for REFDOC:
--                           - SSN
--                           - SID
--                           - ICN
--                           - Name (last,first)
--                           - CPRSKey (first character of last name, last4)
--
--Last Changed          : 08-10-2017
--Last Changed By		: Brian Diggs - NWIC
--Reason For Change		: Process was still blocking for way too long, preventing
--                        lookups of patients. Refactored based on discussions
--                        with Andrew Kelly. Extract the batches outside the
--                        (blocking) MERGE, then filter them while
--                        flagging if the record is an update or insert.
--                        Do the updates and then inserts and update the ETLBatchID
--
--Last Changed          : 07-14-2017
--Last Changed By		: Brian Diggs - NWIC
--Reason For Change		: Implemented suggestions from Andrew Kelly
--
--Last Changed          : 06-09-2017
--Last Changed By		: Brian Diggs - NWIC
--Reason For Change		: Converted to incremental update following recommended CDW 
--                        paradigm
--
--Last Changed          : 04-19-2017
--Last Changed By		: Brian Diggs - NWIC
--Reason For Change		: Stripped this down to just the parts needed for REFDOC
--                        as part of the migration to the Field Reporting Enclave.
--                        The only columns needed are Sta3n, PatientSSN, PatientICN,
--                        PatientSID, and PatientIEN.
--
--Last Changed          : 06-06-2016
--Last Changed By		: Jerry Kohler - NWIC
--Reason For Change		: Added Next of Kin, and per Microsoft recommendation
--                        changed drop/create table to drop indexes and TRUNCATE.
--                        Also added WITH (TABLOCK) in the insert.
--                        All of this should boost the performance, and not
--                        eliminate stored execution plans on the table.
--
--Last Changed          : 06-03-2016
--Last Changed By		: Jerry Kohler - NWIC
--Reason For Change		: Take all patients from SPatient, test or deceased.
--                        Join to PanelMgmt.PMMasterCohortDeceasedIndexNEW
--                        to ensure better accuracy.  Add deceased flag and
--                        date of death.

--Last Changed          : 04-05-2016
--Last Changed By		: Jianji Yang - NWIC
--Reason For Change		: Add test patient data, deceased patients, and patient's
--                      : home station (based on PCP's Sta3n).
--
--Last Changed          : 03-17-2017
--Last Changed By		: Jerry Kohler - NWIC
--Reason For Change		: Add PatientIEN so that function App.udf_AllPatientsSIDs
--                      : can now hit AllCDWPatients instead of SPatient.  This
--                      : table is much smaller, and will be much faster.
--
--Last Changed          : 03-20-2017
--Last Changed By		: Jerry Kohler - NWIC
--Reason For Change		: Change procedure to place data in a temporary table THEN
--                      : truncate and insert into the production table.  This
--                      : minimize the amount of time queries would return no data.
--==================================================================================

BEGIN

	SET NOCOUNT ON;

	--declare batch variables and cursor
	DECLARE @ETLBatchID AS INT, @ExtractBatchID AS INT;
	DECLARE @DWViewName AS VARCHAR(100) = 'SPatient';

	--add a TRY/CATCH to exit upon failure
	BEGIN TRY

		SET @ExtractBatchID = (SELECT EL.LastExtractBatchID FROM Dflt.ExtractBatchLog AS EL WHERE EL.DWViewName = @DWViewName) ;

		DECLARE BatchCursor CURSOR STATIC 
		FOR
		--get batch ids
		SELECT EX.ETLBatchID, EX.ExtractBatchID
		FROM SPV.EB.ExtractBatch AS EX
		WHERE EX.DWViewName = @DWViewName
			AND EX.ExtractBatchID > @ExtractBatchID
		ORDER BY EX.ExtractBatchID;

		CREATE TABLE #spat1 (
			Sta3n smallint,
			PatientIEN varchar(50),
			PatientSSN varchar(50),
			PatientSID int,
			PatientICN varchar(50)
		)
		DECLARE @LastExtractBatchID AS INT;

		OPEN BatchCursor;
		FETCH NEXT FROM BatchCursor INTO @ETLBatchID, @ExtractBatchID;

		WHILE @@FETCH_STATUS = 0
		BEGIN
			INSERT INTO #spat1
			SELECT Sta3n, PatientIEN, PatientSSN, PatientSID, PatientICN
			FROM SPV.SPatient.SPatient
			WHERE ETLBatchID = @ETLBatchID

			-- Store to update tracking table later
			SET @LastExtractBatchID = @ExtractBatchID

			--merge data from view into production(destination) table
			--grab the next batch for processing
			FETCH NEXT FROM BatchCursor INTO @ETLBatchID, @ExtractBatchID;
		END

		--close and deallocate the cursor once all batches for a given table have been processed
		CLOSE BatchCursor;
		DEALLOCATE BatchCursor;

		SELECT
			S.Sta3n,
			S.PatientIEN,
			S.PatientSSN,
			S.PatientSID,
			S.PatientICN,
			CASE
				WHEN A.PatientSID IS NULL THEN 'I'
				ELSE 'U'
			END AS InsertUpdate
		INTO #spat2
		FROM
			#spat1 AS S
			LEFT JOIN App.AllCDWPatients AS A WITH (NOLOCK)
				ON S.PatientSID = A.PatientSID
			WHERE
				A.PatientSID IS NULL 
				OR (S.Sta3n != A.Sta3n
					OR S.PatientICN != A.PatientICN
					OR S.PatientSSN != A.PatientSSN
					OR S.PatientIEN != A.PatientIEN)

		CREATE CLUSTERED INDEX [#tmpidx] ON #spat2 (PatientSID ASC) WITH (DATA_COMPRESSION = PAGE);

		BEGIN TRANSACTION
			UPDATE A
			SET
				A.Sta3n = U.Sta3n,
				A.PatientIEN = U.PatientIEN,
				A.PatientSSN = U.PatientSSN,
				A.PatientICN = U.PatientICN
			FROM
				App.AllCDWPatients AS A
				INNER JOIN #spat2 AS U
					ON A.PatientSID = U.PatientSID
			WHERE
				U.InsertUpdate = 'U'

			INSERT INTO App.AllCDWPatients (Sta3n, PatientIEN, PatientSSN, PatientSID, PatientICN)
			SELECT Sta3n, PatientIEN, PatientSSN, PatientSID, PatientICN
			FROM #spat2
			WHERE InsertUpdate = 'I'

			--after merging batch then update the ExtractBatchLog table
			UPDATE Dflt.ExtractBatchLog
				SET LastExtractBatchID = @LastExtractBatchID, LastExtractDateTime = GETDATE()
			WHERE DWViewName = @DWViewName;

		COMMIT TRANSACTION

	END TRY

	--CATCH will report back specific details about failure; the loop will stop
	BEGIN CATCH

		IF @@TRANCOUNT > 0
			ROLLBACK TRANSACTION;

		SELECT
		ERROR_NUMBER() AS ErrorNumber,
		ERROR_SEVERITY() AS ErrorSeverity,
		ERROR_STATE() AS ErrorState,
		ERROR_PROCEDURE() AS ErrorProcedure,
		ERROR_LINE() AS ErrorLine,
		ERROR_MESSAGE() AS ErrorMessage;
         
	END CATCH 

END
GO
PRINT N'Creating Permission...';


GO
GRANT DELETE
    ON SCHEMA::[App] TO [uCC_REFDOC_App];


GO
PRINT N'Creating Permission...';


GO
GRANT EXECUTE
    ON SCHEMA::[App] TO [uCC_REFDOC_App];


GO
PRINT N'Creating Permission...';


GO
GRANT INSERT
    ON SCHEMA::[App] TO [uCC_REFDOC_App];


GO
PRINT N'Creating Permission...';


GO
GRANT SELECT
    ON SCHEMA::[App] TO [uCC_REFDOC_App];


GO
PRINT N'Creating Permission...';


GO
GRANT UPDATE
    ON SCHEMA::[App] TO [uCC_REFDOC_App];


GO
PRINT N'Creating Permission...';


GO
DENY ALTER
    ON SCHEMA::[dbo] TO [uCC_REFDOC] CASCADE;


GO
/*
Post-Deployment Script Template							
--------------------------------------------------------------------------------------
 This file contains SQL statements that will be appended to the build script.		
 Use SQLCMD syntax to include a file in the post-deployment script.			
 Example:      :r .\myfile.sql								
 Use SQLCMD syntax to reference a variable in the post-deployment script.		
 Example:      :setvar TableName MyTable							
               SELECT * FROM [$(TableName)]					
--------------------------------------------------------------------------------------
*/

-- The CDW envrionment requires that any stored procedure or function in the
-- App schema executed by the App account (CC_REFDOC_APP) and referencing
-- anything in the CDWWork database be signed. If only items in the project
-- database (any schema) are referenced, it need not be signed.

-- Commented out items below used to require signing, but with refactoring
-- they no longer do. Left in the file and commented to be an affirmative
-- statement that they do not need to be signed rather than that they were
-- overlooked.

exec dbo.sp_SignAppObject 'NVCC_Rebuild_SensitiveDxCodesTable'
exec dbo.sp_SignAppObject 'NVCC_usp_CurrentUsage'
exec dbo.sp_SignAppObject 'NVCC_usp_GetAllergies'
exec dbo.sp_SignAppObject 'NVCC_usp_GetAnnouncement'
exec dbo.sp_SignAppObject 'NVCC_usp_GetAppts'
exec dbo.sp_SignAppObject 'NVCC_usp_GetConsults'
exec dbo.sp_SignAppObject 'NVCC_usp_GetDivision'
exec dbo.sp_SignAppObject 'NVCC_usp_GetDivisions'
exec dbo.sp_SignAppObject 'NVCC_usp_GetLabs'
exec dbo.sp_SignAppObject 'NVCC_usp_GetNextOfKin'
exec dbo.sp_SignAppObject 'NVCC_usp_GetNVAMeds'
exec dbo.sp_SignAppObject 'NVCC_usp_GetPatient'
exec dbo.sp_SignAppObject 'NVCC_usp_GetPatientBySid'
exec dbo.sp_SignAppObject 'NVCC_usp_GetProbs'
exec dbo.sp_SignAppObject 'NVCC_usp_GetSensDx'
exec dbo.sp_SignAppObject 'NVCC_usp_GetVAMeds'
exec dbo.sp_SignAppObject 'NVCC_usp_GetXdwFacility'
exec dbo.sp_SignAppObject 'NVCC_usp_GetXdwFacilityBySta3n'
exec dbo.sp_SignAppObject 'NVCC_usp_GetXdwUser'
--exec dbo.sp_SignAppObject 'NVCC_usp_ProductionAccessLogUniqueSta3n'
exec dbo.sp_SignAppObject 'NVCC_usp_ProductionAccessLogUniqueUsers'
exec dbo.sp_SignAppObject 'NVCC_usp_UniqueVeterans'
exec dbo.sp_SignAppObject 'NVCC_usp_UsageData2'
--exec dbo.sp_SignAppObject 'NVCC_usp_UserCounts'
--exec dbo.sp_SignAppObject 'NVCC_udf_ActiveUserCount'
GO

GO
PRINT N'Update complete.';


GO
