﻿CREATE TABLE [App].[PCMMCurrentPatientProviderRelationship] (
    [Sta3n]                   SMALLINT      NOT NULL,
    [PatientSID]              INT           NULL,
    [StaffIEN]                VARCHAR (50)  NULL,
    [PrimaryProviderSID]      INT           NULL,
    [PrimaryProvider]         VARCHAR (100) NULL,
    [AssociateProviderSID]    INT           NULL,
    [AssociateProviderIEN]    VARCHAR (50)  NULL,
    [AssociateProvider]       VARCHAR (100) NULL,
    [ProviderRole]            VARCHAR (100) NULL,
    [TeamSID]                 INT           NULL,
    [TeamIEN]                 VARCHAR (50)  NULL,
    [Team]                    VARCHAR (50)  NULL,
    [InstitutionSID]          INT           NULL,
    [InstitutionCode]         VARCHAR (50)  NULL,
    [DivisionName]            VARCHAR (50)  NULL,
    [TeamPurpose]             VARCHAR (50)  NULL,
    [RelationshipStartDate]   DATETIME2 (0) NULL,
    [RelationshipEndDate]     DATETIME2 (0) NULL,
    [CurrentProviderFlag]     CHAR (1)      NULL,
    [AssociateProviderFlag]   CHAR (1)      NULL,
    [PrimaryPosition]         VARCHAR (100) NULL,
    [PrimaryCarePositionFlag] VARCHAR (1)   NOT NULL,
    [Source]                  VARCHAR (10)  NOT NULL,
    [ProviderType]            VARCHAR (50)  NULL
);


GO
CREATE CLUSTERED INDEX [PCMMCurrentPatientProviderRelationship_PatientSID]
    ON [App].[PCMMCurrentPatientProviderRelationship]([PatientSID] ASC) WITH (DATA_COMPRESSION = PAGE);


GO
CREATE NONCLUSTERED INDEX [PCMMCurrentPatientProviderRelationship_PrimaryProviderSID]
    ON [App].[PCMMCurrentPatientProviderRelationship]([PrimaryProviderSID] ASC)
    INCLUDE([AssociateProviderSID], [PatientSID]) WITH (DATA_COMPRESSION = PAGE);

