﻿CREATE TABLE [App].[NVCC_ProductionLog] (
    [AccessLogID]        INT           NOT NULL,
    [UserID]             VARCHAR (50)  NOT NULL,
    [AccessDateTime]     DATETIME      NOT NULL,
    [PatientSID]         INT           NOT NULL, 
    [PatientICN]         VARCHAR(50)   NULL, 
    [Sta3n]              SMALLINT      NOT NULL
);
GO

CREATE CLUSTERED INDEX [NVCC_ProductionLog_AccessDateTime_UserID]
    ON [App].[NVCC_ProductionLog]([AccessDateTime] ASC, [UserID] ASC) WITH (DATA_COMPRESSION = PAGE);
GO

CREATE INDEX [NVCC_ProductionLog_Sta3n]
	ON [App].[NVCC_ProductionLog](Sta3n) 
	INCLUDE (PatientICN) WITH (DATA_COMPRESSION = PAGE)
GO