﻿USE [CC_REFDOC]
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO

SET ANSI_PADDING ON
GO

IF NOT EXISTS ( SELECT 1 FROM INFORMATION_SCHEMA.TABLES T
        WHERE T.TABLE_SCHEMA = 'App'
        AND T.TABLE_NAME = 'NVCC_Roles'  )
		 BEGIN
create table [App].[NVCC_Roles] (
   RoleId int identity not null primary key,
   RoleName nvarchar(50),
   Description nvarchar(100)
)
END
GO

IF NOT EXISTS ( SELECT 1 FROM INFORMATION_SCHEMA.TABLES T
        WHERE T.TABLE_SCHEMA = 'App'
        AND T.TABLE_NAME = 'NVCC_UserRoles'  )
		 BEGIN
create table [App].[NVCC_UserRoles] (
    UserId int not null,
    RoleId int not null,
    primary key(UserId, RoleId),
	CONSTRAINT FK_UserRoles_Roles FOREIGN KEY(RoleId) REFERENCES [App].[NVCC_Roles](RoleId),
	CONSTRAINT FK_UserRoles_UsersV2 FOREIGN KEY(UserId) references [App].[NVCC_UsersV2](UserId)
)
END
GO