﻿USE [CC_REFDOC]
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO

SET ANSI_PADDING ON
GO

IF NOT EXISTS ( SELECT 1 FROM INFORMATION_SCHEMA.TABLES T
        WHERE T.TABLE_SCHEMA = 'App'
        AND T.TABLE_NAME = 'NVCC_DisclosedAppointment'  )
    BEGIN
CREATE TABLE [App].[NVCC_DisclosedAppointment](
	[DisclosedAppointmentId] [bigint] IDENTITY(1,1) NOT NULL,
	[DisclosureId] [int] NOT NULL,
	--AppointmentId is optional but I believe it would be good to have it in case AoD requirements change in the future.
	--It uniquely identifies the appointment in CDW so more information about the appointment could be retrieved if necessary.
	[AppointmentId] [bigint] NOT NULL,
	[LocationName] [varchar](50) NULL,    
	[AppointmentDateTime] [datetime2](2) NULL,
	--NOTE: The stored Proc, [App].[NVCC_usp_GetAppts] returns a varchar(61) for AppointmentDateTime
	--We will have to convert it to a DateTime in code, however, are we 100% sure what format it will be in always?
	--It would use less space to store a [datetime2](0), but should we just store it as is? A varchar(61)? That would be easier and
	--would be guaranteed to not have any errors.
	--[AppointmentDateTime] [varchar](61) NULL,
PRIMARY KEY (DisclosedAppointmentId),
CONSTRAINT FK_DisclosedAppointment_Disclosure FOREIGN KEY(DisclosureId) REFERENCES [App].[NVCC_Disclosure](DisclosureId) ON DELETE CASCADE
) 
END
GO

IF NOT EXISTS ( SELECT 1 FROM INFORMATION_SCHEMA.TABLES T
        WHERE T.TABLE_SCHEMA = 'App'
        AND T.TABLE_NAME = 'NVCC_DisclosedProblemDiagnosis'  )
    BEGIN
CREATE TABLE [App].[NVCC_DisclosedProblemDiagnosis](
	[DisclosedProblemDiagnosisId] [bigint] IDENTITY(1,1) NOT NULL,
	[DisclosureId] [int] NOT NULL,
	--ProblemListSID is optional but I believe it would be good to have it in case AoD requirements change in the future.
	--It uniquely identifies the problem in CDW so more information about the problem could be retrieved if necessary.
	[ProblemListSID] [bigint] NOT NULL,
    [ICDCode] [varchar](50) NULL,
	[Problem] [varchar](50) NULL,
PRIMARY KEY (DisclosedProblemDiagnosisId),
CONSTRAINT  FK_DisclosedProblemDiagnosis_Disclosure FOREIGN KEY(DisclosureId) REFERENCES [App].[NVCC_Disclosure](DisclosureId) ON DELETE CASCADE
) 
END
GO

IF NOT EXISTS ( SELECT 1 FROM INFORMATION_SCHEMA.TABLES T
        WHERE T.TABLE_SCHEMA = 'App'
        AND T.TABLE_NAME = 'NVCC_DisclosedRadiologyReport'  )
    BEGIN
CREATE TABLE [App].[NVCC_DisclosedRadiologyReport](
	[DisclosedRadiologyReportId] [bigint] IDENTITY(1,1) NOT NULL,
	[DisclosureId] [int] NOT NULL,
	--RadiologyReportId is optional but I believe it would be good to have it in case AoD requirements change in the future.
	--It uniquely identifies the RadiologyReport in CDW or VistA so more information about the RadiologyReport could be retrieved if necessary.
	[RadiologyReportId] [varchar](25) NULL, --Not sure if should be null or not
    [ProcedureName] [varchar](50) NULL,
	[ExamDate] [datetime2](2) NOT NULL,
PRIMARY KEY (DisclosedRadiologyReportId),
CONSTRAINT  FK_DisclosedRadiologyReport_Disclosure FOREIGN KEY(DisclosureId) REFERENCES [App].[NVCC_Disclosure](DisclosureId) ON DELETE CASCADE
) 
END
GO

IF NOT EXISTS ( SELECT 1 FROM INFORMATION_SCHEMA.TABLES T
        WHERE T.TABLE_SCHEMA = 'App'
        AND T.TABLE_NAME = 'NVCC_DisclosedProgressNote'  )
    BEGIN
CREATE TABLE [App].[NVCC_DisclosedProgressNote](
	[DisclosedProgressNoteId] [bigint] IDENTITY(1,1) NOT NULL,
	[DisclosureId] [int] NOT NULL,
	--NoteID is optional but I believe it would be good to have it in case AoD requirements change in the future.
	--It uniquely identifies the Note in CDW or VistA so more information about the NoteID could be retrieved if necessary.
	[NoteID] [varchar](25) NULL, --Not sure if should be null or not
	[NoteTimestamp] [datetime2] NULL,
	[NoteTitle] [varchar](100) NULL,
	[NoteAuthor] [varchar](50) NULL,
PRIMARY KEY (DisclosedProgressNoteId),
CONSTRAINT  FK_DisclosedProgressNote_Disclosure FOREIGN KEY(DisclosureId) REFERENCES [App].[NVCC_Disclosure](DisclosureId) ON DELETE CASCADE
) 
END
GO

IF NOT EXISTS ( SELECT 1 FROM INFORMATION_SCHEMA.TABLES T
        WHERE T.TABLE_SCHEMA = 'App'
        AND T.TABLE_NAME = 'NVCC_DisclosedAuthorization'  )
    BEGIN
CREATE TABLE [App].[NVCC_DisclosedAuthorization](
	[DisclosedAuthorizationId] [bigint] IDENTITY(1,1) NOT NULL,
	[DisclosureId] [int] NOT NULL,
	--AuthorizationId is optional but I believe it would be good to have it in case AoD requirements change in the future.
	--It uniquely identifies the Authorization in CDW or VistA so more information about the Authorization could be retrieved if necessary.
	[AuthorizationId] [varchar](25) NULL, --Not sure if should be null or not
	[AuthorizationTitle] [varchar](100) NULL,
PRIMARY KEY (DisclosedAuthorizationId),
CONSTRAINT  FK_DisclosedAuthorization_Disclosure FOREIGN KEY(DisclosureId) REFERENCES [App].[NVCC_Disclosure](DisclosureId) ON DELETE CASCADE
) 
END
GO

IF NOT EXISTS ( SELECT 1 FROM INFORMATION_SCHEMA.TABLES T
        WHERE T.TABLE_SCHEMA = 'App'
        AND T.TABLE_NAME = 'NVCC_DisclosedConsult' )
    BEGIN
CREATE TABLE [App].[NVCC_DisclosedConsult](
	[DisclosedConsultId] [bigint] IDENTITY(1,1) NOT NULL,
	[DisclosureId] [int] NOT NULL,
	--ConsultId is optional but I believe it would be good to have it in case AoD requirements change in the future.
	--It uniquely identifies the Consult in CDW or VistA so more information about the Consult could be retrieved if necessary.
	[ConsultId] [bigint] NOT NULL, --Not sure if should be null or not
	[RequestDate] [datetime2](2) NULL,
	[CPRSStatus] [varchar](50) NULL,
	[EarliestDate] [datetime2](2) NULL,
	[Urgency] [varchar](50) NULL
PRIMARY KEY (DisclosedConsultId),
CONSTRAINT  FK_DisclosedConsult_Disclosure FOREIGN KEY(DisclosureId) REFERENCES [App].[NVCC_Disclosure](DisclosureId) ON DELETE CASCADE
) 
END
GO

--public long DisclosedConsultId { get; set; }
--        public int DisclosureId { get; set; }
--        public long ConsultId { get; set; }
--        public DateTime? RequestDate { get; set; }
--        public string CPRSStatus { get; set; }
--        public DateTime? EarliestDate { get; set; }
--        public string Urgency { get; set; }

IF NOT EXISTS (
  SELECT * 
  FROM   sys.columns 
  WHERE  object_id = OBJECT_ID(N'[App].[NVCC_Disclosure]') 
         AND name = 'ReferralType'
)
BEGIN

    ALTER TABLE [App].[NVCC_Disclosure] ADD 
        [ReferralType] [varchar](50) NULL
END

GO

IF NOT EXISTS (
  SELECT * 
  FROM   sys.columns 
  WHERE  object_id = OBJECT_ID(N'[App].[NVCC_Disclosure]') 
         AND name = 'Sta3n'
)
BEGIN

    ALTER TABLE [App].[NVCC_Disclosure] ADD 
        [Sta3n] [smallint] NOT NULL
END

GO

IF NOT EXISTS (
  SELECT * 
  FROM   sys.columns 
  WHERE  object_id = OBJECT_ID(N'[App].[NVCC_Disclosure]') 
         AND name = 'VISN'
)
BEGIN

    ALTER TABLE [App].[NVCC_Disclosure] ADD 
        [VISN] [smallint] NULL
END

GO

IF NOT EXISTS (
  SELECT * 
  FROM   sys.columns 
  WHERE  object_id = OBJECT_ID(N'[App].[NVCC_Disclosure]') 
         AND name = 'StationName'
)
BEGIN

    ALTER TABLE [App].[NVCC_Disclosure] ADD 
        [StationName] [varchar](50) NULL
END

GO