USE [NWIC_PanelMgmt]
GO

/****** Object:  View [App].[vAppts]    Script Date: 1/27/2016 2:57:01 PM ******/
SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO

CREATE VIEW [App].[vAppts] AS
--=================================================================================
--Requestor		        : Non Va Coordinated Care Project
--Author                : Jerry Kohler
--Object/SP Name	    : vGetAppts
--SERVER		        : DNS   DNS.URL        
--Data Base		        : NWIC_PanelMgmt
--Schema		        : app
--Report		        : N/A
--Folder		        : N/A
--Report Loc            : N/A
--Job                   : None
--Job Loc               : None
--Note                  : 
--Date Created          : 01-12-2016
--
--Last Changed          : 02-18-2016  
--Last Changed By		: Jerry Kohler - Northwest Innovation Center (NWIC)
--Reason For Change		: Request to also provide the name of the station.
--
--Last Changed          : 01-27-2016  
--Last Changed By	    : Jerry Kohler - Northwest Innovation Center (NWIC)
--Reason For Change	    : This view created from the stored procedure
--                        NVA.GetAppts in order to facilitate asynchronous
--                        processing by the application.
--
--Purpose               : Retrieve a patient's recent appointments for inclusion
--                        into NVCC documentation
--=================================================================================

SELECT --TOP (100)
      ap.Sta3n
     ,App.udf_StationName (ap.Sta3n) AS StationName
     ,loc.LocationName
     ,convert(varchar, AppointmentDateTime, 101) + ' ' + convert(varchar, AppointmentDateTime, 8) AS AppointmentDateTime
     ,ap.AppointmentSID
     ,ap.PatientSID
     ,ap.AppointmentTypeSID
     ,desireddate =
      CASE
         When desiredappointmentdate is null
         Then convert(varchar(12), cast(dateadd(day, 1, appointmentmadedatetime) as date), 101)
         Else convert(varchar(12), cast(desiredappointmentdate as date), 101)
      END
     ,ap.CancelNoShowCode
     ,ap.LocationSID, ap.PurposeOfVisit
     ,ap.SchedulingRequestType
     ,ap.CancelDateTime
     ,ap.AppointmentCancelledFlag

FROM CDWWork.Appt.Appointment AS ap
JOIN CDWWork.dim.Location AS loc ON ap.LocationSID = loc.LocationSID
WHERE ap.appointmentdatetime >= convert(DATE, dateadd(mm, 6, getdate()))

GO
