USE [NWIC_PanelMgmt]
GO

SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO

SET ANSI_PADDING ON
GO

CREATE FUNCTION [app].[udf_StationName] (@Sta3n VARCHAR(MAX))
RETURNS VARCHAR(50)
AS
--=================================================================================
--Requestor				: Non Va Coordinated Care Project
--Author                : Jerry Kohler - Northwest Innovation Center (NWIC)
--Object/SP Name		: udf_StationName
--SERVER				: DNS   DNS.URL        
--Data Base				: NWIC_PanelMgmt
--Schema				: app
--Report				: N/A
--Folder				: N/A
--Report Loc            : N/A
--Job                   : None
--Job Loc               : None
--Note                  : 
--Date Created          : 02-18-2016
--Last Changed          : 
--Last Changed By		: 
--Reason For Change		: 
--
--Purpose               : Returns a "nicer" station name than what is stored in
--                        xDWWork.dim.institution
--=================================================================================
BEGIN

   RETURN
   (
      SELECT
      CASE
         WHEN charindex('(',substring(Sta3nName,7,50)) <=0 THEN substring(Sta3nName,7,50)
         ELSE substring(Sta3nName, 7, (charindex('(', substring(Sta3nName,7,50))-1))
      END

      FROM CDWWork.Dim.Sta3n

      WHERE Sta3n = @Sta3n
        AND Active = 'Y'
   )

END

GO
