--USE [NWIC_PanelMgmt]
--GO

SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO


ALTER VIEW [App].[NVCC_vGetNVAMeds]

AS
--=================================================================================
--Requestor				: Non Va Coordinated Care Project
--Author                : Jerry Kohler (Original script by Dr. Charles Demosthenes)
--Object/SP Name		: NVCC_vGetNVAMeds
--SERVER				: DNS   DNS.URL        
--Data Base				: NWIC_PanelMgmt
--Schema				: app
--Report				: N/A
--Folder				: N/A
--Report Loc            : N/A
--Job                   : None
--Job Loc               : None
--Note                  : 
--Date Created          : 02-05-2016
--Last Changed          : 
--Last Changed By		: 
--Reason For Change		: 
--
--Purpose               : Retrieve a patient's medications not issued by VA for
--                        inclusion into NVCC documentation
--=================================================================================

SELECT d.LocalDrugNameWithDose
      ,n.MedicationRoute
      ,n.Schedule
FROM CDWWork.NonVAMed.NonVaMed n
INNER JOIN CDWWork.Dim.LocalDrug d ON n.LocalDrugSID = d.LocalDrugSID;


GO


