--DROP PROCEDURE App.NVCC_usp_UserCounts
USE NWIC_PanelMgmt
GO

SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO

CREATE PROCEDURE App.NVCC_usp_UserCounts
AS
--==================================================================================
--Requestor             : Non Va Coordinated Care Project
--Author                : Brian Diggs
--Object/SP Name        : NVCC_usp_UserCounts
--Server                : DNS   DNS.URL        
--Data Base             : NWIC_PanelMgmt
--Schema                : app
--Report                : N/A
--Folder                : N/A
--Report Loc            : N/A
--Job                   : None
--Job Loc               : None
--Note                  : 
--Date Created          : 08-02-2016
--
--
--Last Changed          : 
--Last Changed By		: 
--Reason For Change		: 
--
--Purpose               : Various counts of users
--==================================================================================
--Uses: NWIC_PanelMgmt.App.NVCC_Users
--Uses: NWIC_PanelMgmt.App.NVCC_AccessLog
--Uses: NWIC_PanelMgmt.App.vNVCC_ProductionAccessLog
--Uses: NWIC_PanelMgmt.App.NVCC_udf_activeUserCount()

-- NOTICE:
-- Do not edit the stored procedure live on the server. Code to generate
-- the procedures is stored in the project repository. Any changes made
-- that are not recorded in the repository will be overwritten.

SELECT *
FROM
	(
		SELECT COUNT(*) AS LookedUsers
		FROM app.nvcc_users
	) AS T,
	(
		SELECT COUNT(DISTINCT userID) AS LoggedUsers 
		FROM app.NVCC_AccessLog
	) AS L,
	(
		SELECT COUNT(DISTINCT userID) AS RDPUsers
		FROM app.vNVCC_ProductionAccessLog
	) AS R,
	(
		SELECT
			SUM(ActiveUsers) AS ActiveUsers,
			COUNT(*) AS ActiveSites
		FROM app.NVCC_udf_activeUserCount()
	) AS A
GO

EXEC sp_SignAppObject 'NVCC_usp_UserCounts';