--DROP PROCEDURE App.NVCC_usp_GetDivision

USE [NWIC_PanelMgmt]
GO

SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO

CREATE PROCEDURE [App].[NVCC_usp_GetDivision]
	@sta6a varchar(50)

-- NOTICE:
-- Do not edit the stored procedure live on the server. Code to generate
-- the procedures is stored in the project repository. Any changes made
-- that are not recorded in the repository will be overwritten.

AS
--=================================================================================
--Requestor				: REFDOC
--Author                : Jon Duckart 
--Object/SP Name		: NVCC_usp_GetDivision
--SERVER				: DNS   DNS.URL        
--Data Base				: NWIC_PanelMgmt
--Schema				: app
--Report				: N/A
--Folder				: N/A
--Report Loc            : N/A
--Job                   : None
--Job Loc               : None
--Note                  : 
--Date Created          : 08-25-2016
--Last Changed          : 03-15-2017
--Last Changed By		: Brian Diggs - Northwest Innovation Center (NWIC)
--Reason For Change		: Changed parameter type to varchar(50) to match the
--                        type of sta6a in the view.
--
--Last Changed          : 08-25-2016
--Last Changed By		: Jon Duckart - Northwest Innovation Center (NWIC)
--Reason For Change		: 
--
--Purpose               : Retrieve a user's Sta6a for VIA calls
--=================================================================================
--Uses: CDWWork.Dim.Division

BEGIN
	-- SET NOCOUNT ON added to prevent extra result sets from
	-- interfering with SELECT statements.
	SET NOCOUNT ON;
	SELECT 
		[DivisionSid]
		,[Sta3n]
		,[DivisionName]  
		,[Sta6a]
	FROM [CDWWork].[Dim].[Division]
	WHERE Sta6a=@sta6a
      
END;
GO

EXEC [dbo].[sp_SignAppObject] 'NVCC_usp_GetDivision'
GO


