﻿using System.ComponentModel;
using System.ComponentModel.DataAnnotations;
using System.Web.ModelBinding;

namespace NVCC.WebUI.Models
{
    public class StationInfoViewModel
    {
        [DisplayName("Medical Center Name")]
        [StringLength(60, ErrorMessage = "Name cannot be longer than 60 characters")]
        public string MedCtr { get; set; }

        [DisplayName("Medical Center Address")]
        [StringLength(130, ErrorMessage = "Address cannot be longer than 130 characters")]
        public string FullAddress { get; set; }

        [DisplayName("Contact Phone Number")]
        [StringLength(50, ErrorMessage = "Phone cannot be longer than 50 characters")]
        public string FacilityPhoneNumber { get; set; }

        [DisplayName("Send Results to Fax Number")]
        [StringLength(50, ErrorMessage = "Fax cannot be longer than 50 characters")]
        public string FacilityFaxNumber { get; set; }

        [DisplayName("Station")]
        public short sta3n { get; set; }

        [BindNever]
        public bool Admin { get; set; }
    }
}