﻿using System;
using NVCC.Models;

namespace NVCC.WebUI.Models
{
    [Serializable]
    public class ConsultViewModel
    {
        public ConsultViewModel()
        {
            
        }

        public ConsultViewModel(UspConsult consult)
        {
            if (consult == null)
                throw new NullReferenceException("mdwsConsult");
            Consult = consult;
            this.ConsultText = Consult.ConsultReason;
            Urgency = consult.Urgency;
            ClinicallyIndicatedDate = GetDateOnly(Consult.EarliestDate);
            ConsultDate = GetDateOnly(Consult.RequestDate);

        }
        public string ConsultDate { get; private set; }
        public UspConsult Consult { get; set; }
        public string Urgency { get; set; }
        public string ClinicallyIndicatedDate { get; set; }
        public string EligibilityDate { get; set; }
        public string ConsultText { get; set; }

        private string GetDateOnly(DateTime? consultDateTime)
        {
            if (consultDateTime==null)
                return null;
            var consultDate = consultDateTime.Value.ToShortDateString();
            return consultDate;
        }
    }
}