﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;

namespace NVCC.WebUI.Models
{
    public class AnnouncementItemViewModel
    {
        public string AnnouncementType { get; set; }
        private DateTime? startDT;
        public DateTime? StartDT
        {
            get
            {
                return startDT;
            }
            set
            {
                // the value that comes in _will_ be in UTC
                if (value != null)
                {
                    startDT = DateTime.SpecifyKind((DateTime)value, DateTimeKind.Utc);
                }
                else
                {
                    startDT = null;
                }
            }
        }
        private DateTime? expirationDT;
        public DateTime? ExpirationDT
        {
            get
            {
                return expirationDT;
            }
            set
            {
                // the value that comes in _will_ be in UTC
                if (value != null)
                {
                    expirationDT = DateTime.SpecifyKind((DateTime)value, DateTimeKind.Utc);
                }
                else
                {
                    expirationDT = null;
                }
            }
        }
        public string Text { get; set; }
    }
}