﻿using NVCC.Models;
using System;
using System.Collections.Generic;
using System.Linq;

namespace NVCC.WebUI.Infrastructure
{
    public static class FakeDataManager
    {
        public static IList<Medication> GetMedicationList()
        {
            var medList = new List<Medication> 
            { 
                new Medication 
                {
                MedicationId = 1, MedicationNameWithDose="TEST ATORVASTATIN CALCIUM 10MG TAB", IssueDate = new DateTime(2015, 12, 01), Quantity = "90", FillNumber=1, MaxRefills=4, FillDate = new DateTime(2015, 12, 01), RxStatus = "Refill Needed"
                }, 
                new Medication 
                {
                MedicationId = 2, MedicationNameWithDose="TEST TERAZOSIN HCL 2MG CAP", IssueDate = new DateTime(2015, 12, 10), Quantity = "30", FillNumber=2, MaxRefills=4 , FillDate = new DateTime(2016, 12, 01)
                }, 
                 new Medication 
                {
                MedicationId = 3, MedicationNameWithDose="TEST LOSARTAN POTASSIUM 100MG TAB", IssueDate = new DateTime(2015, 12, 15), Quantity = "60", FillNumber=3, MaxRefills=3 , FillDate = new DateTime(2016, 10, 01)
                }
            };

            return medList;
        }

        public static Division GetDivision()
        {
            var division = new Division
            {
                DivisionName = "AnyLocation",
                DivisionSid = 1,
                Sta6a = "999A",
                Sta3n = 999
            };
            return division;
        }

        public static IEnumerable<Division> GetDivisions()
        {
            var division = new List<Division>
            {
                new Division
                {
                    DivisionName = "AnyLocation",
                    DivisionSid = 1,
                    Sta6a = "999A",
                    Sta3n = 999
                }, 
                 new Division
                {
                    DivisionName = "AnotherLocation",
                    DivisionSid = 1,
                    Sta6a = "998A",
                    Sta3n = 998
                }
            };
          
            return division.AsEnumerable();
        }

        private static StationInfo _stationInfo = new StationInfo
            {
                FacilityFaxNumber = "555-555-5555",
                FacilityPhoneNumber = "666-666-6666",
                FullAddress = "123 Main Street Anwhere, AnyPlace USA 99999",
                MedCtr = "VA Anywhere Health System"
            };

        public static StationInfo GetStationInfo()
        {
            return _stationInfo;
        }

        public static void SetStationInfo(StationInfo stationInfo)
        {
            _stationInfo = stationInfo;
        }

        public static  List<Allergy> GetAllergies()
        {
            var allergyList = new List<Allergy> 
            { 
                new Allergy 
                {
                AllergyId = 1, AllergyTitle = "Cheese", OriginationDateTime = DateTime.Now, VerificationDateTime = new DateTime(2016, 01, 01)}, 
                new Allergy 
                {
                     AllergyId = 1, AllergyTitle = "Beer",  OriginationDateTime = DateTime.Now, VerificationDateTime = new DateTime(2015, 09, 01)}, 
                 new Allergy 
                {
                 AllergyId = 1, AllergyTitle = "Penicillin",  OriginationDateTime = DateTime.Now, VerificationDateTime = new DateTime(2014, 10, 01)}
            };
            return allergyList;
        }

        public static IList<ProblemDiagnosis> GetProblemList()
        {
            var problemList = new List<ProblemDiagnosis> 
            { 
                new ProblemDiagnosis 
                {
                ProblemDiagnosisId = 1, IcdCode = "704.01", Problem = "ALOPECIA AREATA (ICD9 704.01)"
                }, 
                new ProblemDiagnosis 
                {
                    ProblemDiagnosisId = 2, IcdCode = "555.5", Problem = "DIZZINESS AND GIDDINESS"
                }, 
                   new ProblemDiagnosis 
                {
                    ProblemDiagnosisId = 3, IcdCode = "999.99", Problem = "HIRSUTISM"
                }
            };
            return problemList;
        }

        public static IList<Appointment> GetAppointmentList()
        {
            var apptList = new List<Appointment> 
            { 
                new Appointment 
                {
                AppointmentId = 1, AppointmentDateTime = "01/01/2016", Location = "EKG OUTPT-4A103" 
                }, 
                new Appointment 
                {
                AppointmentId = 2, AppointmentDateTime = "02/01/2016", Location = "PRE OP-4C190" 
                }, 
                   new Appointment 
                {
                AppointmentId = 3, AppointmentDateTime = "03/01/2016", Location = "AMB SURG UROLOGY-X" 
                }
            };
            return apptList;
        }

        public static IList<Lab> GetLabList()
        {
            var labList = new List<Lab> 
            { 
                new Lab 
                {
                LabId = 1, LabTestName="Hgb", LabSpecimenDate = new DateTime(2015, 12, 01), LabResultValue="123", LabResultNumericValue = 123, Units = "Ng", RefLow = "150", RefHigh = "200", Abnormal = "Y"
                }, 
                new Lab 
                {
                LabId = 2, LabTestName="Hct", LabSpecimenDate = new DateTime(2015, 12, 01), LabResultValue="234", LabResultNumericValue = 234, Units = "Ml", RefLow = "200", RefHigh = "250", Abnormal = "N"
                }, 
                 new Lab 
                {
                LabId = 3, LabTestName="WBC", LabSpecimenDate = new DateTime(2015, 12, 01), LabResultValue="345", LabResultNumericValue = 345, Units = "ul", RefLow = "200", RefHigh = "350", Abnormal = "N"
                }
            };
            return labList;
        }

        public static Patient GetPatient()
        {
            var patient = new Patient
                {
                    PatientName = "FAKEPATIENT, SAM",
                    PatientSsn = "555555555",
                    DateOfBirth = new DateTime(1990, 12, 25),
                    PatientSid = 99,
                    Station = 999, 
                    PatientIcn = "999", 
                    PatientIen = "999", 
                    PhoneResidence = "123-456-7890", 
                    StreetAddress1 = "123 WhoVille Lane", 
                    City = "AnywhoVille", 
                    State="AnyState", 
                    Zip="12345"
                };
            return patient;
        }

        public static PatientProfile GetPatientProfile()
        {
            PatientProfile patientProfile = new PatientProfile();
            patientProfile.Appointments = GetAppointmentList();
            patientProfile.Labs = GetLabList();
            patientProfile.Medications = GetMedicationList();
            patientProfile.ProblemDiagnoses = GetProblemList();
            patientProfile.Patient = GetPatient();
            patientProfile.VistaUser = GetViaUser(true);
            patientProfile.Authorizations = GetAuthorizations();
            patientProfile.Consults = GetConsults();
            patientProfile.Allergies = GetAllergies();
            patientProfile.RadiologyReports = GetRadiologyReports();
            patientProfile.NonVaMedications = GetNonVaMedications();
            patientProfile.NextOfKin = GetNextOfKin();
            patientProfile.Notes = GetNotes();

            return patientProfile;
        }

        public static NextOfKin GetNextOfKin()
        {
            return new NextOfKin()
            {
                NextOfKinId = 0,
                PatientSid = 99,
                Station = 999,
                AddressType = "NOK",
                NameOfContact = "FAKEPATIENT, JANE",
                StreetAddress1 = "123 WhoVille Lane",
                City = "AnywhoVille",
                State = "AnyState",
                Zip = "12345",
                Phone = "123-456-7890",
                PhoneWork = "321-654-0987"
            };
        }

        public static IList<NonVaMedication> GetNonVaMedications()
        {
            var nonVaMeds = new List<NonVaMedication>
            {
                new NonVaMedication
                {
                    LocalDrugNameWithDose = "Penicillin: 5MG",
                    MedicationRoute = "Orally twice daily",
                    NonVaMedicationId = 1,
                    PatientSid = 99,
                    Schedule = "Orally for 30 days",
                    Station = 999,
                    StationName = "Anywhere"
                }
            };
            return nonVaMeds.ToList();
        }
        public static IList<UspConsult> GetConsults()
        {
            var consultList = new List<UspConsult> 
            { 
                new UspConsult 
                {
                    Consultsid = 1, ConsultReason = "some reason", ToRequestServiceName = "Request Service 1", RequestDate = DateTime.Parse("2016-10-01"), EarliestDate = DateTime.Parse("2015-01-01"), CPRSStatus = "ACTIVE", Urgency = "STAT"
                }, 
                new UspConsult 
                {
                 Consultsid = 2, ConsultReason = "some reason 2", ToRequestServiceName = "Request Service 2",  RequestDate = DateTime.Parse("2016-09-01"), EarliestDate = DateTime.Parse("2015-01-01"), CPRSStatus = "ACTIVE"
                }
            };
            return consultList;
        }

        public static IList<Authorization> GetAuthorizations()
        {
            var authList = new List<Authorization> 
            { 
                new Authorization 
                {
                    AuthorizationId = "1", AuthorizationTitle  = "VHA CHOICE Approval", AuthorizationText = " LOCAL TITLE: VCP-CHOICE PROV AGRMT VAF 10-0386A                 \nSTANDARD TITLE: NONVA NOTE                                      \nDATE OF NOTE: AUG 25, 2016@15:26     ENTRY DATE: AUG 25, 2016@15:26:24      \n      AUTHOR: DIGGS,BRIAN S        EXP COSIGNER:                           \n     URGENCY:                            STATUS: COMPLETED                     \n\nREFERRAL INFORMATION\n                      Department of Veterans Affairs \n             VETERANS CHOICE PROVIDER AGREEMENT AUTHORIZATION\n                            VA-FORM 10-0386a\n\nReason for Use of Provider Agreement:Veteran Declined Appointment Time\n\nCommunity Provider Name(s):\n  Bob\n\nAuthorization Number: xxx\n\nVA Ordering Provider: Me \n\nPlease select referral urgency: \nRoutine\n\nTo facilitate Urgent scheduling, please include an alternate point \nof contact's (different than the NVCC staff member listed below) name,\ntelephone number, and relationship to the patient (social worker, triage nurse, \netc.) in space provided. \n\n\nSecondary Authorization Request(SAR):\n\n \n\nServices and Timeframe Authorized:\n\nSpecialty: \n\n  Cartography\n\nType of Specialist:\n\n  Surveyer\n\nType of Service/Procedure:\n\n  Elevation Map\n\nNumber of Visits, Frequency and Duration: \n\n  As needed\n\n\nDate VA Requests services under Provider Agreement:\nAug 29,2016@06:00\n\n\n\n\n\nVeteran Information:\nName: ZZTEST,CENDY\nDOB: JAN 5,1954\nSSN: 000-00-0014\nAddress: 1750 BLANKENSHIP RD\nPORTLAND, OR  97233\nPhone: 3602705995\n\n \n\n\n\n(include name, address and phone if known)\n\n\nEligiblity Type(From initial authorization if applicable):\nChoice Unusual/Excessive Burden (UEXB)\n\nEligibility Verification: \nAs the authorized VA representative, I hereby confirm that the Veteran is \neligible for Choice services. The Veteran's basic eligibility was verified\nin the Veterans Choice Viewer application (VA Viewer) on: \n08/25/2016\n\nVeteran Other Health Insurance (OHI):\n\n  Does Veteran have billable OHI?:\n\n   Yes - Veteran has billable OHI\n\n   Couch cushions\n\nService-Connected(SC) and/or Special Authority(SA):\n   No - Veteran does not have SC/SA eligiblity - OHI Primary Payer\n \n\nVA Community Care Manager or equivalent:\n\nName: X\n\nTitle: X\n\nVA Issuing Office:\nVA Community Care Contact #: X\nAfter Hours POC #: X\n\nContact local VA Community Care Office first to provide information to VA or \nreach VA ordering provider. All contact from Community Care Provider will be \ndocumented in the Veteran's Record by VA Community Care staff and VA Ordering \nProvider notified for awareness. Report all CRITICAL FINDINGS related to this \nauthorization to the VA Community Care Office above.\n\nFrom Station #: X\nFacility Name: X\nStreet Address: X\nCity: X\nState: X\nZip: X\nFax: X\n \n/es/ Brian S Diggs, PhD\nProgram Analyst\nSigned: 08/25/2016 15:29"
                }
            };
            return authList;
        }

        public static IList<RadiologyReport> GetRadiologyReports()
        {
            var radList = new List<RadiologyReport> 
            { 
                new RadiologyReport 
                {
                    RadiologyReportId = "1", ReasonForStudy = "Some reason", ImpressionText = "Some Impression 1",ProcedureName="CHEST CT", ExamDateTime = DateTime.Now, ExamDate = "20161001.120100", ReportText = "FOOT, RIGHT, 2 VIEWS\n   \nExm Date: SEP 29, 2016@10:38\nReq Phys: AMII,JAMES M                   Pat Loc: LIVER/KIDNEY FACILITATORS-X (R\n                                         Img Loc: PDX-RAY-X\n                                         Service: Unknown\n\n \n\n(Case 1850 COMPLETE) FOOT, RIGHT, 2 VIEWS             (RAD  Detailed) CPT:73620\n     Reason for Study: TEST\n\n    Clinical History:\n      MODALITY TEST \n\n    Report Status: Verified                   Date Reported: \n                                              Date Verified: OCT 04, 2016\n    Verifier E-Sig:\n\n    Report:\n\n    Impression:\n      Test patient; no report necessary for dictation; ADMIN complete.  \n\n    Primary Diagnostic Code: \n\nPrimary Interpreting Staff:\n  DIANA JOYCE ARTENIAN MD, STAFF RADIOLOGIST\n          Verified by transcriptionist for DIANA JOYCE ARTENIAN MD\n/JDA\n\n   \n"
                }, 
                new RadiologyReport 
                {
                    RadiologyReportId = "1", ReasonForStudy = "Some reason", ImpressionText = "Some Impression 2" , ProcedureName="CT NECK SOFT TISSUE W/CONTRAST", ExamDateTime = DateTime.Now, ExamDate = "20160901.120200" , ReportText="FOOT, RIGHT, 2 VIEWS\n   \nExm Date: SEP 29, 2016@10:38\nReq Phys: AMII,JAMES M                   Pat Loc: LIVER/KIDNEY FACILITATORS-X (R\n                                         Img Loc: PDX-RAY-X\n                                         Service: Unknown\n\n \n\n(Case 1850 COMPLETE) FOOT, RIGHT, 2 VIEWS             (RAD  Detailed) CPT:73620\n     Reason for Study: TEST\n\n    Clinical History:\n      MODALITY TEST \n\n    Report Status: Verified                   Date Reported: \n                                              Date Verified: OCT 04, 2016\n    Verifier E-Sig:\n\n    Report:\n\n    Impression:\n      Test patient; no report necessary for dictation; ADMIN complete.  \n\n    Primary Diagnostic Code: \n\nPrimary Interpreting Staff:\n  DIANA JOYCE ARTENIAN MD, STAFF RADIOLOGIST\n          Verified by transcriptionist for DIANA JOYCE ARTENIAN MD\n/JDA\n\n   \n"
                }
            };
            return radList;
        }

        public static ViaUser GetViaUser(bool? viaBApproved = false, string faultMessage=null)
        {
            var viaUser = new ViaUser {QueryBean = new ViaQueryBean()};
            viaUser.ViaBApproved = viaBApproved;
            if (faultMessage != null)
            {
                viaUser.Fault = true;
                viaUser.FaultMessage = faultMessage;
            }
            viaUser.Divisions = new Division[] { GetDivision() };
            return viaUser;
        }

        private static IList<UspAnnouncement> _announcements = new List<UspAnnouncement>
            {
                new UspAnnouncement
                {
                    AnnouncementID = 1,
                    AnnouncementType = "Alert",
                    CreationDT = new DateTime(2016, 06, 08, 17, 00, 00),
                    ExpirationDT = new DateTime(2016, 06, 08, 17, 55, 00),
                    Creator = "Admin",
                    Text =
                        "Due to a reboot of the database server, CITCoM will be unavailable starting at 8pm Eastern/5pm Pacific tonight (6/8/16). It is anticipated that the database server will be unavailable for about half an hour."
                }
            };

        public static IList<UspAnnouncement> GetAnnouncements(int active)
        {
            if (active == 0)
            {
                return _announcements;
            }
            else
            {
                return _announcements.Where(a => a.CreationDT < DateTime.UtcNow && a.ExpirationDT > DateTime.UtcNow).ToList();
            }
        }

        public static void AddAnnouncement(UspAnnouncement announcement)
        {
            var nextAnnouncementID = _announcements.Select(a => a.AnnouncementID).Max() + 1;
            announcement.AnnouncementID = nextAnnouncementID;
            _announcements.Add(announcement);
        }

        public static IList<Note> GetNotes()
        {
            return new List<Note>
            {
                new Note
                {
                    NoteAuthor = "ANGELA M FLINGOS",
                    NoteID = "49926122",
                    NoteText = " LOCAL TITLE: INFORMED CONSENT                                   \nSTANDARD TITLE: CONSENT                                         \nDATE OF NOTE: JUN 20, 2017@10:08:23  ENTRY DATE: JUN 20, 2017@10:09:43      \n      AUTHOR: FLINGOS,ANGELA M     EXP COSIGNER:                           \n     URGENCY:                            STATUS: COMPLETED                     \n\n  Signature Informed Consent for  \n   CERVIX - BIOPSY ENDOCERVICAL (BIOPSY OF  ENDOCERVIX (TISSUE INSIDE \nCERVIX)) \n1. Anatomical Location: jjgmbvm \n2. Informed consent was obtained  at 10:07 AM on June 20, 2017. \n\t\tThe full consent document can be accessed through Vista Imaging.\n3. Patient name:  ZZTEST, JIANJI S  \n4. The patient HAS decision-making capacity.    \n5. Surrogate (if applicable):        \n6. Reason for the treatment (diagnosis, condition, or indication): To \nremove and/or test abnormal tissue of the cervix. \n7. Treatment/procedure: This procedure involves taking a biopsy from \nyour cervix.   The cervix is  the lower, narrow end of the uterus that \nopens into the vagina.  A biopsy is the removal of a sample of tissue \nfor analysis.  Your doctor will take a sample from the tissue that \nlines the inside of your cervix.\nYour doctor may inject a medicine to numb your cervix.  You may also \nbe given a medicine to help you relax.  Your doctor will insert a \nspeculum.This is used to hold the vagina open.Your doctor will \nuse a tool to remove tissue from inside your cervix.You may feel a \npinching sensation or some cramping when your doctor takes the \nbiopsy.Your doctor will send the sample(s)to be tested. \n   \n\t\t \n    \n8.Neither anesthesia nor moderate sedation will be used.\n9.Consent to Blood Products(if applicable):\nIt is not expected that blood products will be used in this \ntreatment / procedure.  \n10.Practitioner obtaining consent: Zzzaatestphysician,Eighteen \n(PHYSICIAN) \n11.Supervising practitioner:  Abbey,Kenneth R (ANESTHESIOLOGIST) \n12.Practitioner(s) performing or supervising treatment / procedure(if \n not listed above):  Abbey,Kenneth R (ANESTHESIOLOGIST) \n13.Witness Name(s):                    \n \n14.Comments:\n \n \t \n \n   \n  \n  \n  \n  \n   \n \n \n*** SCANNED DOCUMENT * **\n SIGNATURE NOT REQUIRED\n \n \n Electronically Filed: 06 / 20 / 2017\n by: ACCOUNT IMEDUSER\n                        ",
                    NoteTimestamp = new DateTime(2017, 6, 20, 10, 08, 00),
                    NoteTitle = "INFORMED CONSENT"
                },
                new Note
                {
                    NoteAuthor = "Walter P. Goebel MD",
                    NoteID = "50111787",
                    NoteText = " LOCAL TITLE: PC - FOLLOW UP                                     \nSTANDARD TITLE: PRIMARY CARE OUTPATIENT NOTE                    \nDATE OF NOTE: JUL 05, 2017@13:09     ENTRY DATE: JUL 05, 2017@13:09:45      \n      AUTHOR: GOEBEL,WALTER PAUL   EXP COSIGNER:                           \n     URGENCY:                            STATUS: COMPLETED                     \n\nPlanned Procedure: Battlefield Acupuncture\n\nPAIN DIAGNOSIS: chronic pain \n \n Pre-procedure pain assessment(DVCIPM): 9 \n Post- procedure pain assessment(DVCIPM): 2\n\nPain Interference Assessment\n 1. What number describes how, during the past 24 hours, pain has interfered \n    with your usual ACTIVITY: 9\n 2. What number describes how, during the past 24 hours, pain has interfered \nwith \n    your SLEEP: 9\n 3. What number describes how, during the past 24 hours, pain has affected your \n    MOOD: 9\n 4. What number describes how, during the past 24 hours, pain has contributed to \n    your STRESS: 9\n\nInformed Consent:\n The procedure was discussed with patient. \n The risks and benefits were explained and questions were answered.\n An informed consent was obtained.\n\nPreparation:\n The patient was in the sitting position.Providers hands were cleaned. Both \n patients'ears were wiped clean with alcohol prior to needle placement. \n Time out checklist was completed before the beginning of the procedure.\n\nProcedure: \n Using gold ASP needles, the needles were placed in the order of the acronym \n CTOPS, alternating ears with each point placement. After each point placement, \n the patient was asked to move or ambulate and the pain score was reassessed.\n The points used are: Cingulate Gyrus, Thalamus, Omega 2, Point Zero, Shen Men. \n A total of 5 needles were used for the Right ear.\n A total of 5 needles were used for the Left ear.\n It was necessary to readjust 0 needle(s) for the Right ear.\n It was necessary to readjust 0 needle(s) for the Left ear.\n\nPost Procedure: \nThe patient tolerated the procedure well and there were no noted problems.\n\nI spent a total 15 min providing one on one acupuncture with one or more \nneedles without electrical stimulation.\n\n \n \n/es/ Walter P. Goebel MD\nPhysician\nSigned: 07/05/2017 13:11",
                    NoteTimestamp = new DateTime(2017, 7, 5, 13, 9, 0),
                    NoteTitle = "PC - FOLLOW UP"
                },
                new Note
                {
                    NoteAuthor = "Laurie A. Beauchamp",
                    NoteID = "49182954",
                    NoteText = " LOCAL TITLE: PC - FOLLOW UP                                     \nSTANDARD TITLE: PRIMARY CARE OUTPATIENT NOTE                    \nDATE OF NOTE: APR 25, 2017@09:14     ENTRY DATE: APR 25, 2017@09:15:09      \n      AUTHOR: BEAUCHAMP,LAURIE A   EXP COSIGNER:                           \n     URGENCY:                            STATUS: COMPLETED                     \n\nasdfasfadsf\n \n/es/ Laurie A. Beauchamp\nCHIEF HEALTH INFORMATION MANAGEMENT\nSigned: 04/25/2017 09:17",
                    NoteTimestamp = new DateTime (2017, 4, 25, 9, 14, 0),
                    NoteTitle = "PC - FOLLOW UP"
                }
            };
        }

        // Users:
        // 0: Fred Flintstone, with ViaB and PHIPII and an active session
        // 1: Fred Flintstone with no facilities at all
        // 2: Fred Flintstone, with ViaB and PHIPII but no active session
        // 3: Fred Flintstone, without ViaB and with PHIPII and an active session
        // 4: Fred Flintstone, unknown ViaB, no PHIPII, no active session
        // 5: Fred Flintstone, with ViaB, PHIPII, an active session, admin at station, and announcing
        public static User GetUser(int i = 0)
        {
            return new User[]
            {
                new User()
                {
                    ApplicationUserID = 0,
                    DomainPlusNetworkUserName = "DNS\DNS  DNS",
                    Name = "Flintstone, Fred",
                    CurrentDefaultFacility = (short)888,
                    Facilities = new Dictionary<short, UserFacility>()
                    {
                        {
                            (short)888,
                            new UserFacility
                            {
                                sta3n = (short)888,
                                sta6a = "888",
                                StationName = "Bedrock",
                                LocationName = "BEDROCK",
                                LastAuthDateTime = DateTime.UtcNow,
                                ViaB = true,
                                PHIPII = true,
                                VIAToken = "XXXXX",
                                VIATokenExpiration = DateTime.UtcNow.AddHours(4),
                                Admin = false
                            }
                        }
                    }
                },
                new User()
                {
                    ApplicationUserID = 1,
                    DomainPlusNetworkUserName = "DNS\DNS  DNS",
                    Name = "Flintstone, Fred",
                    CurrentDefaultFacility = (short)0,
                    Facilities = new Dictionary<short, UserFacility>()
                },
                new User()
                {
                    ApplicationUserID = 2,
                    DomainPlusNetworkUserName = "DNS\\DNS   DNS",
                    Name = "Flintstone, Fred",
                    CurrentDefaultFacility = (short)888,
                    Facilities = new Dictionary<short, UserFacility>()
                    {
                        {
                            (short)888,
                            new UserFacility
                            {
                                sta3n = (short)888,
                                sta6a = "888",
                                StationName = "Bedrock",
                                LocationName = "BEDROCK",
                                LastAuthDateTime = DateTime.UtcNow.AddHours(-12),
                                ViaB = true,
                                PHIPII = true,
                                VIAToken = "XXXXX",
                                VIATokenExpiration = DateTime.UtcNow.AddHours(-8),
                                Admin = false
                            }
                        }
                    }
                },
                new User()
                { // what would viaB false look like?
                    ApplicationUserID = 3,
                    DomainPlusNetworkUserName = "DNS\\DNS   DNS",
                    Name = "Flintstone, Fred",
                    CurrentDefaultFacility = (short)888,
                    Facilities = new Dictionary<short, UserFacility>()
                    {
                        {
                            (short)888,
                            new UserFacility
                            {
                                sta3n = (short)888,
                                sta6a = "888",
                                StationName = "Bedrock",
                                LocationName = "BEDROCK",
                                LastAuthDateTime = DateTime.UtcNow,
                                ViaB = false,
                                PHIPII = true,
                                VIAToken = "XXXXX",
                                VIATokenExpiration = DateTime.UtcNow.AddHours(4),
                                Admin = false
                            }
                        }
                    }
                },
                new User()
                {
                    ApplicationUserID = 4,
                    DomainPlusNetworkUserName = "DNS\\DNS   DNS",
                    Name = "Flintstone, Fred",
                    CurrentDefaultFacility = (short)888,
                    Facilities = new Dictionary<short, UserFacility>()
                    {
                        {
                            (short)888,
                            new UserFacility
                            {
                                sta3n = (short)888,
                                sta6a = "888",
                                StationName = "Bedrock",
                                LocationName = "BEDROCK",
                                LastAuthDateTime = null,
                                ViaB = null,
                                PHIPII = false,
                                VIAToken = "",
                                VIATokenExpiration = null,
                                Admin = false
                            }
                        }
                    }
                },
                new User()
                {
                    ApplicationUserID = 5,
                    DomainPlusNetworkUserName = "DNS\DNS   DNS",
                    Name = "Flintstone, Fred",
                    CanCreateAnnouncement = true,
                    CurrentDefaultFacility = (short)888,
                    Facilities = new Dictionary<short, UserFacility>()
                    {
                        {
                            (short)888,
                            new UserFacility
                            {
                                sta3n = (short)888,
                                sta6a = "888",
                                StationName = "Bedrock",
                                LocationName = "BEDROCK",
                                LastAuthDateTime = DateTime.UtcNow,
                                ViaB = true,
                                PHIPII = true,
                                VIAToken = "XXXXX",
                                VIATokenExpiration = DateTime.UtcNow.AddHours(4),
                                Admin = true
                            }
                        }
                    }
                },

            }[i];
        }
    }
}