﻿using NVCC.Models;
using NVCC.WebUI.Infrastructure;
using NVCC.WebUI.Models;
using System;
using System.Web.Mvc;

namespace NVCC.WebUI.Controllers
{
    public class HelpController : Controller
    {
        private readonly IPatientRepository _patientRepository;
        private readonly IUserService _userService;
        public HelpController(IPatientRepository patientRepository,
                              IUserService userService)
        {
            _patientRepository = patientRepository;
            _userService = userService;
        }

        [HttpGet]
        [AllowAnonymous]
        public ActionResult Index()
        {
            return RedirectToAction("About");
        }

        [HttpGet]
        [AllowAnonymous]
        public ActionResult About()
        {
            return View();
        }

        [HttpGet]
        [NvccAuthorize]
        public ActionResult News()
        {
            return View();
        }

        [HttpGet]
        [AllowAnonymous]
        public ActionResult Feedback()
        {
            return View();
        }

        [HttpGet]
        [NvccAuthorizeOrAnnounce]
        public ActionResult Announcements()
        {
            User user = _userService.GetUser();
            ViewBag.authorized = user.CanCreateAnnouncement;

            return View();
        }

        [HttpPost]
        [NvccAuthorizeOrAnnounce]
        [ValidateAntiForgeryToken]
        public ActionResult Announcements([Bind(Include = "AnnouncementType, StartDT, ExpirationDT, Text")] AnnouncementItemViewModel announcementItemViewModel)
        {
            User user = _userService.GetUser();
            bool authorized = user.CanCreateAnnouncement;
            ViewBag.authorized = authorized;

            if (!authorized)
            {
                return View();
            }
            var announcementItem = new AnnouncementItem();
            // announcementItem.AnnouncementID will be determined by database
            announcementItem.AnnouncementID = 0;
            switch (announcementItemViewModel.AnnouncementType)
            {
                case "Alert":
                    announcementItem.AnnouncementTypeID = 1;
                    break;
                default:
                    announcementItem.AnnouncementTypeID = 0;
                    break;
            }
            announcementItem.Creator = user.DomainPlusNetworkUserName;
            announcementItem.CreationDT = announcementItemViewModel.StartDT ?? DateTime.UtcNow;
            announcementItem.ExpirationDT = announcementItemViewModel.ExpirationDT ?? DateTime.UtcNow;
            announcementItem.Text = announcementItemViewModel.Text;
            _patientRepository.WriteAnnouncement(announcementItem);
            return View();
        }

        [NvccAuthorizeOrAnnounce]
        public PartialViewResult PtAnnouncementTable()
        {
            return PartialView(_patientRepository.GetAnnouncements(0));
        }

        [AllowAnonymous]
        public PartialViewResult PtAnnouncementActive()
        {
            return PartialView(_patientRepository.GetAnnouncements(1));
        }

        [AllowAnonymous]
        public ActionResult PHIPII()
        {
            User user = _userService.GetUser();
            ViewBag.none = ((user == null) || (user.Facilities == null) || (user.Facilities.Count == 0));
            return View();
        }

        [AllowAnonymous]
        public ActionResult ViaB()
        {
            User user = _userService.GetUser();
            if ((user == null) || (user.Facilities == null) || !user.Facilities.ContainsKey(user.CurrentDefaultFacility))
            {
                ViewBag.not = null;
            }
            else
            {
                ViewBag.not = (user.Facilities[user.CurrentDefaultFacility].ViaB);
            }
            return View();
        }

    }
}
