﻿using System.Web;
using System.Web.Optimization;
using AspNetBundling;

namespace NVCC.WebUI
{
    public class BundleConfig
    {
        // For more information on bundling, visit http://go.microsoft.com/fwlink/?LinkId=301862
        public static void RegisterBundles(BundleCollection bundles)
        {
            bundles.Add(new ScriptBundle("~/bundles/jquery").Include(
                        "~/Scripts/jquery-{version}.js", 
                        "~/Scripts/spin.js",
                        "~/Scripts/Spinner.js",
                        "~/Scripts/jquery.datetimepicker.js",
                        "~/Scripts/moment.js"));

            bundles.Add(new ScriptBundle("~/bundles/jqueryval").Include(
                        "~/Scripts/jquery.validate*"));

            bundles.Add(new ScriptBundle("~/bundles/jquerydatatable")
                .Include("~/Scripts/DataTables/jquery.dataTables.js")
                .Include("~/Scripts/DataTables/dataTables.responsive.js")
                .Include("~/Scripts/DataTablesLocal.js"));
            bundles.Add(new StyleBundle("~/bundles/jquerydatatablecss")
                .Include("~/Content/DataTables/css/jquery.dataTables.min.css", new CssRewriteUrlTransformFixed())
                .Include("~/Content/DataTables/css/responsive.dataTables.min.css", new CssRewriteUrlTransformFixed()));

            // Use the development version of Modernizr to develop with and learn from. Then, when you're
            // ready for production, use the build tool at http://modernizr.com to pick only the tests you need.
            bundles.Add(new ScriptBundle("~/bundles/modernizr").Include(
                        "~/Scripts/modernizr-*"));

            bundles.Add(new ScriptBundle("~/bundles/wds").Include(
                      "~/Content/wds-v0.8.2/js/components.js",
                      "~/Scripts/local.js"));

            bundles.Add(new StyleBundle("~/Content/css")
                .Include("~/Content/wds-v0.8.2/css/normalize.min.css")
                .Include("~/Content/wds-v0.8.2/css/google-fonts.css", new CssRewriteUrlTransformFixed())
                .Include("~/Content/wds-v0.8.2/css/styleguide.min.css", new CssRewriteUrlTransformFixed())
                .Include("~/Content/jquery.datetimepicker.css")
                .Include("~/Content/Site.css"));

            BundleTable.EnableOptimizations = true;
        }
    }
}
