﻿using Moq;
using NUnit.Framework;
using NVCC.WebUI.Infrastructure;
using System;
using System.Collections.Specialized;
using System.Web;
using System.Web.Routing;

namespace NVCC.WebUI.Tests
{
    [TestFixture]
    public class UserSessionManagerTests
    {       
        [Test]
        public void UserSessionManager_GetUserProfileReturnsProfile()
        {
            HttpContextManager.SetCurrentContext(GetMockedHttpContext());
                
            var sut = new UserSessionManager();
            var actual = sut.UserProfile;
            Assert.IsNotNull(actual);
        }

        private HttpContextBase GetMockedHttpContext()
        {
            var context = new Mock<HttpContextBase>();
            var request = new Mock<HttpRequestBase>();
            var session = new Mock<HttpSessionStateBase>();
       
            var requestContext = new Mock<RequestContext>();
            session.SetupGet(s => s["VaUserProfile"]).Returns(FakeDataManager.GetUser());
            context.Setup(ctx => ctx.Session).Returns(session.Object);

            requestContext.Setup(x => x.HttpContext).Returns(context.Object);
            context.Setup(ctx => ctx.Request).Returns(request.Object);
            context.Setup(ctx => ctx.Session).Returns(session.Object);
            request.Setup(req => req.Url).Returns(new Uri("http://www.google.com"));
            request.Setup(req => req.RequestContext).Returns(requestContext.Object);
            requestContext.Setup(x => x.RouteData).Returns(new RouteData());
            request.SetupGet(req => req.Headers).Returns(new NameValueCollection());

            return context.Object;
        }
    }
}
