﻿using Moq;
using NUnit.Framework;
using NVCC.WebUI.Infrastructure;
using System.Web;
using System.Web.Mvc;
using FluentAssertions;

namespace NVCC.WebUI.Tests
{
    [TestFixture]
    public class NvccAuthorizeAttributeTests
    {
        private AuthorizeAttribute attribute;
        private AuthorizationContext _authorizationContext;
        [SetUp]
        public void Test_Setup()
        {
            attribute = new NvccAuthorizeAttribute();
            var controller = new FakeController();
            MvcTest.SetupControllerContext(controller);

            _authorizationContext = new AuthorizationContext();
            _authorizationContext.Controller = controller;
            _authorizationContext.HttpContext = controller.HttpContext;
            var controllerDescriptor = new ReflectedControllerDescriptor(typeof(FakeController));
            var method = typeof(FakeController).GetMethod("Nothing");
            _authorizationContext.ActionDescriptor = new ReflectedActionDescriptor(method, "Nothing", controllerDescriptor);
        }
        [Test]
        [Ignore("Null Reference exception preventing test from running")]
        public void Fails_when_user_is_not_authenticated()
        {
             SetupSession(false); 
             Authorize(); 
             AssertUnauthorized(); 
        }

        private void AssertUnauthorized()
        {
            _authorizationContext.Result.Should().BeOfType<HttpUnauthorizedResult>();
        }

        private void Authorize()
        {
            attribute.OnAuthorization(_authorizationContext);
        }


        private void SetupSession(bool isAuthorized = true)
        {
            var mockContext = Mock.Get(_authorizationContext.HttpContext);
            var mockSession = new Mock<HttpSessionStateBase>();
            mockSession.SetupGet(x => x["IsAuthenticated"]).Returns(isAuthorized);

            // Return the mock.
            mockContext.SetupGet(x => x.Session).Returns(mockSession.Object);
        }


        internal class FakeController : Controller
        {
            public ActionResult Nothing()
            {
                return new EmptyResult();
            }
        }
    }
}
