﻿using Moq;
using NUnit.Framework;
using NVCC.WebUI.Controllers;
using NVCC.WebUI.Infrastructure;
using NVCC.WebUI.Models;
using System.Web.Mvc;

namespace NVCC.WebUI.Tests.Controllers
{
    [TestFixture]
    public class UserControllerTests
    {
        private Mock<IUserService> _userServiceMock;
        private UserController _controller;

        [SetUp]
        public void TestSetUp()
        {
            _userServiceMock = new Mock<IUserService>();

            _controller = new UserController(_userServiceMock.Object);
        }

        [Test]
        public void _UserInfo_ValidUser_ReturnsPartialViewUserInfoViewModel()
        {
            // Arrange
            _userServiceMock.Setup(m => m.GetUser()).Returns(FakeDataManager.GetUser(0));
            // Act
            var result = _controller._UserInfo();
            // Assert
            Assert.IsNotNull(result);
            Assert.IsInstanceOf(typeof(PartialViewResult), result);
            Assert.IsInstanceOf(typeof(UserInfoViewModel), ((PartialViewResult)result).ViewData.Model);
            Assert.AreEqual("DNS\\DNS   DNS",((UserInfoViewModel)((PartialViewResult)result).ViewData.Model).User.DomainPlusNetworkUserName);
            Assert.AreEqual("Flintstone, Fred", ((UserInfoViewModel)((PartialViewResult)result).ViewData.Model).User.Name);
        }

        [Test]
        public void LoginPost_UserNameNull_ReturnsLoginViewModel()
        {
            // Arrange
            _userServiceMock.Setup(m => m.GetUser()).Returns(FakeDataManager.GetUser(0));
            LoginViewModel viewModel = new LoginViewModel();
            // Act
            var result = _controller.Login(viewModel);
            // Assert
            Assert.IsNotNull(result);
            Assert.IsInstanceOf(typeof(ViewResult), result);
            Assert.IsInstanceOf(typeof(LoginViewModel), ((ViewResult)result).ViewData.Model);
            Assert.IsFalse(string.IsNullOrEmpty(((ViewResult)result).ViewBag.ErrorMessage));
        }

        [Test]
        public void LoginPost_VistaUserFaultDivisionNotSupported_RedirectsToLogin()
        {
            // Arrange
            _userServiceMock.Setup(m => m.GetUser()).Returns(FakeDataManager.GetUser(0));
            _userServiceMock.Setup(m => m.GetViaUser(It.IsAny<string>(), It.IsAny<string>(), It.IsAny<string>(), It.IsAny<short>()))
                          .Returns(FakeDataManager.GetViaUser(viaBApproved: true, faultMessage:"Division is not supported"));
            LoginViewModel viewModel = new LoginViewModel{UserName = "fredflinstone", Password = "xxx", sta3n = (short)888};
            // Act
            var result = _controller.Login(viewModel);
            // Assert
            Assert.IsNotNull(result);
            Assert.IsInstanceOf(typeof(RedirectToRouteResult), result);
            Assert.AreEqual("Division", ((RedirectToRouteResult)result).RouteValues["action"].ToString());
            Assert.AreEqual("User", ((RedirectToRouteResult)result).RouteValues["controller"].ToString());
        }
    }
}
