﻿using NVCC.Models;
using System;
using System.Collections.Generic;
using System.Data.SqlClient;
using System.Linq;

namespace NVCC.Repos.PatientRepository
{
    public class PatientRepository : IPatientRepository
    {
        private readonly NwicPanelMgmtModel _context;

        public PatientRepository(NwicPanelMgmtModel context)
        {
            _context = context;
        }

        public Patient GetPatient(int? patientSid)
        {
            try
            {
                var patient = _context.Database.SqlQuery<Patient>(
                 "EXEC App.NVCC_usp_GetPatientBySid @pid", new SqlParameter("pid", patientSid));
    
                return patient!=null ? patient.FirstOrDefault(): null;
            }
            catch (SqlException ex)
            {
                if (ex.Message.Contains("Timeout"))
                {
                    var ex2 = new PatientTimeoutException("Db Stored Procedure: PATIENT PatientSID ", ex);
                    Elmah.ErrorSignal.FromCurrentContext().Raise(ex2);
                    throw new PatientTimeoutException("Db Stored Procedure: PATIENT PatientSID ");
                }
                else
                {
                    Elmah.ErrorSignal.FromCurrentContext().Raise(ex);
                    throw;
                }
            }
            catch (Exception ex)
            {
                Elmah.ErrorSignal.FromCurrentContext().Raise(ex);
                throw;
            }
        }

        public NextOfKin GetNextOfKin(int patientSid)
        {
            try
            {
                var nextOfKin = _context.Database.SqlQuery<NextOfKin>(
                 "EXEC App.NVCC_usp_GetNextOfKin @pid", new SqlParameter("pid", patientSid));

                return nextOfKin != null ? nextOfKin.FirstOrDefault() : null;
            }
            catch (SqlException ex)
            {
                if (ex.Message.Contains("Timeout"))
                {
                    var ex2 = new PatientTimeoutException("Db Stored Procedure: NextOfKin", ex);
                    Elmah.ErrorSignal.FromCurrentContext().Raise(ex2);
                    throw new PatientTimeoutException("Db Stored Procedure: NextOfKin");
                }
                else
                {
                    Elmah.ErrorSignal.FromCurrentContext().Raise(ex);
                    throw;
                }
            }
            catch (Exception ex)
            {
                Elmah.ErrorSignal.FromCurrentContext().Raise(ex);
                throw;
            }
        }

        public Patient GetPatient(string patientSsn, short sta3n)
        {
            try
            {
                Patient patient = null;
                var ssnToSid = _context.Database.SqlQuery<SsnToSid>(
                    "EXEC App.NVCC_usp_GetPatientBySSN @SSN, @sta3n", new SqlParameter("SSN", patientSsn), new SqlParameter("sta3n", sta3n)).ToList();
                if (ssnToSid != null && ssnToSid.Count() > 0 && ssnToSid.First().PatientSid != null)
                    patient = GetPatient(ssnToSid.First().PatientSid);
                return patient;
            }
            catch (SqlException ex)
            {
                if (ex.Message.Contains("Timeout"))
                {
                    var ex2 = new PatientTimeoutException("Db Stored Procedure: PATIENT PatientSID ", ex);
                    Elmah.ErrorSignal.FromCurrentContext().Raise(ex2);
                    throw new PatientTimeoutException("Db Stored Procedure: PATIENT PatientSID ");
                }
                else
                {
                    Elmah.ErrorSignal.FromCurrentContext().Raise(ex);
                    throw;
                }
            }
            catch (Exception ex)
            {
                Elmah.ErrorSignal.FromCurrentContext().Raise(ex);
                throw;
            }
        }

        public IEnumerable<Patient> GetPatients(string patientSsn)
        {
            throw new NotImplementedException();
        }

        public IList<ProblemDiagnosis> GetProblemList(int patientSid)
        {
            try
            {
            var thePatientSid = (long)patientSid;
            var problemList = _context.Database.SqlQuery<UspProblemDiagnosis>(
                "EXEC App.NVCC_usp_GetProbs @pid", new SqlParameter("pid", thePatientSid));

                return problemList.Select(p => new ProblemDiagnosis
            {
                Problem = p.Problem, 
                IcdCode = p.ICDCode, 
                IcdVersion = p.ICDVersion, 
                Station = p.Sta3n, 
                StationName = p.StationName, 
                SensitiveDx = p.SensitiveDx, 
                AbuseDx = p.AbuseDx, 
                HivDx = p.HIVDx, 
                SickleDx = p.SickleDx        
            }).ToList();
        }
            catch (SqlException ex)
            {
                if (ex.Message.Contains("Timeout"))
                {
                    var ex2 = new PatientTimeoutException("Db Stored Procedure: ProblemList ", ex);
                    Elmah.ErrorSignal.FromCurrentContext().Raise(ex2);
                    throw new PatientTimeoutException("Db Stored Procedure: ProblemList");
                }
                else
                {
                    Elmah.ErrorSignal.FromCurrentContext().Raise(ex);
                    throw;
                }
            }
            catch (Exception ex)
            {
                Elmah.ErrorSignal.FromCurrentContext().Raise(ex);
                throw;
            }
        }


        public IList<Appointment> GetAppointments(int patientSid)
        {
            try
            {
            var thePatientSid = (long)patientSid;
            var appts = _context.Database.SqlQuery<UspAppointment>(
                "EXEC App.NVCC_usp_GetAppts @pid", new SqlParameter("pid", thePatientSid));
            var appointments = appts.Select(
                a => new Appointment
                {
                    AppointmentId = a.AppointmentSID, 
                    AppointmentDateTime = a.AppointmentDateTime, 
                    Location = a.LocationName, 
                    PatientSID = a.PatientSID, 
                    AppointmentTypeSID = a.AppointmentTypeSID, 
                    desireddate = a.desireddate, 
                    CancelNoShowCode = a.CancelNoShowCode, 
                    LocationSID = a.LocationSID, 
                    PurposeOfVisit = a.PurposeOfVisit, 
                        Station = a.Sta3n,
                    StationName = a.StationName, 
                    SchedulingRequestType = a.SchedulingRequestType, 
                        AppointmentCancelledFlag = a.AppointmentCancelledFlag

                });
            return appointments.ToList();
        }
            catch (SqlException ex)
            {
                if (ex.Message.Contains("Timeout"))
                {
                    var ex2 = new PatientTimeoutException("Db Stored Procedure: Appointment ", ex);
                    Elmah.ErrorSignal.FromCurrentContext().Raise(ex2);
                    throw new PatientTimeoutException("Db Stored Procedure: Appointment");
                }
                else
                {
                    Elmah.ErrorSignal.FromCurrentContext().Raise(ex);
                    throw;
                }
            }
            catch (Exception ex)
            {
                Elmah.ErrorSignal.FromCurrentContext().Raise(ex);
                throw;
            }
        }

        public IList<Medication> GetMedications(int patientSid)
        {
            try
            {
            var thePatientSid = (long)patientSid;
            var meds = _context.Database.SqlQuery<UspMedication>(
                "EXEC App.NVCC_usp_GetVAMeds @pid", new SqlParameter("pid", thePatientSid));

            var medications =
                meds.Select(
                    p =>
                new Medication 
                {
                            MedicationId = p.rxoutpatsid,
                            MedicationNameWithDose = p.localdrugnamewithdose,
                            IssueDate = p.issuedate,
                            Quantity = p.qty,
                            FillNumber = p.FillNumber,
                            MaxRefills = p.maxrefills, 
                            Signature = p.sig, 
                            FillDate = p.filldate, 
                            NextPossibleFillDate = p.nextpossiblefilldate, 
                            RxStatus = p.RxStatus, 
                            DaysSupply = p.dayssupply, 

                        });
                return medications.ToList();
            }
            catch (SqlException ex)
            {
                if (ex.Message.Contains("Timeout"))
                {
                    var ex2 = new PatientTimeoutException("Db Stored Procedure: Medications ", ex);
                    Elmah.ErrorSignal.FromCurrentContext().Raise(ex2);
                    throw new PatientTimeoutException("Db Stored Procedure: Medications");
                }
                else
                {
                    Elmah.ErrorSignal.FromCurrentContext().Raise(ex);
                    throw;
                }
            }
            catch (Exception ex)
            {
                Elmah.ErrorSignal.FromCurrentContext().Raise(ex);
                throw;
            }
        }


        public IList<NonVaMedication> GetNonVaMedications(int patientSid)
        {
            try
            {
            var thePatientSid = (long)patientSid;
            var nonVaMeds = _context.Database.SqlQuery<UspNonVaMedication>(
                "EXEC App.NVCC_usp_GetNVAMeds @pid", new SqlParameter("pid", thePatientSid));

            return nonVaMeds.Select(n => new NonVaMedication
            {
                NonVaMedicationId = n.NonVaMedSID, 
                LocalDrugNameWithDose = n.LocalDrugNameWithDose, 
                MedicationRoute = n.MedicationRoute, 
                Schedule = n.Schedule, 
                Station = n.Sta3n, 
                
            }).ToList();
        }
            catch (SqlException ex)
            {
                if (ex.Message.Contains("Timeout"))
                {
                    var ex2 = new PatientTimeoutException("Db Stored Procedure: Non Va Meds ", ex);
                    Elmah.ErrorSignal.FromCurrentContext().Raise(ex2);
                    throw new PatientTimeoutException("Db Stored Procedure: Non Va Meds");
                }
                else
                {
                    Elmah.ErrorSignal.FromCurrentContext().Raise(ex);
                    throw;
                }
            }
            catch (Exception ex)
            {
                Elmah.ErrorSignal.FromCurrentContext().Raise(ex);
                throw;
            }
        }

     
        public IList<Allergy> GetAllergies(int patientSid)
        {
            try
            {
            var thePatientSid = (long)patientSid;
            var allergies = _context.Database.SqlQuery<UspAllergy>(
                "EXEC App.NVCC_usp_GetAllergies @pid", new SqlParameter("pid", thePatientSid));

            return allergies.Select(
                    a => new Allergy
                {
                    AllergyId = a.AllergySID, 
                    AllergyTitle = a.allergy, 
                    PatientSid = a.PatientSID, 
                    Station = a.Sta3n, 
                    StationName = a.StationName, 
                    VerificationDateTime = a.VerificationDateTime, 
                    OriginationDateTime = a.OriginationDateTime                    
                }).ToList();
        }
            catch (SqlException ex)
            {
                if (ex.Message.Contains("Timeout"))
                {
                    var ex2 = new PatientTimeoutException("Db Stored Procedure: Allergies ", ex);
                    Elmah.ErrorSignal.FromCurrentContext().Raise(ex2);
                    throw new PatientTimeoutException("Db Stored Procedure: Allergies");
                }
                else
                {
                    Elmah.ErrorSignal.FromCurrentContext().Raise(ex);
                    throw;
                }
            }
            catch (Exception ex)
            {
                Elmah.ErrorSignal.FromCurrentContext().Raise(ex);
                throw;
            }
        }

        public IList<Lab> GetLabs(int patientSid)
        {
            try
            {
            var thePatientSid = (long)patientSid;
            var labs = _context.Database.SqlQuery<UspLab>(
                "EXEC App.NVCC_usp_GetLabs @pid", new SqlParameter("pid", thePatientSid));

                return labs.Select(l => new Lab
            {
                LabId = l.LabChemSID, 
                LabTestName = l.LabChemTestName, 
                LabSpecimenDate = l.LabChemSpecimenDateTime, 
                LabResultValue = l.LabChemResultValue, 
                LabResultNumericValue = l.LabChemResultNumericValue, 
                Units = l.units, 
                Abnormal = l.abnormal, 
                PatientSid = l.PatientSID, 
                Station = l.Sta3n, 
                StationName = l.StationName, 
                RefHigh = l.RefHigh, 
                RefLow = l.RefLow
            }).ToList();
        }
            catch (SqlException ex)
            {
                if (ex.Message.Contains("Timeout"))
                {
                    var ex2 = new PatientTimeoutException("Db Stored Procedure: Labs ", ex);
                    Elmah.ErrorSignal.FromCurrentContext().Raise(ex2);
                    throw new PatientTimeoutException("Db Stored Procedure: Labs");
                }
                else
                {
                    Elmah.ErrorSignal.FromCurrentContext().Raise(ex);
                    throw;
                }
            }
            catch (Exception ex)
            {
                Elmah.ErrorSignal.FromCurrentContext().Raise(ex);
                throw;
            }
        }

        public IList<UspConsult> GetConsults(int patientSid)
        {
            try
            {
                var thePatientSid = (long)patientSid;
                var labs = _context.Database.SqlQuery<UspConsult>(
                    "EXEC App.NVCC_usp_GetConsults @pid", new SqlParameter("pid", thePatientSid));

                return labs.ToList();
            }
            catch (SqlException ex)
            {
                if (ex.Message.Contains("Timeout"))
                {
                    var ex2 = new PatientTimeoutException("Db Stored Procedure: Consults ", ex);
                    Elmah.ErrorSignal.FromCurrentContext().Raise(ex2);
                    throw new PatientTimeoutException("Db Stored Procedure: Consults");
                }
                else
                {
                    Elmah.ErrorSignal.FromCurrentContext().Raise(ex);
                    throw;
                }
            }
            catch (Exception ex)
            {
                Elmah.ErrorSignal.FromCurrentContext().Raise(ex);
                throw;
            }
        }

        public void WriteLog(LogItem logItem)
        {
            _context.LogItems.Add(logItem);
            _context.SaveChanges();
        }

        public IList<UspUsageData> UsageData(string timeGroup, string statistic, string sta3n, string userID)
        {
            try
            {
                SqlParameter timeGroupParam;
                if (timeGroup != null) {
                    timeGroupParam = new SqlParameter("timegroup", timeGroup);
                }
                else
                {
                    timeGroupParam = new SqlParameter("timegroup", DBNull.Value);
                }
                SqlParameter statisticParam;
                if (statistic != null)
                {
                    statisticParam = new SqlParameter("statistic", statistic);
                }
                else
                {
                    statisticParam = new SqlParameter("statistic", DBNull.Value);
                }
                SqlParameter sta3nParam;
                if (sta3n != null && sta3n != "0")
                {
                    sta3nParam = new SqlParameter("sta3n", sta3n);
                }
                else
                {
                    sta3nParam = new SqlParameter("sta3n", DBNull.Value);
                }
                SqlParameter useridParam;
                if (userID != null && userID != "")
                {
                    useridParam = new SqlParameter("userID", userID);
                }
                else
                {
                    useridParam = new SqlParameter("userID", DBNull.Value);
                }

                var usage = _context.Database.SqlQuery<UspUsageData>(
                    "EXEC App.NVCC_usp_UsageData2 @timegroup, @statistic, @sta3n, @userID",
                    timeGroupParam, statisticParam, sta3nParam, useridParam).ToList();

                return usage;
            }
            catch (SqlException ex)
            {
                var ex2 = new PatientTimeoutException("Db Stored Procedure: USAGEDATA ", ex);
                Elmah.ErrorSignal.FromCurrentContext().Raise(ex2);
                throw;
            }
            catch (Exception ex)
            {
                Elmah.ErrorSignal.FromCurrentContext().Raise(ex);
                throw;
            }

        }

        public IList<UsageReportParametersUser> GetUsageParametersUser()
        {
            try
            {
                var users = _context.Database.SqlQuery<UsageReportParametersUser>("EXEC App.NVCC_usp_ProductionAccessLogUniqueUsers").ToList();
                return users;
            }
            catch (SqlException ex)
            {
                var ex2 = new PatientTimeoutException("Db Stored Procedure: USAGEPARAMUSER ", ex);
                Elmah.ErrorSignal.FromCurrentContext().Raise(ex2);
                throw;
            }
            catch (Exception ex)
            {
                Elmah.ErrorSignal.FromCurrentContext().Raise(ex);
                throw;
            }

        }

        public IList<UsageReportParametersSta3n> GetUsageParametersSta3n()
        {
            try
            {
                var sta3n = _context.Database.SqlQuery<UsageReportParametersSta3n>("EXEC App.NVCC_usp_ProductionAccessLogUniqueSta3n").ToList();
                return sta3n;
            }
            catch (SqlException ex)
            {
                var ex2 = new PatientTimeoutException("Db Stored Procedure: USAGEPARAMSTA3N ", ex);
                Elmah.ErrorSignal.FromCurrentContext().Raise(ex2);
                throw;
            }
            catch (Exception ex)
            {
                Elmah.ErrorSignal.FromCurrentContext().Raise(ex);
                throw;
            }

        }
        public IList<UspCurrentUsage> GetCurrentUsage(int timeframe) 
        {
            try
            {
                var usage = _context.Database.SqlQuery<UspCurrentUsage>(
                    "EXEC App.NVCC_usp_CurrentUsage @timeframe",
                    new SqlParameter("timeframe", timeframe)).ToList();

                return usage;
            }
            catch (SqlException ex)
            {
                var ex2 = new PatientTimeoutException("Db Stored Procedure: CURRENTUSAGE ", ex);
                Elmah.ErrorSignal.FromCurrentContext().Raise(ex2);
                throw;
            }
            catch (Exception ex)
            {
                Elmah.ErrorSignal.FromCurrentContext().Raise(ex);
                throw;
            }
        }
        public IList<UspAnnouncement> GetAnnouncements(int active)
        {
            try
            {
                var announcements = _context.Database.SqlQuery<UspAnnouncement>(
                    "EXEC App.NVCC_usp_GetAnnouncement @active",
                    new SqlParameter("active", active)).ToList();

                return announcements;
            }
            catch (SqlException ex)
            {
                var ex2 = new PatientTimeoutException("Db Stored Procedure: ANNOUNCEMENTS ", ex);
                Elmah.ErrorSignal.FromCurrentContext().Raise(ex2);
                throw;
            }
            catch (Exception ex)
            {
                Elmah.ErrorSignal.FromCurrentContext().Raise(ex);
                throw;
            }
        }
        public void WriteAnnouncement(AnnouncementItem announcementItem)
        {
            _context.AnnouncementItems.Add(announcementItem);
            _context.SaveChanges();
        }

        public IList<ActiveUserCount> GetActiveUserCount()
        {
            try
            {
                var counts = _context.Database.SqlQuery<ActiveUserCount>(
                    "SELECT * FROM App.NVCC_UDF_ActiveUserCount()").ToList();
                return counts;
            }
            catch (SqlException ex)
            {
                var ex2 = new PatientTimeoutException("Db user defined function: ActiveUserCount ", ex);
                Elmah.ErrorSignal.FromCurrentContext().Raise(ex2);
                throw;
            }
            catch (Exception ex)
            {
                Elmah.ErrorSignal.FromCurrentContext().Raise(ex);
                throw;
            }
        }

        public IList<UserCounts> GetUserCounts()
        {
            try
            {
                var counts = _context.Database.SqlQuery<UserCounts>(
                    "EXEC App.NVCC_usp_UserCounts").ToList();
                return counts;
            }
            catch (SqlException ex)
            {
                var ex2 = new PatientTimeoutException("Db user defined function: GetUserCounts ", ex);
                Elmah.ErrorSignal.FromCurrentContext().Raise(ex2);
                throw;
            }
            catch (Exception ex)
            {
                Elmah.ErrorSignal.FromCurrentContext().Raise(ex);
                throw;
            }

        }
        public IList<UspUniqueVeteran> GetUniqueVeterans()
        {
            try
            {
                var counts = _context.Database.SqlQuery<UspUniqueVeteran>(
                    "EXEC App.NVCC_usp_UniqueVeterans").ToList();
                return counts;
            }
            catch (SqlException ex)
            {
                var ex2 = new PatientTimeoutException("Db user defined function: Unique Veterans ", ex);
                Elmah.ErrorSignal.FromCurrentContext().Raise(ex2);
                throw;
            }
            catch (Exception ex)
            {
                Elmah.ErrorSignal.FromCurrentContext().Raise(ex);
                throw;
            }
        }
    
    }
}
