using System;
using System.Collections.Generic;
using System.Threading.Tasks;

namespace NVCC.Models
{
    public interface IMdwsRepository
    {
        CprsPerson LaunchCprs(string pwd, string sitecode, string duzUserIen, string dfnPatientIen);
        Task<CprsPerson> LaunchCprssAsync(string pwd, string sitecode, string duzUserIen, string dfnPatientIen);
        IList<Authorization> GetProgressNotes(DateTime fromDate, DateTime toDate, int numResults, string noteTitle);
        IList<RadiologyReport> GetRadiologyReports(DateTime fromDate, DateTime toDate, int numResults);
        Task<IList<RadiologyReport>> GetRadiologyReportsAsync(DateTime fromDate, DateTime toDate, int numResults);
        Task<IList<Authorization>> GetProgressNotesAsync(DateTime fromDate, DateTime toDate, int numResults, string vaChoiceNoteTitle);
        MdwsUser Login(string accessCode, string verifyCode);
        Patient GetPatient(string patientIen);
        IList<MdwsConsult> GetConsults();
        Task<IList<MdwsConsult>> GetConsultsAsync();
        string GetSite(string site);
        void Disconnect();

    }
}