﻿# Objects stored in the Session object and their keys

PatientICN (rendered as a string)
: A `NVCC.Models.PatientProfile` object corresponding to that patient.

The PatientSID (as a string) followed by a `-` and an 8 digit hexadecimal hash
: A `NVCC.WebUI.Models.PatientProfileViewModel`. This key is passed between various actions of the `PatientProfileController`. Getting and setting this object is typically done with the method `PatientProfileViewModel.cacheInSession()` and the static method `PatientProfileViewModel.retrieveFromSession(string ID)`. The key itself is returned by `PatientProfileViewModel.cacheInSession()`.

The PatientSID (as a string)
: A `NVCC.Models.Patient` object corresponding to that patient.

"userIen" (the literal string)
: The IEN of the user of the application, based on logging into VistA through VIA.

"ViaUser" (the literal string), followed by a `-`, followed by a sta3n code
: A `NVCC.Models.ViaUser` object corresponding to the logged in VistA user at the specified station.

"VaUserProfile" (the literal string)
: A `NVCC.Models.User`. Access to this is controlled through the `NVCC.WebUI.Infrastructure.UserSessionManager` object. This is a backing store for its `UserProfile` member.
