﻿




CREATE View [PanelMgmt].[vICD9] AS
--=============================================================================================================
--Region                : R01
--Visn					: V20
--Requestor				: NWIC
--Author                : Jerry Kohler
--Object/SP Name		: vICD9
--Server				: 
--Data Base				: CC_REFDOC
--Schema				: PanelMgmt
--Report				: Any Panel Management registry or report.
--Folder				:
--Report Loc            : 
--Job Loc               : None
--Note                  : THIS VIEW RETURNS THE CURRENT DESCRIPTION AND DIAGNOSTIC TEXT, NOT HISTORIC ONES
--                      : BASED ON A DATE.  This view is not supported by CDW, BISL or any OI&T group.
--                      :
--                      : These views only exist at District 5.  Any code using them cannot be shared beyond
--                        district 5.
--                      :
--Date Created          : 09-10-2015
--
--Last Changed          : 09-11-2015
--Last Changed By		: Jerry Kohler
--Reason For Change		: Added ICD9 Diagnosis
--
--Purpose               : To minimize the impact of future CDW changes to ICD-9/10
--=============================================================================================================
Select a.Sta3n,
       a.ICDIEN,
       a.ICD9SID,
       a.ICD9Code, 
       b.ICD9Description,
       c.ICD9Diagnosis AS ICD9DiagnosisText,
       CAST(9 AS SMALLINT) AS ICDVersion
from CDWWork.Dim.ICD9 a
join CDWWork.Dim.ICD9DescriptionVersion b on b.ICD9SID = a.ICD9SID
 and b.CurrentVersionFlag = 'Y'
join CDWWork.Dim.ICD9DiagnosisVersion c on c.ICD9SID = a.ICD9SID
 and c.CurrentVersionFlag = 'Y'
;




