CREATE VIEW App.vNVCC_Division

-- NOTICE:
-- Do not edit the view live on the server. Code to generate
-- the view is stored in the project repository. Any changes made
-- that are not recorded in the repository will be overwritten.

AS
--=================================================================================
--Requestor				: Non Va Coordinated Care Project
--Author                : Brian Diggs
--Object/SP Name		: vNVCC_Division
--SERVER				: 
--Data Base				: CC_REFDOC
--Schema				: App
--Report				: N/A
--Folder				: N/A
--Report Loc            : N/A
--Job                   : None
--Job Loc               : None
--Note                  : 
--Date Created          : 05-25-2017
--Last Changed          : 
--Last Changed By		: 
--Reason For Change		: 
--
--Purpose               : Create a restricted view of CDWWork.dim.Division for
--                        each Sta6a appears only once.
--=================================================================================
--
-- Goal: to get a list of valid sta6a's and their associated names, sta3n.
-- One entry per Sta6a
-- Only Sta6a's that are "real" and affiliated with a reasonable sta3n.
--
-- Primary source of data is CDWWork.Dim.Division
-- Secondary source is CDWWork.Dim.Institution
--
-- Don't want Sta6a's that are NULL, '*Missing*', '*Unknown at this time*', or 
-- any where the first three characters of the sta6a is not the corresponding sta3n.
-- This last criteria will cover all the previous ones as well.
--
-- This still leaves multiple entries for some sta6a.
-- Which entries are chosen is based on a scoring algorithm that was created by listing 
-- all the sta6a's that were multiples and, by hand, selecting the "best" one based on
-- the information in the record and the corresponding (LEFT JOINed) Institution record.
-- The score criteria that could be used to recreate the selection was:
-- If the name (CDWWork.Dim.Division.DivisionName) starts with 'ZZ', -100 points
-- If the CDWWork.Dim.Institution.StaPa is NULL, -50 points
-- If the CDWWork.Dim.Institution.InactiveFlag is anything but NULL, -20 points
--
-- The reason that these criteria are expressed as a score is so that for any sta6a,
-- there will always be some entry which is the "best", even if it is the only one. That
-- is, even if there is only one entry, it would be selected even if it met one of these
-- "bad" criteria.

SELECT
	OrderedSta6a.DivisionSID,
	OrderedSta6a.Sta3n,
	OrderedSta6a.DivisionName,
	OrderedSta6a.Sta6a
FROM (
	SELECT 
		ScoredSta6a.DivisionSID,
		ScoredSta6a.Sta3n,
		ScoredSta6a.DivisionName, 
		ScoredSta6a.Sta6a,
		-- including tie breakers for score to guarantee same order every time
		ROW_NUMBER() OVER (PARTITION BY Sta6a ORDER BY Score DESC, DivisionName, DivisionSID) as N 
	FROM (
		SELECT
			Division.DivisionSID,
			Division.Sta3n,
			Division.DivisionName, 
			Division.Sta6a,
			(
				CASE
					WHEN SUBSTRING(Division.DivisionName, 1, 2) = 'ZZ' THEN -100
					ELSE 0
				END +
				CASE
					WHEN Institution.StaPa IS NULL THEN -50
					ELSE 0
				END +
				CASE
					WHEN Institution.InactiveFlag IS NOT NULL THEN -20
					ELSE 0
				END
			) AS Score
		FROM 
			CDWWork.Dim.Division
			LEFT JOIN CDWWork.Dim.Institution 
				ON Division.InstitutionSID = Institution.InstitutionSID
		WHERE
			-- The first three digits of Sta6a match Sta3n 
			Division.Sta3n = CASE
				WHEN ISNUMERIC(SUBSTRING(Sta6a, 1, 3)) = 1 THEN
					CONVERT(SMALLINT, SUBSTRING(Sta6a, 1, 3))
				ELSE NULL
			END
		) AS ScoredSta6a 
	) AS OrderedSta6a
WHERE
	N=1
--ORDER BY Sta6a
