﻿CREATE TABLE [App].[NVCC_Users] (
    [ID]                        INT           IDENTITY (1, 1) NOT NULL,
    [DomainPlusNetworkUserName] VARCHAR (50)  NOT NULL,
    [SaveDate]                  DATETIME      NULL,
    [Sta3n]                     INT           NOT NULL,
    [UserIEN]                   VARCHAR (50)  NULL,
    [IsCosignerRequired]        VARCHAR (5)   NULL,
    [Admin]                     BIT           NULL,
    [AccessCode]                VARCHAR (100) NULL,
    [VerifyCode]                VARCHAR (100) NULL,
    [ViaBApproved]              BIT           NULL,
    [Sta6a]                     VARCHAR (10)  NULL,
    [UserSessionId]             VARCHAR (100) NULL,
    [UserSessionSavedDateTime]  DATETIME      NULL,
    CONSTRAINT [PK_dbo.Users1] PRIMARY KEY CLUSTERED ([ID] ASC) WITH (DATA_COMPRESSION = PAGE)
);


GO
CREATE UNIQUE NONCLUSTERED INDEX [NVCC_Users_DomainPlusNetworkUserName]
    ON [App].[NVCC_Users]([DomainPlusNetworkUserName] ASC) WITH (DATA_COMPRESSION = PAGE);

