﻿CREATE TABLE [App].[NVCC_Announcement] (
    [AnnouncementID]     INT             IDENTITY (1, 1) NOT NULL,
    [AnnouncementTypeID] INT             NOT NULL,
    [Creator]            VARCHAR (50)    NOT NULL,
    [CreationDT]         DATETIME2 (7)   CONSTRAINT [DF_Announcement_CreationDT] DEFAULT (sysutcdatetime()) NOT NULL,
    [ExpirationDT]       DATETIME2 (7)   NULL,
    [Text]               NVARCHAR (4000) NULL,
    CONSTRAINT [PK_App_NVCC_Announcement] PRIMARY KEY CLUSTERED ([AnnouncementID] ASC) WITH (DATA_COMPRESSION = PAGE)
);
GO

CREATE NONCLUSTERED INDEX [AnnouncementTypeID_Announcement]
    ON [App].[NVCC_Announcement]([AnnouncementTypeID] ASC) WITH (DATA_COMPRESSION = PAGE);
GO

CREATE NONCLUSTERED INDEX [ExiprationDT_Announcement]
    ON [App].[NVCC_Announcement]([ExpirationDT] ASC) WITH (DATA_COMPRESSION = PAGE);
GO

