USE [NWIC_PanelMgmt]
GO

SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO

CREATE VIEW [app].[vProbs]

AS
--=================================================================================
--Requestor				: Non Va Coordinated Care Project
--Author                : Jerry Kohler - Northwest Innovation Center (NWIC)
--Object/SP Name		: NVCC_usp_GetProbs
--SERVER				: DNS   URL        
--Data Base				: NWIC_PanelMgmt
--Schema				: app
--Report				: N/A
--Folder				: N/A
--Report Loc            : N/A
--Job                   : None
--Job Loc               : None
--Note                  : 
--Date Created          : 02-18-2016 
--
--Last Changed          : 02-18-2016  
--Last Changed By		: Jerry Kohler - Northwest Innovation Center (NWIC)
--Reason For Change		: Request to also provide the station and station
--                        name.
--
--Purpose               : Retrieve a patient's active problem lists for provider
--                        review while compiling NVCC documentation.
--=================================================================================
   WITH PTProbs (Sta3n, StationName, ProblemListSID, PatientSID, ICD9SID, ICD10SID) AS
     (
      SELECT p.Sta3n
            ,App.udf_StationName (p.Sta3n) AS StationName
            ,p.ProblemListSID
            ,p.PatientSID
            ,p.ICD9SID
            ,p.ICD10SID
      FROM CDWWork.Outpat.ProblemList p 
      WHERE p.ActiveFlag = 'A'
        AND problemlistcondition <> 'H'
     )
   
   SELECT DISTINCT p.Sta3n
                  ,p.StationName
                  ,i.ICD9Code AS ICDCode
                  ,'ICD9' AS ICDVersion
                  ,left(i.ICD9DiagnosisText,50) AS Problem
   FROM PTProbs p
   left outer join PanelMgmt.vICD9 i on p.ICD9SID = i.ICD9SID
   WHERE p.ICD9SID <> 0

   UNION ALL
   
   SELECT DISTINCT p.Sta3n
                  ,p.StationName
                  ,k.ICD10Code AS ICDCode
                  ,'ICD10'     AS ICDVersion
                  ,left(k.ICD10DiagnosisText,50) AS Problem
   FROM PTProbs p
   left outer join PanelMgmt.vICD10 k on p.ICD10SID = k.ICD10SID
   WHERE p.ICD10SID <> 0;


GO
