DROP VIEW App.vNVCC_ProductionAccessLog
GO
CREATE VIEW App.vNVCC_ProductionAccessLog
AS
SELECT
	*
FROM
	NWIC_PanelMgmt.App.NVCC_AccessLog al
WHERE
	al.UserID NOT IN ('VHA20\DNS   DNS', 'DNS', 'VHA20\vhaporNordaT', 'DNS\DNS   KOHLEG', 'DNS\DNS   DNS') 
	AND (
		al.HostName = 'DNS.URL       ' OR
		--dev.nwic was being used to host users who could not covert to the VIA version during these dates
 		(al.HostName = 'DNS.URL       ' AND AccessDateTime BETWEEN '2016-10-19' AND '2016-11-15')
		OR al.Hostname = 'vaww.refdoc.va.gov' --the EWIS hosted national production site
	)
	AND al.Action = 'PDF'
