USE [NWIC_PanelMgmt]
GO
/****** Object:  StoredProcedure [PanelMgmt].[usp_SSNToSID]    Script Date: 3/10/2016 3:02:17 PM ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO

ALTER PROCEDURE [PanelMgmt].[usp_SSNToSID]
AS
--==================================================================================
--Requestor             : Non Va Coordinated Care Project, but produces a great
--                        general use table for any application.
--Author                : Jerry Kohler - Northwest Innovation Center
--Object/SP Name        : usp_SSNToSID
--Server                : DNS   URL        
--Data Base             : NWIC_PanelMgmt
--Schema                : PanelMgmt
--Report                : N/A
--Folder                : N/A
--Report Loc            : N/A
--Job                   : None
--Job Loc               : None
--Note                  : 
--Date Created          : 03-10-2016
--
--
--Last Changed          : 04-05-2016
--Last Changed By		: Jerry Kohler - NWIC
--Reason For Change		: Add test patient data.
--
--Purpose               : To create a table to translate between several types of
--                        patient identification:
--                           - SSN
--                           - SID
--                           - ICN
--                           - Name (last,first)
--                           - CPRSKey (first character of last name, comma, last4)
--==================================================================================

BEGIN

    IF (SELECT OBJECT_ID('App.SSNToSID')) IS NOT NULL
    DROP TABLE App.SSNToSID
    
    Create table App.SSNToSID
       (
        [Sta3n] [smallint] NOT NULL,
    	[PatientSSN] [varchar](50) NULL,
    	[PatientSID] [int] NULL,
    	[PatientICN] [varchar](55) NULL,
        [PatientName] [varchar](100) NULL,
        [CPRSKey] [varchar](10) NULL
       ) ON [DefFG] with (DATA_COMPRESSION = PAGE)
    

    Insert into App.SSNToSID([Sta3n]
                            ,[PatientSSN]
                            ,[PatientSID]
                            ,[PatientICN]
                            ,[PatientName]
                            ,[CPRSKey])
    (
     select [Sta3n]
           ,[PatientSSN]
           ,[PatientSID]
           ,[PatientICN]
           ,[PatientName]
           ,LEFT([PatientLastName], 1) + ',' + RIGHT([PatientSSN], 4) AS [CPRSKey]
     from CDWWork.SPatient.SPatient
     where [PatientSSN] Not In ('*Missing*', '*Unknown at this time*')
       and (Deceased = 'N' OR DateOfDeath is NULL)
       and (TestPatientFlag = 'N' OR TestPatientFlag is NULL)
       and PatientSSN Not Like '0000%'
       and PatientLastName Not Like 'ZZ%'
    )
    
    -- Insert any test patients you may want to include here.
    --                                                                                                  CPRS-Like
    --                              Sta3n    SSN         SID          ICN            Name               Search Key
    Insert into App.SSNToSID values (648, '000000159', 17502250,  '1011547954',	'ZZTEST,CARRIE',         'Z,0159')
    Insert into App.SSNToSID values (648, '000000497', 17530694,  '1012220080',	'ZZTEST,ANNA',           'Z,0497')
    Insert into App.SSNToSID values (648, '000000153', 17559856,  '1011542528',	'ZZTEST,ANDY',           'Z,0153')
    Insert into App.SSNToSID values (648, '000000011', 17609955,  '1011546137',	'ZZTEST,GISELA AMANDA',  'Z,0011')
    Insert into App.SSNToSID values (648, '000002222', 17631146,  '1012396218',	'ZZTEST,CAROL',	         'Z,2222')
    Insert into App.SSNToSID values (648, '000001987', 17633012,  '1012494561',	'ZZTEST,BLAKE',	         'Z,1987')
    Insert into App.SSNToSID values (648, '000000160', 17665704,  '1011564667',	'ZZTEST,CATHY',	         'Z,0160')
    Insert into App.SSNToSID values (648, '000001213', 26032119,  '1015788783',	'ZZTEST,BETTY A III',	 'Z,1213')
    Insert into App.SSNToSID values (648, '000006515', 800057847, '1016052270',	'ZZTEST,MINDY ROSE',	 'Z,6515')
    Insert into App.SSNToSID values (648, '000000014', 800159161, '1016424386',	'ZZTEST,CENDY',	         'Z,0014')
    Insert into App.SSNToSID values (648, '000002389', 800359466, '1017060395',	'ZZTEST,HERBERT SAMUEL', 'Z,2389')


    Create clustered index SSNToSID_Sta3n_PatientSSN
    on App.SSNToSID (Sta3n, PatientSSN)
    with (SORT_IN_TEMPDB = ON, DATA_COMPRESSION = PAGE)
    on [DefFG]

    
    Create nonclustered index SSNToSID_PatientICN on App.SSNToSID (PatientICN)
    include (PatientSID, PatientSSN, Sta3n)
    with (SORT_IN_TEMPDB = ON, DATA_COMPRESSION = PAGE)
    on [DefFG]

    
    Create nonclustered index SSNToSID_PatientSID on App.SSNToSID (PatientSID)
    include (PatientICN)
    with (SORT_IN_TEMPDB = ON, DATA_COMPRESSION = PAGE)
    on [DefFG]

    
    Create nonclustered index SSNToSID_PatientName on App.SSNToSID (PatientName)
    include (PatientICN, PatientSID, PatientSSN, Sta3n)
    with (SORT_IN_TEMPDB = ON, DATA_COMPRESSION = PAGE)
    on [DefFG]
    
    
    Create nonclustered index SSNToSID_CPRSKey on App.SSNToSID (CPRSKey)
    include (PatientICN, PatientSID, PatientSSN, Sta3n)
    with (SORT_IN_TEMPDB = ON, DATA_COMPRESSION = PAGE)
    on [DefFG]

END
