USE [NWIC_PanelMgmt]
GO

SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO

ALTER PROCEDURE [PanelMgmt].[usp_PMUpdateMasterLabIndexFromWorkload] 
AS
--=============================================================================================================
--Requestor				: Jianji Yang
--Author                : Steve Schreiner
--Object/SP Name		: [PanelMgmt].[usp_PMUpdateMasterLabIndexFromWorkload]
--SERVER				: DNS   URL        
--Data Base				: NWIC_PanelMgmt
--Schema				:    
--Report				: None Yet
--Folder				:
--Report Loc            : 
--Job                   : None
--Job Loc               : None
--Note                  : Runs in about 00:01:40
--Date Created          : 08-04-2014
--Last Changed          : 05-15-2015  
--Last Changed By		: Jianji Yang
--Reason For Change		: exclude NON-HDL from 668 which is assigned to LDL workload code                             
--Purpose               : Update Panel Management Master Lab Index table 
--                        with lab test with validate workload codes.
--===============================================================================================================
SELECT	ROW_NUMBER() OVER(
		ORDER BY a.TestGroup) as RecID,
		a.TestGroup,
		a.ResultForTestNumeric,
		a.TestSearchCriteria
INTO	#TempTestGroups
FROM	(select distinct
				tg.TestGroup,
				tg.ResultForTestNumeric,
				tg.TestSearchCriteria
		 from	[PanelMgmt].[PMMasterCohortLabTestGroups] as tg) as a


declare @BegRec int, @EndRec int

select	@EndRec = max(RecID)
from	#TempTestGroups as tg

declare @NextRec int
set		@NextRec = 1

while	(@NextRec <= @EndRec)
begin

declare @exestr varchar(5000)

declare @TestSearchName varchar(20),
		@ResultForTestNumeric varchar(4),
		@TestGroup varchar(30)

select	@TestSearchName = ''''+tg.TestSearchCriteria+'''',
		@ResultForTestNumeric = tg.ResultForTestNumeric,
		@TestGroup = ''''+tg.TestGroup+''''
from	#TempTestGroups as tg
where	tg.RecID = @NextRec

set @exestr ='
insert			[PanelMgmt].[PMMasterLabIndex]
select 
				li.LabChemTestSID,
				li.Sta3n,
				li.LabChemTestName,
				'+@ResultForTestNumeric+' as ResultForTestNumeric,
				getdate() as DateExtracted,
				'+@TestGroup+' as TestGroup,
				null as LOINC,
				nc.WorkloadCode
from			[CDWWork].[dim].[LabChemTest] as li
left outer join [CDWWork].[dim].[NationalVALabCode] as nc on
				li.NationalVALabCodeSID = nc.NationalVALabCodeSID
inner join		[PanelMgmt].[PMMasterCohortSite] as cs on
				li.Sta3n = cs.Sta3n
where			nc.WorkLoadCode like '+@TestSearchName+'
				and not exists (select ni.LabChemTestSID
				                from [PanelMgmt].[PMMasterLabIndex] as ni
								where li.LabChemTestSID = ni.LabChemTestSID
								      and li.Sta3n = ni.Sta3n)
order by		li.Sta3n'
exec (@exestr)

set				@NextRec = @NextRec + 1

end

-- remove non HDL lab with LDL workload code assigned. working with local CAC to reassign appropiate code 
-- LabChemTestSID	LabChemTestIEN	Sta3n	LabChemTestName	    LabChemPrintTestName	NLTNationalVALabCodeSID	NationalVALabCodeSID
-- 800223162                  7054    668   NON-HDL CHOLESTEROL NHDL                    800522569               800398429

delete FROM [NWIC_PanelMgmt].[PanelMgmt].[PMMasterLabIndex] where labchemtestname like '%NON-HDL%'

drop	table #TempTestGroups	

GO
