USE [NWIC_PanelMgmt]
GO

SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO

IF (SELECT OBJECT_ID('App.NVCC_usp_GetProbs')) IS NOT NULL 
DROP PROCEDURE App.NVCC_usp_GetProbs
GO

CREATE PROCEDURE [App].[NVCC_usp_GetProbs]
	-- Add the parameters for the stored procedure here
	@pid bigint -- this is the patientsid
AS
--=================================================================================
--Requestor				: Non Va Coordinated Care Project
--Author                : Jerry Kohler - Northwest Innovation Center (NWIC)
--Object/SP Name		: NVCC_usp_GetProbs
--SERVER				: DNS   DNSURL        
--Data Base				: NWIC_PanelMgmt
--Schema				: app
--Report				: N/A
--Folder				: N/A
--Report Loc            : N/A
--Job                   : None
--Job Loc               : None
--Note                  : 
--Date Created          : 01-14-2016
--
--Last Changed          : 03-16-2016  
--Last Changed By		: Jerry Kohler - Northwest Innovation Center (NWIC)
--Reason For Change		: TFS Project NVCC, item number 1368 - Eliminate 
--                        duplicate problem codes (Brian Diggs).
--
--Last Changed          : 02-18-2016  
--Last Changed By		: Jerry Kohler - Northwest Innovation Center (NWIC)
--Reason For Change		: Request to also provide the station and station
--                        name.
--
--Last Changed          : 01-19-2016  
--Last Changed By		: Jerry Kohler - Northwest Innovation Center (NWIC)
--Reason For Change		: Restructured the procedure into a CTE and single
--                        SELECT statement.  Added DISTINCT to eliminate
--                        duplicate returned rows, and tuned for performance.
--
--Changed               : 01-14-2016  
--Changed By		    : Jerry Kohler - Northwest Innovation Center (NWIC)
--Reason For Change		: Removed station parameter in order to expand the search
--                        for a patient's consults from a single station to any
--                        station a patient is associated with.
--
--Purpose               : Retrieve a patient's active problem lists for provider
--                        review while compiling NVCC documentation.
--=================================================================================
BEGIN
--declare @station int; set @station=508; declare @pid bigint; set @pid=1717444; declare @sflag int; set @sflag=1;
	-- SET NOCOUNT ON added to prevent extra result sets from
	-- interfering with SELECT statements.
   SET NOCOUNT ON;

--DECLARE @PID INT = 24257470  --zztelehealth patient with tons of data

   ;
   WITH PTProbs0 (Sta3n, StationName, ProblemListSID, PatientSID, ICD9SID, ICD10SID, RN, LastModifiedDate) AS
     (
      SELECT p.Sta3n
            ,App.udf_StationName (p.Sta3n) AS StationName
            ,p.ProblemListSID
            ,p.PatientSID
            ,p.ICD9SID
            ,p.ICD10SID
            ,RN = CASE
                When ICD9SID <> 0
                   Then ROW_NUMBER() OVER (PARTITION BY p.ICD9SID  ORDER BY p.LastModifiedDate DESC)
                When ICD10SID <> 0
                   Then ROW_NUMBER() OVER (PARTITION BY p.ICD10SID ORDER BY p.LastModifiedDate DESC)
                Else -999
                End
            ,p.LastModifiedDate
      FROM CDWWork.Outpat.ProblemList p 
      WHERE p.patientsid IN (Select PtSID From App.udf_AllPatientsSIDs (@pid))
        AND p.ActiveFlag = 'A'
        AND problemlistcondition <> 'H'
     ),

     PTProbs1 (Sta3n, StationName, ICDCode, ICDVersion, ProblemListSID, Problem, LastModifiedDate ,RN, SensitiveDx, AbuseDx, SickleDx, HIVDx) AS
     (
      SELECT p.Sta3n
            ,p.StationName
            ,i.ICD9Code AS ICDCode
            ,'ICD9' AS ICDVersion
            ,p.ProblemListSID
            ,left(i.ICD9DiagnosisText,50) AS Problem
            ,p.LastModifiedDate
            ,ROW_NUMBER() OVER (PARTITION BY left(i.ICD9DiagnosisText,50) ORDER BY p.LastModifiedDate DESC) AS RN
			, CASE WHEN dx.ICDSID is NOT NULL THEN 1 ELSE 0 END AS SensitiveDx
			, dx.AbuseDx
			, dx.SickleDx
			, dx.HIVDx
      FROM PTProbs0 p
      left outer join PanelMgmt.vICD9 i on p.ICD9SID = i.ICD9SID
	  LEFT OUTER JOIN [NWIC_PanelMgmt].[App].[NVCC_SensitiveDxCodes] dx
	  on dx.ICDSID = p.ICD9SID
      WHERE p.ICD9SID <> 0
        AND p.RN = 1

      UNION ALL
   
      SELECT p.Sta3n
            ,p.StationName
            ,k.ICD10Code AS ICDCode
            ,'ICD10'     AS ICDVersion
            ,p.ProblemListSID
            ,left(k.ICD10DiagnosisText,50) AS Problem
            ,p.LastModifiedDate
            ,ROW_NUMBER() OVER (PARTITION BY left(k.ICD10DiagnosisText,50) ORDER BY p.LastModifiedDate DESC) AS RN
			, CASE WHEN dx.ICDSID is NOT NULL THEN 1 ELSE 0 END AS SensitiveDx
			, dx.AbuseDx
			, dx.SickleDx
			, dx.HIVDx
      FROM PTProbs0 p
      left outer join PanelMgmt.vICD10 k on p.ICD10SID = k.ICD10SID
	    LEFT OUTER JOIN [NWIC_PanelMgmt].[App].[NVCC_SensitiveDxCodes] dx
	  on dx.ICDSID = p.ICD10SID
      WHERE p.ICD10SID <> 0
        AND p.RN = 1
    )

   SELECT Sta3n
         ,StationName
         ,ICDCode
         ,ICDVersion
         ,ProblemListSID
         ,Problem
         ,LastModifiedDate
		 ,SensitiveDx, AbuseDx, SickleDx, HIVDx
   FROM PTProbs1
   WHERE RN = 1
   ORDER BY LastModifiedDate DESC;

END;

--exec nva.getProbs @station=508, @pid=1717444;
--exec nva.getSensDxCodes;

GO

EXEC sp_SignAppObject 'NVCC_usp_GetProbs';