USE [NWIC_PanelMgmt]
GO

SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO

IF (SELECT OBJECT_ID('App.NVCC_usp_GetConsults')) IS NOT NULL 
DROP PROCEDURE App.NVCC_usp_GetConsults
GO

CREATE PROCEDURE [App].[NVCC_usp_GetConsults]
	-- Add the parameters for the stored procedure here
	@pid bigint -- this is the patientsid

-- NOTICE:
-- Do not edit the stored procedure live on the server. Code to generate
-- the procedures is stored in the project repository. Any changes made
-- that are not recorded in the repository will be overwritten.

AS
--=================================================================================
--Requestor				: Non Va Coordinated Care Project
--Author                : Jerry Kohler (Original script by Dr. Charles Demosthenes)
--Object/SP Name		: NVCC_usp_GetConsults
--SERVER				: DNS   DNS.URL        
--Data Base				: NWIC_PanelMgmt
--Schema				: app
--Report				: N/A
--Folder				: N/A
--Report Loc            : N/A
--Job                   : None
--Job Loc               : None
--Note                  : 
--Date Created          : 01-12-2016
--Last Changed          : 12-01-2016
--Last Changed By		: Brian Diggs - Northwest Innovation Center (NWIC)
--Reason For Change		: Convert from using [App].[vPCMMPatientProviders] to
--						: [App].[PCMMCurrentPatientProviderRelationship]
--
--Last Changed          : 06-22-2016
--Last Changed By		: Brian Diggs - Northwest Innovation Center (NWIC)
--Reason For Change		: Bringing in primary provider and other fields to
--						  be able to recreate bottom block of consult.
--                        Change likely done by Jonathan Duckart but was
--                        never synced with the source repository.
--
--Last Changed          : 01-12-2016  
--Last Changed By		: Jerry Kohler - Northwest Innovation Center (NWIC)
--Reason For Change		: Removed station parameter in order to expand the search
--                        for a patient's consults from a single station to any
--                        station a patient is associated with.
--
--Purpose               : Retrieve a patient's consults from within the last 180
--                        days for inclusion into NVCC documentation.
--=================================================================================

BEGIN
   -- SET NOCOUNT ON added to prevent extra result sets from
   -- interfering with SELECT statements.
   SET NOCOUNT ON;

	WITH
		PTSID AS (
			SELECT PTSid 
			FROM [App].[udf_AllPatientsSIDs](@pid)
		)
   SELECT
      c.Sta3n
     ,App.udf_StationName (c.Sta3n) AS StationName
     ,c.ToRequestServiceName
     ,cast(c.RequestDateTime as date) AS RequestDate
     ,c.CPRSStatus
     ,c.CPRSOrderSID
     ,c.Consultsid
   	 ,c.ConsultIEN
     ,c.PatientSID
     ,c.ToRequestServiceSID
     ,c.RequestType
   	 ,c.OrderStatusSID
     ,c.RecentActivityTypeSID
     ,c.RecentActivityType
   	 ,c.SendingStaffSID
     ,c.Urgency
     ,c.InpatOutpat
   	 ,iif(c.ProvisionalDiagnosis is null, ' ', c.ProvisionalDiagnosis) AS ProvDx
   	 ,iif(c.ProvisionalDiagnosisCode is null, ' ', c.ProvisionalDiagnosisCode) AS ProvDxCode
   	 ,c.TIUDocumentSID
     ,c.EarliestDate
     ,r.ConsultReason
	 ,l.LocationName as FromService
	 , st.StaffName as RequestingProvider
	 , pcmm.PrimaryProvider
	 , pcmm.Team
	 , sp.Eligibility + ' ' + sp.EligibilityStatus as PrimaryEligibility
   FROM CDWWork.Con.Consult c
   JOIN CDWWork.SPatient.SConsultReason r
		ON r.ConsultSID = c.ConsultSID
	JOIN CDWWork.dim.Location l
		ON l.LocationSID=c.FromLocationSID
	JOIN CDWWork.SStaff.SStaff st
		ON st.StaffSid=c.SendingStaffSID
	LEFT JOIN (
		SELECT TOP 1 * 
		FROM 
			App.PCMMCurrentPatientProviderRelationship pp
			INNER JOIN PTSid
				ON pp.PatientSID = PTSid.PTSid
		ORDER BY RelationshipStartDate DESC) pcmm
		ON pcmm.PatientSID=c.PatientSID
	JOIN CDWWork.SPatient.SPatient sp
		ON sp.patientSID=c.PatientSID
	INNER JOIN PTSid ptsid
		ON ptsid.PTSid = c.PatientSID
   WHERE c.ToRequestServiceName not like 'NON-FORM%' 
   	 AND c.CPRSStatus not in ('DISCONTINUED','CANCELLED','COMPLETE') 
     AND c.RequestDateTime >= CAST(dateadd(dd, -365, getdate()) AS DATE)
   ORDER BY c.requestdatetime;
END
GO

EXEC sp_SignAppObject 'NVCC_usp_GetConsults';

