USE [NWIC_PanelMgmt]
GO

/****** Object:  StoredProcedure [app].[NVCC_usp_GetAllergies]    Script Date: 1/12/2016 1:57:34 PM ******/
SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO

ALTER PROCEDURE [app].[NVCC_usp_GetAllergies]
       @pid bigint -- this is the patient's database sid

AS
--=================================================================================
--Requestor				: Non Va Coordinated Care Project
--Author                : Jerry Kohler (Original script by Dr. Charles Demosthenes)
--Object/SP Name		: NVCC_usp_GetAllergies
--SERVER				: DNS   DNS.URL        
--Data Base				: NWIC_PanelMgmt
--Schema				: nva
--Report				: N/A
--Folder				: N/A
--Report Loc            : N/A
--Job                   : None
--Job Loc               : None
--Note                  : 
--Date Created          : 01-12-2016
--
--Changed               : 03-03-2016  
--Changed By		    : Jerry Kohler - Northwest Innovation Center (NWIC)
--Reason For Change		: Eliminate multiple records with same allergen,
--                        only return the one with the latest verified date.
--
--Changed               : 02-18-2016  
--Changed By		    : Jerry Kohler - Northwest Innovation Center (NWIC)
--Reason For Change		: Request to also provide the name of the station.
--
--Changed               : 01-12-2016  
--Changed By		    : Jerry Kohler - Northwest Innovation Center (NWIC)
--Reason For Change		: Removed station parameter in order to expand the search
--                        for a patient's allergies from a single station to any
--                        station a patient is associated with.
--
--Purpose               : Retrieve a patient's allergies for inclusion into NVCC
--                        documentation
--=================================================================================
BEGIN

   -- SET NOCOUNT ON added to prevent extra result sets from
   -- interfering with SELECT statements.
   SET NOCOUNT ON;


   WITH Allergies AS
       (
        SELECT a.Sta3n
              ,App.udf_StationName (a.Sta3n) AS StationName
              ,a.AllergySID
              ,a.PatientSID
              ,a.OriginationDateTime
              ,a.VerificationDateTime
              ,a.AllergicReactant as Allergy
              ,ROW_NUMBER() OVER (PARTITION BY a.AllergicReactant ORDER BY a.VerificationDateTime DESC) AS RN
        FROM CDWWork.Allergy.Allergy a
        JOIN CDWWork.Dim.Sta3n b ON b.Sta3n = a.Sta3n
        WHERE a.PatientSID in (select PTSid from [App].[udf_AllPatientsSIDs](@pid))
          AND a.EnteredInErrorFlag IS NULL
       )

   SELECT Sta3n
         ,StationName
         ,AllergySID
         ,PatientSID
         ,OriginationDateTime
         ,VerificationDateTime
         ,Allergy
   FROM Allergies
   WHERE RN = 1
   ORDER BY Allergy
   --exec [app].[NVCC_usp_GetAllergies] @pid=1717444
END;
