-- SETUP TEMP TABLES
-- Not needed when putting into real tables
SELECT *
INTO #UsersV2
FROM App.NVCC_UsersV2
WHERE 1 = 0

SELECT *
INTO #UserFacilities
FROM App.NVCC_UserFacilities
WHERE 1 = 0

-- CLEAR RECEIVING TABLES
TRUNCATE TABLE #UsersV2
TRUNCATE TABLE #UserFacilities

-- INSERT TABLE VALUES
-- First put in user names to create userID
INSERT INTO #UsersV2
SELECT DomainPlusNetworkUserName AS UserName
FROM
	App.NVCC_Users

-- Second merge original user table to new to get the appropriate userID
-- cast columns and insert them
INSERT INTO #UserFacilities
SELECT
	#UsersV2.UserId,
	cast(NVCC_Users.Sta3n as smallint) AS Sta3n,
	cast(NVCC_Users.Sta6a as varchar(50)) AS Sta6a,
	cast(NVCC_Users.UserSessionSavedDateTime as datetime2(0)) AS LastAuthDateTime,
	NVCC_Users.ViaBApproved AS ViaB,
	ISNULL(NVCC_Users.[Admin], 0) AS [admin]
FROM
	App.NVCC_Users
	INNER JOIN #UsersV2
		ON NVCC_Users.DomainPlusNetworkUserName = #UsersV2.UserName

---- VERIFICATION
--SELECT * from #UsersV2
--SELECT * from #UserFacilities

--SELECT * from #UserFacilities where admin = 1
