﻿using System;
using System.Net;
using System.Net.Http;

namespace NVCC.WebUI.Utilities
{
    public static class CdwHttpClient
    {
        private const string url = "http://DNS.URL       /WCF_WebAPI/ClinicalDataServicesCDW/";

        public static HttpClient GetClient()
        {
            string myUri = url;
            CredentialCache cc = new CredentialCache();
            cc.Add(new Uri(myUri), "NTLM", CredentialCache.DefaultNetworkCredentials);

            HttpClientHandler handler = new HttpClientHandler();
            handler.Credentials = cc;
            HttpClient client = new HttpClient(handler);
            client.BaseAddress = new Uri(myUri);
            client.DefaultRequestHeaders.Accept.Clear();
            client.DefaultRequestHeaders.Accept.Add(
                new System.Net.Http.Headers.MediaTypeWithQualityHeaderValue("application/json"));
            return client;
        }
    }
}