﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using NVCC.Models;
using NVCC.WebUI.Utilities;

namespace NVCC.WebUI.Models
{
    public class MdoConsultViewModel
    {
        public MdoConsultViewModel()
        {
        }

        public MdoConsultViewModel(MdwsConsult mdwsConsult)
        {
            if (mdwsConsult == null)
                throw new NullReferenceException("mdwsConsult");
            MdwsConsult = mdwsConsult;
            var consultText = mdwsConsult.ConsultText.Replace("\n", "");
            Urgency = GetUrgency(consultText);
            ClinicallyIndicatedDate = GetClinicallyIndicatedDate(consultText);
            ConsultDate = GetConsultDateOnly(mdwsConsult.ConsultDate);

        }
        public string ConsultDate { get; private set; }
        public MdwsConsult MdwsConsult { get; set; }
        public string Urgency { get; set; }
        public string ClinicallyIndicatedDate { get; set; }
        public string EligibilityDate { get; set; }

        private string GetUrgency(string consultText)
        {
            var urgencyStartText = "Urgency:  ";
            var urgencyStopText = "Earliest Appr. Date:";
            string urgency = StringHelper.GetParsedText(consultText, urgencyStartText, urgencyStopText);

            if (string.IsNullOrEmpty(urgency) || urgency.Length > 20)
            {
                urgencyStopText = "To facilitate Urgent Scheduling";
                urgency = StringHelper.GetParsedText(consultText, urgencyStartText, urgencyStopText);
            }
            if (string.IsNullOrEmpty(urgency))
            {
                urgency = "UNK";
            }
            return StringHelper.RemoveNonAlphaNumeric(urgency);
        }

        private string GetClinicallyIndicatedDate(string consultText)
        {
            var startText = "Earliest Appr. Date:  ";
            var stopText = "Orderable Item:";
            string returnText = StringHelper.GetParsedText(consultText, startText, stopText);

            if (string.IsNullOrEmpty(returnText))
            {
                returnText = "UNK";
            }
            return returnText;
        }
        private string GetConsultDateOnly(string consultDateTime)
        {
            if (string.IsNullOrEmpty(consultDateTime))
                return null;
            var consultDateArray = consultDateTime.Split('.');
            return consultDateArray[0];
        }
    }
}