﻿using Moq;
using Ninject;
using Ninject.Web.Common;
using NVCC.Models;
using NVCC.Repos.MdwsRepository;
using NVCC.Repos.PatientRepository;
using NVCC.Repos.UserRepository;
using NVCC.WebUI.Utilities;
using System;
using System.Collections.Generic;
using System.Web.Mvc;

namespace NVCC.WebUI.Infrastructure
{
    public class NinjectDependencyResolver : IDependencyResolver
    {
        private IKernel kernel;

        public NinjectDependencyResolver(IKernel kernelParam)
        {
            kernel = kernelParam;
            AddBindings();
        }

        public object GetService(Type serviceType)
        {
            return kernel.TryGet(serviceType);
        }

        public IEnumerable<object> GetServices(Type serviceType)
        {
            return kernel.GetAll(serviceType);
        }

        private void AddBindings()
        {
            Mock<IPatientRepository> patientMock = new Mock<IPatientRepository>();
            Mock<IUserRepository> userMock = new Mock<IUserRepository>();
            Mock<IUserSessionManager> userSessionMock = new Mock<IUserSessionManager>();
            Mock<IPatientProfileService> patientProfileServiceMock = new Mock<IPatientProfileService>();

            patientMock.Setup(m => m.GetPatient(It.IsAny<int>()))
                .Returns(FakeDataManager.GetPatient());

            patientMock.Setup(m => m.GetPatient(It.IsAny<string>(), It.IsAny<short>()))
               .Returns(FakeDataManager.GetPatient());

            patientMock.Setup(m => m.GetProblemList(It.IsAny<int>()))
                .Returns(FakeDataManager.GetProblemList());

            patientMock.Setup(m => m.GetAppointments(It.IsAny<int>()))
                .Returns(FakeDataManager.GetAppointmentList());

            patientMock.Setup(m => m.GetMedications(It.IsAny<int>()))
                .Returns(FakeDataManager.GetMedicationList());

            patientMock.Setup(m => m.GetLabs(It.IsAny<int>()))
                .Returns(FakeDataManager.GetLabList());

            //patientProfileServiceMock.Setup(m => m.GetPatientProfile(It.IsAny<int>()))
            //    .Returns(FakeDataManager.GetPatientProfile());
            //kernel.Bind<IPatientRepository>().ToConstant(patientMock.Object).InRequestScope();
            //kernel.Bind<IUserRepository>().ToConstant(userMock.Object).InRequestScope();

            kernel.Bind<NwicPanelMgmtModel>().ToSelf().InRequestScope();
            kernel.Bind<IPatientRepository>().To<PatientRepository>().InRequestScope();
            kernel.Bind<IViaRepository>().To<ViaRepository>().InRequestScope();     
            kernel.Bind<IUserRepository>().To<UserRepository>().InRequestScope();
            kernel.Bind<IPatientProfileService>().To<PatientProfileService>().InRequestScope();
            kernel.Bind<IUserSessionManager>().To<UserSessionManager>().InRequestScope();
            kernel.Bind<IUserService>().To<UserService>().InRequestScope();
            kernel.Bind<ICurrentUser>().To<CurrentUser>().InRequestScope();
        }
    }
}