﻿using NVCC.Models;
using System;
using System.Collections.Generic;

namespace NVCC.WebUI.Infrastructure
{
    public static class FakeDataManager
    {
        public static IList<Medication> GetMedicationList()
        {
            var medList = new List<Medication> 
            { 
                new Medication 
                {
                MedicationId = 1, MedicationNameWithDose="TEST ATORVASTATIN CALCIUM 10MG TAB", IssueDate = new DateTime(2015, 12, 01), Quantity = "Qty:90", FillNumber=1, MaxRefills=4 
                }, 
                new Medication 
                {
                MedicationId = 2, MedicationNameWithDose="TEST TERAZOSIN HCL 2MG CAP", IssueDate = new DateTime(2015, 12, 10), Quantity = "Qty:30", FillNumber=2, MaxRefills=4 
                }, 
                 new Medication 
                {
                MedicationId = 3, MedicationNameWithDose="TEST LOSARTAN POTASSIUM 100MG TAB", IssueDate = new DateTime(2015, 12, 15), Quantity = "Qty:90", FillNumber=3, MaxRefills=3 
                }
            };

            return medList;
        }

        public static MappedUser GetMappedUser(bool viabApproved=false)
        {
            return new MappedUser
            {
                AccessCode = "xyz", 
                Admin = true, 
                DomainPlusNetworkUserName = "DNS\\DNS   DNS", 
                Station=648, 
                UserIen = "12345", 
                VaUserId = 9, 
                VerifyCode = "whateva",
                ViaBApproved = viabApproved
            };
        }

        public static IList<ProblemDiagnosis> GetProblemList()
        {
            var problemList = new List<ProblemDiagnosis> 
            { 
                new ProblemDiagnosis 
                {
                ProblemDiagnosisId = 1, IcdCode = "704.01", Problem = "ALOPECIA AREATA (ICD9 704.01)"
                }, 
                new ProblemDiagnosis 
                {
                    ProblemDiagnosisId = 2, IcdCode = "DIZZINESS AND GIDDINESS"
                }, 
                   new ProblemDiagnosis 
                {
                    ProblemDiagnosisId = 3, IcdCode = "HIRSUTISM"
                }
            };
            return problemList;
        }

        public static IList<Appointment> GetAppointmentList()
        {
            var apptList = new List<Appointment> 
            { 
                new Appointment 
                {
                AppointmentId = 1, AppointmentDateTime = "01/01/2016", Location = "EKG OUTPT-4A103" 
                }, 
                new Appointment 
                {
                AppointmentId = 2, AppointmentDateTime = "02/01/2016", Location = "PRE OP-4C190" 
                }, 
                   new Appointment 
                {
                AppointmentId = 3, AppointmentDateTime = "03/01/2016", Location = "AMB SURG UROLOGY-X" 
                }
            };
            return apptList;
        }

        public static IList<Lab> GetLabList()
        {
            var labList = new List<Lab> 
            { 
                new Lab 
                {
                LabId = 1, LabTestName="Hgb", LabSpecimenDate = new DateTime(2015, 12, 01), LabResultValue="123"
                }, 
                new Lab 
                {
                LabId = 2, LabTestName="Hct", LabSpecimenDate = new DateTime(2015, 12, 01), LabResultValue="234"
                }, 
                 new Lab 
                {
                LabId = 3, LabTestName="WBC", LabSpecimenDate = new DateTime(2015, 12, 01), LabResultValue="345"
                }
            };
            return labList;
        }

        public static Patient GetPatient()
        {
            var patient = new Patient
                {
                    PatientName = "Nazareth, Brian of",
                    PatientSsn = "555555555",
                    DateOfBirth = new DateTime(2000, 12, 25),
                    PatientSid = 99,
                    Station = 999
                };
            return patient;
        }

        public static PatientProfile GetPatientProfile()
        {
            PatientProfile patientProfile = new PatientProfile();
            patientProfile.Appointments = GetAppointmentList();
            patientProfile.Labs = GetLabList();
            patientProfile.Medications = GetMedicationList();
            patientProfile.ProblemDiagnoses = GetProblemList();
            patientProfile.Patient = GetPatient();

            return patientProfile;
        }

        public static IList<Consult> GetConsults()
        {
            var consultList = new List<Consult> 
            { 
                new Consult 
                {
                    ConstultId = 1, ConsultReason = "some reason", ToRequestServiceName = "Request Service 1", EarliestDate = DateTime.Parse("2015-01-01"), CprsStatus = "ACTIVE"
                }, 
                new Consult 
                {
                 ConstultId = 2, ConsultReason = "some reason 2", ToRequestServiceName = "Request Service 1", EarliestDate = DateTime.Parse("2015-01-01"), CprsStatus = "ACTIVE"
                }, 
                 new Consult 
                {
                 ConstultId = 3, ConsultReason = "some reason 3", ToRequestServiceName = "Request Service 1", EarliestDate = DateTime.Parse("2015-01-01"), CprsStatus = "ACTIVE"
                }
            };
            return consultList;
        }

        public static IList<Authorization> GetAuthorizations()
        {
            var authList = new List<Authorization> 
            { 
                new Authorization 
                {
                    AuthorizationId = "1", AuthorizationText = "This is authorization text 1", AuthorizationTitle = "NON VA CHOICE TEST"
                }, 
                new Authorization 
                {
                  AuthorizationId = "2", AuthorizationText = "This is authorization text 2", AuthorizationTitle = "NON VA CHOICE TEST"
                }, 
                 new Authorization 
                {
                  AuthorizationId = "3", AuthorizationText = "This is authorization text 3", AuthorizationTitle = "NON VA CHOICE TEST"
                }
            };
            return authList;
        }

        public static IList<RadiologyReport> GetRadiologyReports()
        {
            var radList = new List<RadiologyReport> 
            { 
                new RadiologyReport 
                {
                    RadiologyReportId = "1", ReasonForStudy = "Some reason", ImpressionText = "Some Impression 1", ProcedureName="TEST PROCEDURE 1"
                }, 
                new RadiologyReport 
                {
                    RadiologyReportId = "1", ReasonForStudy = "Some reason", ImpressionText = "Some Impression 2" , ProcedureName="TEST PROCEDURE 2"             
                }, 
                 new RadiologyReport 
                {
                RadiologyReportId = "1", ReasonForStudy = "Some reason", ImpressionText = "Some Impression 3", ProcedureName="TEST PROCEDURE 3"
                }
            };
            return radList;
        }

        public static ViaUser GetViaUser(bool? viaBApproved = false, string faultMessage=null)
        {
            var viaUser = new ViaUser {QueryBean = new ViaQueryBean()};
            viaUser.ViaBApproved = viaBApproved;
            if (faultMessage != null)
            {
                viaUser.Fault = true;
                viaUser.FaultMessage = faultMessage;
            }
            return viaUser;
        }

        // Users:
        // 0: Fred Flintstone, with ViaB and PHIPII and an active session
        // 1: Fred Flintstone with no facilities at all
        // 2: Fred Flintstone, with ViaB and PHIPII but no active session
        // 3: Fred Flintstone, without ViaB and with PHIPII and an active session
        // 4: Fred Flintstone, unknown ViaB, no PHIPII, no active session
        public static User GetUser(int i = 0)
        {
            return new User[]
            {
                new User()
                {
                    ApplicationUserID = 0,
                    DomainPlusNetworkUserName = "DNS\\DNS   DNS",
                    Name = "Flintstone, Fred",
                    CurrentDefaultFacility = (short)888,
                    Facilities = new Dictionary<short, UserFacility>()
                    {
                        {
                            (short)888,
                            new UserFacility
                            {
                                sta3n = (short)888,
                                sta6a = "888",
                                StationName = "Bedrock",
                                LocationName = "BEDROCK",
                                LastAuthDateTime = DateTime.UtcNow,
                                ViaB = true,
                                PHIPII = true,
                                VIAToken = "XXXXX",
                                VIATokenExpiration = DateTime.UtcNow.AddHours(4),
                                Admin = false
                            }
                        }
                    }
                },
                new User()
                {
                    ApplicationUserID = 1,
                    DomainPlusNetworkUserName = "DNS\\DNS   DNS",
                    Name = "Flintstone, Fred",
                    CurrentDefaultFacility = (short)0,
                    Facilities = new Dictionary<short, UserFacility>()
                },
                new User()
                {
                    ApplicationUserID = 2,
                    DomainPlusNetworkUserName = "DNS\\DNS   DNS",
                    Name = "Flintstone, Fred",
                    CurrentDefaultFacility = (short)888,
                    Facilities = new Dictionary<short, UserFacility>()
                    {
                        {
                            (short)888,
                            new UserFacility
                            {
                                sta3n = (short)888,
                                sta6a = "888",
                                StationName = "Bedrock",
                                LocationName = "BEDROCK",
                                LastAuthDateTime = DateTime.UtcNow.AddHours(-12),
                                ViaB = true,
                                PHIPII = true,
                                VIAToken = "XXXXX",
                                VIATokenExpiration = DateTime.UtcNow.AddHours(-8),
                                Admin = false
                            }
                        }
                    }
                },
                new User()
                { // what would viaB false look like?
                    ApplicationUserID = 3,
                    DomainPlusNetworkUserName = "DNS\\DNS   DNS",
                    Name = "Flintstone, Fred",
                    CurrentDefaultFacility = (short)888,
                    Facilities = new Dictionary<short, UserFacility>()
                    {
                        {
                            (short)888,
                            new UserFacility
                            {
                                sta3n = (short)888,
                                sta6a = "888",
                                StationName = "Bedrock",
                                LocationName = "BEDROCK",
                                LastAuthDateTime = DateTime.UtcNow,
                                ViaB = false,
                                PHIPII = true,
                                VIAToken = "XXXXX",
                                VIATokenExpiration = DateTime.UtcNow.AddHours(4),
                                Admin = false
                            }
                        }
                    }
                },
                new User()
                {
                    ApplicationUserID = 4,
                    DomainPlusNetworkUserName = "DNS\\DNS   DNS",
                    Name = "Flintstone, Fred",
                    CurrentDefaultFacility = (short)888,
                    Facilities = new Dictionary<short, UserFacility>()
                    {
                        {
                            (short)888,
                            new UserFacility
                            {
                                sta3n = (short)888,
                                sta6a = "888",
                                StationName = "Bedrock",
                                LocationName = "BEDROCK",
                                LastAuthDateTime = null,
                                ViaB = null,
                                PHIPII = false,
                                VIAToken = "",
                                VIATokenExpiration = null,
                                Admin = false
                            }
                        }
                    }
                }
            }[i];
        }
    }
}